local raygen     = require( 'saotrace.raygen' )
local extent     = require( 'saotrace.raygen.extent' )
local source     = require( 'saotrace.raygen.source' )
local coords     = require( 'saotrace.raygen.coords')
local spectrum_utils = require( 'saotrace.raygen.spectrum.utils')
local vobj       = require( 'saotrace.raygen.validate' ).vobj:new()
vobj:setopts{ check_spec = false }
local tables     = require( 'saotrace.suplib.tables' )
local load       = require( 'saotrace.raygen.source.load' )
local system     = require( 'saotrace.raygen.system' )
local assert     = assert
local tostring   = tostring
local pairs      = pairs
local ipairs     = ipairs
local unpack     = unpack
local type       = type

local M = {}
setfenv( 1, M )

local function create_func( name, modify_vspec )

   local vspec = {}
   for k,v in pairs( extent.vspec[name] ) do
      vspec[k] = type(v) == 'table' and tables.copy( v ) or v
   end

   if modify_vspec ~= nil then
      modify_vspec(vspec)
   end

   -- this must be common between the postcall function in the vspec
   -- and the returned closure
   local spectra

   vspec.name = {
      type = 'string',
      default = function()
		   return true,
		   name .. tostring(system.nsources()+1)
		end,

      postcall = function( arg, vfarg )
		    spectra:tag( arg .. ':' )
		 end,
      order = 1,
   }


   return function( ... )

	     spectra = spectrum_utils.Spectra:new( )

	     vobj:setopts{ udata = { spectra = spectra },
			   ordered = true,
			   check_spec = false
			}

	     local ok, args = vobj:validate( vspec, ... )
	     assert( ok, args )

	     args.spectrum = nil

	     source.create( args.name, {
			       spectrum = spectra:spectra(),
			       extent = extent[name]( args )
			    }
			 )

	  end


end


function create( modify_vspec )


   -- keep track of the number of sources created so that
   -- 1) automatic creation of names works
   -- 2) default() will notice that no source has been created
   --    and create one

   local wrappers = {}

   -- generate a closure around the source.create routine to use
   -- the passed mvspec and auto-create source names
   for k in pairs( extent.vspec ) do
      wrappers[k] = create_func( k, modify_vspec )
   end

   -- provide some backwards compatibility; this should be called as a
   -- raygen sources cleanup function
   -- e.g. saotrace.raygen.config.scripts.sources.cleanup = default
   wrappers.default =
      function ( args )

	 -- if none of the source functions were called, then
	 -- maybe just a spectrum was specified;
	 if system.nsources() == 0 then

	    local nargs = tables.extract( args, { 'name', 'spectrum', 'position' } );

	    -- in case just the coords are specified
	    if not nargs.position then
	       nargs.position = tables.extract( args, { 'theta', 'phi', 'coord', 'el', 'az' } )
	    end

	    return wrappers.point( nargs  )

	 end

      end

   return wrappers


end

return M
