-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of chandra.saotrace.aperture
--
-- saotrace.aperture is free software: you can redistribute it and/or
-- modify it under the terms of the GNU General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

local setmetatable = setmetatable
local require = require

local BaffleSet = require( 'chandra.saotrace.aperture.baffles.set' )
local tables = require( 'saotrace.suplib.tables' )

module( ... )

function create_baffles( args )


   args = args or {}


   -- args may be an environment ; cleanse of things we don't want
   setmetatable( args, nil )

   args = tables.filter_matched_keys( BaffleSet.read_config_vspec, args )

   -- construct baffles; this'll do the argument validation
   local baffles = BaffleSet:new( args )

   -- construct the assemblies for this baffle set
   baffles:construct_baffles( debug_plate )

end


config = require('saotrace.config').aperture
config.script.func = create_baffles
