-- --8<--8<--8<--8<--
--
-- Copyright (C) 2011 Smithsonian Astrophysical Observatory
--
-- This file is part of raygen
--
-- raygen is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
-- -->8-->8-->8-->8--

-- System configuration information


local _M = {}


local script_spec = {

   vtable = {

      func = { type = { 'string', 'function' }, optional = true },
      args = { type = 'table', optional = true },
      cleanup = { type = { 'string', 'function' }, optional = true },

   }

}


_M.specs = {

   -- position of node
   node = { type = 'number', default = 0 },

   -- default log level
   loglevel = { enum = { "DEBUG", "INFO", "WARN", "ERROR", "FATAL" }, default = "INFO" },

   -- this is set by raygen from its command line parameters,
   -- which is done after the configuration Lua script (cfgpars)
   -- is executed.  So, it must be optional, else the first
   -- setting will trigger an error
   logfile = { type = 'string', optional = true },


   jitter = {
      vtable = {
	 -- use intersection of jitter time ranges for time.
	 -- appropriate bound is ignored if config.tmin or
	 -- config.tmax are set
	 tintersect = { type = 'boolean', default = true }
      },
   },

   scripts = {

      vtable = {
	 entrance_aperture = script_spec,
	 sources = script_spec,
	 jitter = script_spec,
      }

   },

   output = {

      vtable = {

	 eap_id = { type = 'boolean', default = false },

      }

   },

}

return _M
