local system = require( 'saotrace.raygen.system' )

local _M = { stash = {} }

local _NAME = 'saotrace.raygen'

local intrinsics = { 'extent',
		     'spectrum',
		     'jitter',
		     'ea',
		     'source',
		  }

local function mock_func( mod, func )

   return function( ... )

	     _M.stash[#_M.stash+1] = { mod = mod,
				 func = func,
				 ... }
	  end

end


-- create mock functions for the intrinsics if the intrinsics don't exist.
-- this is used during pure Lua testing, when the actual raygen intrinsics
-- aren't loaded

_M.source = {

   finish = function ( ... )

	       system.inc_nsources()
	       _M.stash[#_M.stash+1] = { mod = 'source',
                                      func = 'finish',
                                      ... }
	    end
}

for _, v in pairs( intrinsics ) do

   local module = _NAME .. '.' .. v

   if not _M[v] then
      _M[v] = {}
   end
   package.loaded[_NAME .. '.intrinsic.' .. v] = _M[v]

   local mod = require( module )

   for func in pairs( mod.vspec ) do

      if not _M[v][func] then

	 _M[v][func] = mock_func( v, func )

      end
   end
end

return _M
