-- saotrace.config.raygen.scripts.entrance_aperture script to
-- create a ring & spoke pattern within an annulus

local string = require('string')
local error = error
local pairs = pairs
local assert = assert

local raygen = require( 'saotrace.raygen' )
local ea   = require('saotrace.raygen.ea')
local utils = require('saotrace.raygen.ea.utils.ring_n_spoke')
local tables = require('saotrace.suplib.tables' )
local vobj = require( 'saotrace.raygen.validate' ).vobj:new()

local M = {}
setfenv( 1, M )

local vspec = tables.copy( utils.vspec.ring_n_spoke, true )
vspec.match = nil
vspec.mode = nil
vspec.callback = nil
vspec.shell = { type = 'posnum' }
vspec.area = { type = 'posnum', default = 1 }

-- create a vtable for the aperture parameters reflecting the type of
-- aperture
vspec.aperture = {

   default = { type = 'pinhole' },
   vtable = function ( arg )

	       if arg.type and ea.vspec[arg.type] then

		  local vtable = tables.copy( ea.vspec[arg.type][2].vtable )

		  -- these get generated; don't let the user set them
  		  for _,field in pairs{ 'x', 'y', 'z', 'id'} do
		     vtable[field] = nil
		  end
		  vtable.type = { }
		  return true, vtable

	       else

		  return false, "unknown entrance aperture type: " .. arg.type

	       end
	    end
}


-- this reads an RDB file which is indexed by shell
function entrance_aperture( ... )

   local ok, args = vobj:validate( vspec, ... )

   assert( ok, args )


   local area = args.area

   args.match = { shell = args.shell }
   args.mode = 'callback'

   args.callback =
      function( par )

	 -- restrict parameters to just those applicable to the aperture type
	 local t = tables.merge( {},
				 par.spot,
				 args.aperture,
				 { id = par.id }
			      )

	 local ea_vspec = ea.vspec[args.aperture.type][2].vtable

	 local pars =
	    tables.filter_matched_keys( ea_vspec, t )

	 ea[args.aperture.type]( par.tag, pars )
      end

   -- use original vspec to filter out unrelated elements
   local rs_args =
      tables.filter_matched_keys( utils.vspec.ring_n_spoke, args )

   local nentries = utils.ring_n_spoke( rs_args )
   if nentries == 0 then
      error( string.format( "error: %s : shell %d: no apertures?",
			    args.file, args.shell  ) )
   end

end

-- return a sanitized namespace
return { entrance_aperture = entrance_aperture,

	 -- expose vspec so that inputs to entrance_aperture may be sanitized
	 -- to avoid "unknown elements" errors
	 vspec = vspec
 }
