-- intensity distribution support functions

local units = require( 'saotrace.raygen.units' )

local _M = {}

--------------------------

-- 1D intensity distributions

local OneD = {


   gaussian = {

      {},

      sigma = { type = 'ang_lin_distance' },

      mean = { type = 'ang_lin_distance', default = { 0, units.angular.radian } },
   },

   uniform = {
      {},

   }
}


--------------------------

-- 2D intensity distributions

local TwoD = {

   gaussian = {

      {},

      sigma = { type = 'ang_lin_distance',
		optional = true,
		excludes = { 'sigma_x', 'sigma_y' },
	     },


      sigma_x = { type = 'ang_lin_distance',
		  optional = true,
		  requires = 'sigma_y',
		  excludes = 'sigma' },

      sigma_y = { type = 'ang_lin_distance',
		  optional = true,
		  requires = 'sigma_x',
		  excludes = 'sigma' },

      ['%oneplus_of'] = { { 'sigma', 'sigma_x', 'sigma_y' } },

      x = { type = 'ang_lin_distance', default = { 0, units.angular.radian } },
      y = { type = 'ang_lin_distance', default = { 0, units.angular.radian } }
   },

   uniform = {

      {},

   }
}

-- first positional element in tables is the name of the distribution

local function vtable_nd( vtable_map, args )

   local vtable = vtable_map[args[1]:lower()]

   if vtable then
      return true, vtable
   else
      return false, "unknown intensity distribution"
   end

end

local function vtable_1d( args )
   return vtable_nd( OneD, args )
end

local function vtable ( args )

   -- if args[1] exists, it's the name of a 2D distribution
   if args[1] ~= nil then

      return vtable_nd( TwoD, args )

   else

      -- then there must only be x and y attributes

      return true, { x = { vtable = vtable_1d, optional = false},
		     y = { vtable = vtable_1d, optional = false},
		  }

   end

end

function _M.validate( vobj, args )

   local ok, vtable = vtable( args );

   if not ok then
      return ok, vtable
   end

   return vobj:validate_tbl( vtable, args )

end

return _M
