local require = require
local type = type
local setmetatable = setmetatable
local assert = assert
local loadfile = loadfile
local error = error
local dofile = dofile
local loadstring = loadstring
local box = require('saotrace.suplib.box')

local _G = _G

require('string')

module( ... )


function init( cfgfile, cfgpars )

   local config = require ( 'saotrace.config' ).aperture

   local construct = false
   local env

   if cfgfile and cfgfile:len() > 0 then

      local boxenv, retval = box.boxit( _G, cfgfile, true )

      -- if cfgfile returns a table, use that as the
      -- environment, not the sandboxed one
      env = type(retval) == 'table' and retval or boxenv


   end


   if cfgpars and cfgpars:len() > 0 then

      -- use the env determined from cfgfile (if it was run)
      -- else create another

      if env then

	 -- make sure this environment sees the global one
	 setmetatable( env, { __index = _G } )

	 box.boxit( env, cfgpars )

      else

	 local boxenv, retval = box.boxit( _G, cfgpars, true )
	 env = type(retval) == 'table' and retval or boxenv

      end

   end


   env = env or {}
   setmetatable( env, { __index = _G } )

   local script = config.script

   -- if no args have been assigned, pass in the
   -- environment populated by the sandbox.  this
   -- makes it easier to provide backwards compatibility
   if not script.args then
      script.args = env
   end

   if ( 'function' == type( script.func ) ) then

      box.sandbox( env, script.func, script.args )

   elseif ( 'string' == type( script.func ) ) then

      -- simple Lua script?
      if script.func:find( '%.lua$' ) then

	 local func = assert( loadfile( script.func ) )
	 box.sandbox( env, func, script.args )

	 -- module, then
      else

	 local func = require( script.func ).aperture

	 if 'function' == type( func ) then
	    box.sandbox( env, mod.aperture, script.args )
	 end

      end


   end

end
