#!sh

if [ -n "${KSH_VERSION:-}" ]; then
:    ${_SAOTRACE_SETUP_SH:=${.sh.file}}
elif [ -n "${BASH_SOURCE:-}" ]; then
:    ${_SAOTRACE_SETUP_SH:=${BASH_SOURCE}}
elif [ -n "${ZSH_VERSION:-}" ]; then
:    ${_SAOTRACE_SETUP_SH:=${0}}
else
    # fallback to installation dir.  If things have moved, it'll error
    # out below
:   ${_SAOTRACE_SETUP_SH:=/opt/phase1/bin/saotrace_setup.sh}
fi


SAOTRACE_BINDIR=$(dirname "${_SAOTRACE_SETUP_SH}")
if [ $? -ne 0 -o ! -e $SAOTRACE_BINDIR/saotrace_setup.sh ]; then
    cat >&2 <<'EOF'

Ooops!

Something went wrong when setting up the SAOTrace environment. Please execute

    $DIR/saotrace-env --help-setup=sh

where $DIR is the directory containing the saotrace_setup.sh file you just sourced

EOF
    return 1
fi


# just in case this is run from the current directory
test "${SAOTRACE_BINDIR}" = . && SAOTRACE_BINDIR="$PWD"
eval $($SAOTRACE_BINDIR/saotrace-env ${SAOTRACE_ENV_ARGS:+${SAOTRACE_ENV_ARGS}} --fmt sh)
return 0
