
!============================================================================
      subroutine open_ftn_io( filename, io_unit,
     &                        io_format, io_direction, iostat )
      implicit none

      character*(*) filename
      integer       io_format, io_direction
      integer       iostat

      integer       io_unit

      iostat  = 0

      if ( io_format .eq. 0 ) then
         if ( io_direction .eq. 0 ) then
            open ( io_unit, file = filename, status ='old',
     &                      form = 'formatted', err = 400 )
         else
            open ( io_unit, file = filename, status ='unknown',
     &                      form = 'formatted', err = 400 )
         endif
      elseif ( io_format .eq. 1 ) then
         if ( io_direction .eq. 0 ) then
            open ( io_unit, file = filename, status ='old',
     &                      form = 'unformatted', err = 400 )
         else
            open ( io_unit, file = filename, status ='unknown',
     &                      form = 'unformatted', err = 400 )
         endif
      else
         iostat = 1       ! invalid format
      endif

      return

400   continue
      write (0, *) 'read_spl: error opening spline file ',
     &              filename, ' - exiting...'
      stop 400

      end

!============================================================================
      subroutine close_ftn_io( io_unit )

      implicit none

      integer       io_unit

      close( io_unit )

      end

!============================================================================
      subroutine read_ftn_hdr( io_unit, io_format, 
     &                         nzordr, qz, ntordr, ntknts, 
     &                         zmin, zmax, tmin, tmax, ier )

      implicit none

      integer   io_unit, io_format, nzordr, qz, ntordr, ntknts
      integer   ier
      real*8    zmin, zmax, tmin, tmax

*---  named constants...
      double precision pi, twopi
      parameter      ( pi       = 3.1415 92653 58979 32384 62643 d+0 ,
     &                 twopi    = 2.d0*pi                            )

*---  read in parameters...

      if ( io_format .eq. 0 ) then

         read ( io_unit, 9900, err=300, end=310 ) 
     &      nzordr, qz, zmin, zmax
         read ( io_unit, 9900, err=300, end=310 ) ntordr, ntknts,
     &                                            tmin, tmax

      else

         read ( io_unit ) nzordr, qz, zmin, zmax
         read ( io_unit ) ntordr, ntknts, tmin, tmax

      endif

      go to 500

*---  error while reading the deformation header record
300   continue
      write (8, 650)
      ier = 2
      go to 500

*---  eof while reading the deformation header record
310   continue
      write (8, 660)
      ier = 1
      go to 500

500   continue
      return

650   format ('-read_ftn_hdr error: ',
     & 'error while reading the deformation id record')
660   format ('-read_ftn_hdr error: ',
     & 'eof while reading the deformation id record')

9900  format (   1x, 2i8, 2e17.9 )

      end

!============================================================================
      subroutine write_ftn_hdr( io_unit, io_format,
     &                          nzordr, qz, ntordr, ntknts,
     &                          zmin, zmax, tmin, tmax, ier )

      implicit none

      integer   io_unit, io_format, nzordr, qz, ntordr, ntknts
      integer   ier
      real*8    zmin, zmax, tmin, tmax

*---  named constants...
      double precision pi, twopi
      parameter      ( pi       = 3.1415 92653 58979 32384 62643 d+0 ,
     &                 twopi    = 2.d0*pi                            )

*---  write out parameters...

      if ( io_format .eq. 0 ) then

         write( 60, 9900, err=300 ) nzordr, qz, zmin, zmax
         write( 60, 9900, err=300 ) ntordr, ntknts, tmin, tmax

      else

         write( 60 ) nzordr, qz, zmin, zmax
         write( 60 ) ntordr, ntknts, tmin, tmax

      endif

      go to 500

*---  error while reading the deformation header record
300   continue
      write (8, 650)
      ier = 2
      go to 500

*---  eof while reading the deformation header record
310   continue
      write (8, 660)
      ier = 1
      go to 500

500   continue
      return

650   format ('-write_ftn_hdr error: ',
     & 'error while writing the deformation id record')
660   format ('-write_ftn_hdr error: ',
     & 'eof while writing the deformation id record')

9900  format (   1x, 2i8, 2e17.9 )

      end

!============================================================================
      subroutine read_ftn_spldata( io_unit, io_format,
     &                             z_knots, t_knots,
     &                             c, cdifz, cdift, scr,
     &                             qz, qzm1, ntknts )

      implicit none

      integer io_unit, io_format
      integer qz, qzm1, ntknts
      real*8  z_knots(*), t_knots(*)
      real*8  c(qz,ntknts), cdifz(qzm1,ntknts), cdift(qz,ntknts)
      real*8  scr(qz,ntknts)

      integer rc

      integer iz, it, jz, jt

      integer  dpveci, dpari
      external dpveci, dpari

      if ( io_format .eq. 0 ) then

         read ( io_unit, 9490, err=300, end=310 ) 
     &      (z_knots(iz),iz=1,qz)
         read ( io_unit, 9490, err=300, end=310 ) 
     &      (t_knots(it),it=1,ntknts)

         do jt = 1, ntknts
            read ( io_unit, 9490, err=320, end=330 )
     &         ( c(jz, jt),  jz = 1, qz )
         enddo
         do jt = 1, ntknts
            read ( io_unit, 9490, err=320, end=330 )
     &      ( cdifz(jz, jt),  jz = 1, qz-1 )
         enddo
         do jt = 1, ntknts
            read ( io_unit, 9490, err=320, end=330 )
     &         ( cdift(jz, jt),  jz = 1, qz )
         enddo

      else

         rc = dpveci( io_unit, qz, z_knots )
         if ( rc .ne. 0 ) go to 340

         rc = dpveci( io_unit, ntknts, t_knots )
         if ( rc .ne. 0 ) go to 340

         rc = dpari( io_unit, qz,   qz,   ntknts, c,     scr )
         if ( rc .ne. 0 ) go to 340

         rc = dpari( io_unit, qzm1, qzm1, ntknts, cdifz, scr )
         if ( rc .ne. 0 ) go to 340

         rc = dpari( io_unit, qz,   qz,   ntknts, cdift, scr )
         if ( rc .ne. 0 ) go to 340

      endif

      go to 500

!---  error while reading the knot locations
300   continue
      write (0, 650)
      go to 500

!---  eof while reading the knot locations
310   continue
      write (0, 660)
      go to 500

!---  error while reading the coefficients
320   continue
      write (0, 670)
      go to 500

!---  eof while reading the coefficients
330   continue
      write (0, 680)
      go to 500

!---  eof while reading the coefficients
340   continue
      write (0, 690)
      go to 500

500   continue
      return

!format statments ------------------------------------------------------

650   format ('-read_ftn_spldata error: error while reading the ',
     &        'spline knots')
660   format ('-read_ftn_spldata error: eof while reading the ',
     &        'spline knots')
670   format ('-read_ftn_spldata error: error while reading the ',
     &        'coefficients')
680   format ('-read_ftn_spldata error: eof while reading the ',
     &        'coefficients')
690   format ('-read_ftn_spldata error: insufficient number of ',
     &        'coefficients in file')
9490  format (   1x, 4e17.9 )

      end

!============================================================================
      subroutine write_ftn_spldata( io_unit, io_format,
     &                              z_knots, t_knots,
     &                              c, cdifz, cdift, scr,
     &                              qz, qzm1, ntknts )

      implicit none

      integer io_unit, io_format
      integer qz, qzm1, ntknts
      real*8  z_knots(*), t_knots(*)
      real*8  c(qz,ntknts), cdifz(qzm1,ntknts), cdift(qz,ntknts)
      real*8  scr(qz,ntknts)

      integer rc

      integer iz, it, jz, jt

      integer  dpveco, dparo
      external dpveco, dparo

      if ( io_format .eq. 0 ) then

         write ( io_unit, 9490, err=300 ) (z_knots(iz),iz=1,qz)
         write ( io_unit, 9490, err=300 ) (t_knots(it),it=1,ntknts)

         do jt = 1, ntknts
            write ( io_unit, 9490, err=330 )
     &         ( c(jz, jt),  jz = 1, qz )
         enddo
         do jt = 1, ntknts
            write ( io_unit, 9490, err=330 )
     &      ( cdifz(jz, jt),  jz = 1, qz-1 )
         enddo
         do jt = 1, ntknts
            write ( io_unit, 9490, err=330 )
     &         ( cdift(jz, jt),  jz = 1, qz )
         enddo

      else

         rc = dpveco( io_unit, qz, z_knots )
         if ( rc .ne. 0 ) go to 340

         rc = dpveco( io_unit, ntknts, t_knots )
         if ( rc .ne. 0 ) go to 340

         rc = dparo( io_unit, qz,   qz,   ntknts, c,     scr )
         if ( rc .ne. 0 ) go to 340

         rc = dparo( io_unit, qzm1, qzm1, ntknts, cdifz, scr )
         if ( rc .ne. 0 ) go to 340


         rc = dparo( io_unit, qz,   qz,   ntknts, cdift, scr )
         if ( rc .ne. 0 ) go to 340

      endif

      go to 500

!---  error while writing the knot locations
300   continue
      write (0, 660)
      go to 500

!---  error while writing the coefficients
330   continue
      write (0, 670)
      go to 500

!---  error while writing the coefficients
340   continue
      write (0, 690)
      go to 500

500   continue
      return

!format statments ------------------------------------------------------

660   format ('-write_ftn_spldata error: error while writing the ',
     &        'spline knots')
670   format ('-write_ftn_spldata error: error while writing the ',
     &        'coefficients')
690   format ('-write_ftn_spldata error: insufficient number of ',
     &        'coefficients in file')
9490  format (   1x, 4e17.9 )

      end
