#ifndef main_h_INCLUDED
#define main_h_INCLUDED

#include <string.h>
#include "usage.h"
#include "help.h"

#define NAME_LENGTH 255
#define DEBUG_LENGTH 255

typedef enum { EAsciiIn,  EOldBinaryIn,  ENewBinaryIn, EFitsIn } EInputFormat;
typedef enum { EAsciiOut, EOldBinaryOut, ENewBinaryOut, 
	       ERDB_DFMOut, EFitsOut } EOutputFormat;

typedef struct
{
  int           help;
  int           usage;
  int           version;

  double        rms_amplitude;

  EOutputFormat output_format;

  char          prgname[NAME_LENGTH+1];          /* name of executable    */

  char          input[NAME_LENGTH+1];            /* name of input stream  */
  char          output[NAME_LENGTH+1];           /* name of output stream */

} Common;

void
process(void);

void
gparam(int argc, char *argv[]);

#endif /* _MAIN_H */
