# serial 1

# MST_PROG_USAGE
# ----------------
#
#  Find conversion programs to generate built-in help and usage
#  documentation from POD source

AC_DEFUN([MST_PROG_USAGE],
[
dnl create macro so can be tested for inclusion by automake
AC_SUBST([MST_PROG_USAGE_M4])

AC_CHECK_PROG([TEXT2USAGE],[text2usage],[yes],[no])
AC_CHECK_PROG([POD2TEXT],[pod2text],[yes],[no])

AS_IF( [test "$TEXT2USAGE" = yes -a "$POD2TEXT" = yes],
       [HAVE_MST_PROG_USAGE=yes],
       [HAVE_MST_PROG_USAGE=no]
)

AM_CONDITIONAL([HAVE_MST_PROG_USAGE],[test $HAVE_MST_PROG_USAGE = yes])
AM_COND_IF([HAVE_MST_PROG_USAGE],
	   [],
	   [AC_MSG_WARN( "unable to regenerate built-in docs; will use distributed version" ) ] )
]) # MST_PROG_USAGE
