
/*=======================================================================
 * gparam.c
 *
 * Author:  T. Gaetz
 */

#include <string.h>                /* system includes */
#include <stdlib.h>         	   /* exit */

#include <tracefct/tracefct.h>     /* tf functions             */
#include <tracefct/exiterrvals.h>  /* error codes for tracefct */
#include <suplib/str.h>
#include <suplib/debug.h>
#include <tparam/tparam.h>         /* parameter file wrapper routines */

#include "main.h"
#include "common.h"

static char s_output_format[NAME_LENGTH];

static TokListToken 
in_format_type[] =
{
  { "ascii",      EAsciiIn     },
  { "old_binary", EFitsIn      },
  { "new_binary", ENewBinaryIn },
  { "old_binary", EOldBinaryIn }
};
TokList in_format_types = GenTokList( in_format_type );

static TokListToken
out_format_type[] =
{
  { "ascii",      EAsciiOut     },
  { "fits",       EFitsOut      },
  { "new_binary", ENewBinaryOut },
  { "old_binary", EOldBinaryOut },
  { "rdb_dfm",    ERDB_DFMOut   }
};
TokList out_format_types = GenTokList( out_format_type );

void
gparam( int argc, char *argv[] )
{
  paramfile pf;       /* param file handle */
  int       ofmt;     /* output format type */
  int       pfrv;

  tf_enter("gparam");

  pf = tparamopen(NULL, argv, argc, "r");

  /* get debug flags */
  tpgetstr(pf, "debug", debug, NAME_LENGTH, 0);
  debug_init(debug);

  /* c.version = tpgetb(pf, "version"); */
  pfrv = tpgetb(pf, "version");
  c.version = pfrv;

  if ( paccess( pf, "help" ) )
  {
    /* c.help = tpgetb( pf, "help" ); */
    pfrv = tpgetb(pf, "help");
    c.help = pfrv;
  }
  else
  {
    tf_message( "you must update your parameter file\n" );
    c.help = 0;
  }

  if ( paccess( pf, "usage" ) )
  {
    /* c.usage = tpgetb( pf, "usage" ); */
    pfrv = tpgetb(pf, "usage");
    c.usage = pfrv;
  }
  else
  {
    tf_message( "you must update your parameter file\n" );
    c.usage = 0;
  }

  if ( !c.version && !c.help && !c.usage )
  {
    tpgetstr(pf, "input",   c.input,   NAME_LENGTH, 1);
    tpgetstr(pf, "output",  c.output,  NAME_LENGTH, 1);

    tpgetstr(pf, "output_format", s_output_format, NAME_LENGTH, 1);
    if ( (ofmt = tokmatch( s_output_format, &out_format_types )) < 0 )
    {
      tf_exit( ExitERR_misc, "invalid output format type" );
    }
    c.output_format = (EOutputFormat)ofmt;
  }

  paramclose(pf);

  tf_leave();
}
