/* for popen on Solaris */
#ifdef SunOS
#ifndef __EXTENSIONS__
#  define __EXTENSIONS__
#endif
#else
#ifndef _POSIX_C_SOURCE
#  define _POSIX_C_SOURCE 2
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "usage.h"

static const char usage_string[] =
{
  78, 65, 77, 69, 10, 
  32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 95, 99, 111, 110, 118, 101, 114, 116, 95, 102, 111, 114, 109, 97, 116, 32, 45, 32, 99, 111, 110, 118, 101, 114, 116, 115, 32, 98, 101, 116, 119, 101, 101, 110, 32, 115, 112, 108, 105, 110, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 115, 10, 
  10, 
  83, 89, 78, 79, 80, 83, 73, 83, 10, 
  32, 32, 32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 95, 99, 111, 110, 118, 101, 114, 116, 95, 102, 111, 114, 109, 97, 116, 32, 91, 73, 60, 111, 112, 116, 105, 111, 110, 62, 61, 73, 60, 118, 97, 108, 117, 101, 62, 93, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 79, 112, 116, 105, 111, 110, 115, 58, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 105, 110, 112, 117, 116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 105, 110, 112, 117, 116, 32, 102, 105, 108, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 111, 117, 116, 112, 117, 116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 111, 117, 116, 112, 117, 116, 32, 102, 105, 108, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 111, 117, 116, 112, 117, 116, 95, 102, 111, 114, 109, 97, 116, 32, 32, 32, 32, 32, 32, 97, 115, 99, 105, 105, 124, 102, 105, 116, 115, 124, 110, 101, 119, 95, 98, 105, 110, 97, 114, 121, 124, 111, 108, 100, 95, 98, 105, 110, 97, 114, 121, 124, 114, 100, 98, 95, 100, 102, 109, 10, 
  10, 
  68, 69, 83, 67, 82, 73, 80, 84, 73, 79, 78, 10, 
  32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 95, 99, 111, 110, 118, 101, 114, 116, 95, 102, 111, 114, 109, 97, 116, 32, 114, 101, 97, 100, 115, 32, 97, 32, 115, 112, 108, 105, 110, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 32, 97, 110, 100, 32, 99, 111, 110, 118, 101, 114, 116, 115, 32, 105, 116, 32, 116, 111, 10, 
  32, 32, 32, 32, 97, 110, 111, 116, 104, 101, 114, 32, 40, 112, 111, 115, 115, 105, 98, 108, 121, 32, 116, 104, 101, 32, 115, 97, 109, 101, 41, 32, 102, 111, 114, 109, 97, 116, 46, 32, 84, 104, 101, 32, 82, 77, 83, 32, 115, 112, 108, 105, 110, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 97, 109, 112, 108, 105, 116, 117, 100, 101, 10, 
  32, 32, 32, 32, 105, 115, 32, 119, 114, 105, 116, 116, 101, 110, 32, 116, 111, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 101, 114, 114, 111, 114, 46, 10, 
  10, 
  79, 80, 84, 73, 79, 78, 83, 10, 
  32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 95, 99, 111, 110, 118, 101, 114, 116, 95, 102, 111, 114, 109, 97, 116, 32, 117, 115, 101, 115, 32, 97, 110, 32, 73, 82, 65, 70, 45, 99, 111, 109, 112, 97, 116, 105, 98, 108, 101, 32, 112, 97, 114, 97, 109, 101, 116, 101, 114, 32, 105, 110, 116, 101, 114, 102, 97, 99, 101, 46, 10, 
  10, 
  32, 32, 32, 32, 105, 110, 112, 117, 116, 32, 105, 110, 112, 117, 116, 32, 102, 105, 108, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 84, 104, 105, 115, 32, 112, 97, 114, 97, 109, 101, 116, 101, 114, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 110, 97, 109, 101, 32, 111, 102, 32, 116, 104, 101, 32, 102, 105, 108, 101, 47, 115, 116, 114, 101, 97, 109, 32, 102, 111, 114, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 46, 32, 73, 102, 32, 116, 104, 101, 32, 102, 105, 108, 101, 110, 97, 109, 101, 32, 105, 115, 32, 116, 104, 101, 32, 115, 116, 114, 105, 110, 103, 32, 34, 115, 116, 100, 105, 110, 34, 44, 32, 105, 116, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 114, 101, 97, 100, 115, 32, 85, 78, 73, 88, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 105, 110, 112, 117, 116, 46, 32, 84, 104, 101, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 32, 105, 115, 32, 97, 117, 116, 111, 45, 114, 101, 99, 111, 103, 110, 105, 122, 101, 100, 59, 32, 116, 104, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 32, 99, 97, 110, 32, 98, 101, 32, 116, 104, 101, 32, 97, 115, 99, 105, 105, 32, 102, 111, 114, 109, 97, 116, 44, 32, 116, 104, 101, 32, 111, 108, 100, 32, 98, 105, 110, 97, 114, 121, 32, 102, 111, 114, 109, 97, 116, 44, 32, 116, 104, 101, 32, 110, 101, 119, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 98, 105, 110, 97, 114, 121, 32, 102, 111, 114, 109, 97, 116, 44, 32, 111, 114, 32, 97, 32, 115, 112, 108, 105, 110, 101, 32, 70, 73, 84, 83, 32, 102, 105, 108, 101, 46, 32, 67, 117, 114, 114, 101, 110, 116, 108, 121, 44, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 102, 105, 108, 101, 32, 99, 97, 110, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 78, 79, 84, 32, 98, 101, 32, 97, 110, 32, 114, 100, 98, 32, 102, 105, 108, 101, 46, 10, 
  10, 
  32, 32, 32, 32, 111, 117, 116, 112, 117, 116, 32, 111, 117, 116, 112, 117, 116, 32, 102, 105, 108, 101, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 84, 104, 105, 115, 32, 112, 97, 114, 97, 109, 101, 116, 101, 114, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 110, 97, 109, 101, 32, 111, 102, 32, 116, 104, 101, 32, 102, 105, 108, 101, 47, 115, 116, 114, 101, 97, 109, 32, 102, 111, 114, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 115, 112, 108, 105, 110, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 46, 32, 73, 102, 32, 116, 104, 101, 32, 102, 105, 108, 101, 110, 97, 109, 101, 32, 105, 115, 32, 116, 104, 101, 32, 115, 116, 114, 105, 110, 103, 32, 34, 115, 116, 100, 111, 117, 116, 34, 44, 32, 105, 116, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 119, 114, 105, 116, 101, 115, 32, 116, 111, 32, 85, 78, 73, 88, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 111, 117, 116, 112, 117, 116, 46, 32, 84, 104, 101, 32, 102, 111, 114, 109, 97, 116, 32, 111, 102, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 102, 105, 108, 101, 32, 105, 115, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 98, 121, 32, 116, 104, 101, 32, 111, 112, 116, 105, 111, 110, 32, 111, 117, 116, 112, 117, 116, 95, 102, 111, 114, 109, 97, 116, 46, 10, 
  10, 
  32, 32, 32, 32, 111, 117, 116, 112, 117, 116, 95, 102, 111, 114, 109, 97, 116, 58, 32, 42, 115, 116, 114, 105, 110, 103, 42, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 84, 104, 105, 115, 32, 112, 97, 114, 97, 109, 101, 116, 101, 114, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 102, 111, 114, 109, 97, 116, 32, 111, 102, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 102, 105, 108, 101, 46, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 34, 97, 115, 99, 105, 105, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 111, 108, 100, 32, 97, 115, 99, 105, 105, 32, 115, 112, 108, 105, 110, 101, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 46, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 34, 111, 108, 100, 95, 98, 105, 110, 97, 114, 121, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 111, 108, 100, 32, 98, 105, 110, 97, 114, 121, 32, 115, 112, 108, 105, 110, 101, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 32, 40, 70, 111, 114, 116, 114, 97, 110, 32, 117, 110, 102, 111, 114, 109, 97, 116, 101, 100, 32, 102, 105, 108, 101, 41, 46, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 34, 110, 101, 119, 95, 98, 105, 110, 97, 114, 121, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 110, 101, 119, 32, 98, 105, 110, 97, 114, 121, 32, 115, 112, 108, 105, 110, 101, 32, 102, 105, 108, 101, 32, 102, 111, 114, 109, 97, 116, 32, 40, 67, 32, 98, 105, 110, 97, 114, 121, 32, 115, 116, 114, 101, 97, 109, 41, 46, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 34, 114, 100, 98, 95, 100, 102, 109, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 47, 82, 68, 66, 32, 116, 97, 98, 108, 101, 59, 32, 116, 104, 101, 32, 99, 111, 108, 117, 109, 110, 115, 32, 97, 114, 101, 32, 116, 104, 101, 32, 97, 114, 114, 97, 121, 32, 105, 110, 100, 105, 99, 101, 115, 32, 105, 110, 100, 105, 99, 97, 116, 105, 110, 103, 32, 116, 104, 101, 116, 97, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 97, 110, 100, 32, 122, 44, 32, 116, 104, 101, 32, 116, 104, 101, 116, 97, 32, 97, 110, 100, 32, 122, 32, 99, 111, 111, 114, 100, 105, 110, 97, 116, 101, 115, 44, 32, 97, 110, 100, 32, 116, 104, 101, 32, 100, 101, 102, 111, 114, 109, 97, 116, 105, 111, 110, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 97, 109, 112, 108, 105, 116, 117, 100, 101, 46, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 34, 102, 105, 116, 115, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70, 73, 84, 83, 32, 115, 112, 108, 105, 110, 101, 32, 102, 105, 108, 101, 10, 
  10, 
  32, 32, 32, 32, 104, 101, 108, 112, 32, 34, 121, 101, 115, 34, 124, 34, 110, 111, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 80, 114, 105, 110, 116, 32, 111, 117, 116, 32, 97, 32, 115, 105, 109, 112, 108, 101, 32, 104, 101, 108, 112, 32, 109, 101, 115, 115, 97, 103, 101, 32, 97, 110, 100, 32, 101, 120, 105, 116, 46, 10, 
  10, 
  32, 32, 32, 32, 118, 101, 114, 115, 105, 111, 110, 32, 34, 121, 101, 115, 34, 124, 34, 110, 111, 34, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 80, 114, 105, 110, 116, 32, 111, 117, 116, 32, 115, 112, 108, 105, 110, 101, 95, 99, 111, 110, 118, 101, 114, 116, 95, 102, 111, 114, 109, 97, 116, 39, 115, 32, 118, 101, 114, 115, 105, 111, 110, 32, 97, 110, 100, 32, 101, 120, 105, 116, 46, 10, 
  10, 
  32, 32, 32, 32, 100, 101, 98, 117, 103, 32, 42, 108, 105, 115, 116, 42, 10, 
  32, 32, 32, 32, 32, 32, 32, 32, 65, 32, 108, 105, 115, 116, 32, 111, 102, 32, 100, 101, 98, 117, 103, 32, 102, 108, 97, 103, 115, 46, 32, 78, 111, 110, 101, 32, 97, 118, 97, 105, 108, 97, 98, 108, 101, 32, 121, 101, 116, 46, 10, 
  10, 
  67, 79, 80, 89, 82, 73, 71, 72, 84, 32, 38, 32, 76, 73, 67, 69, 78, 83, 69, 10, 
  32, 32, 32, 32, 67, 111, 112, 121, 114, 105, 103, 104, 116, 32, 50, 48, 48, 54, 32, 83, 109, 105, 116, 104, 115, 111, 110, 105, 97, 110, 32, 65, 115, 116, 114, 111, 112, 104, 121, 115, 105, 99, 97, 108, 32, 79, 98, 115, 101, 114, 118, 97, 116, 111, 114, 121, 10, 
  10, 
  32, 32, 32, 32, 84, 104, 105, 115, 32, 115, 111, 102, 116, 119, 97, 114, 101, 32, 105, 115, 32, 114, 101, 108, 101, 97, 115, 101, 100, 32, 117, 110, 100, 101, 114, 32, 116, 104, 101, 32, 71, 78, 85, 32, 71, 101, 110, 101, 114, 97, 108, 32, 80, 117, 98, 108, 105, 99, 32, 76, 105, 99, 101, 110, 115, 101, 46, 32, 89, 111, 117, 32, 109, 97, 121, 10, 
  32, 32, 32, 32, 102, 105, 110, 100, 32, 97, 32, 99, 111, 112, 121, 32, 97, 116, 10, 
  10, 
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 102, 115, 102, 46, 111, 114, 103, 47, 99, 111, 112, 121, 108, 101, 102, 116, 47, 103, 112, 108, 46, 104, 116, 109, 108, 10, 
  10, 
  65, 85, 84, 72, 79, 82, 10, 
  32, 32, 32, 32, 84, 46, 32, 71, 97, 101, 116, 122, 10, 
  10, 
 0
};


int
usage( void )
{
  const char *pager;
  FILE *pipe;

  if ( ! isatty( STDOUT_FILENO ) )
    fputs( usage_string, stdout );
  else
  {
    if ( NULL == ( pager = getenv( "PAGER" )) )
      pager = "more";

    if ( NULL == ( pipe = popen( pager, "w" ) ) )
      return 1;

    fputs( usage_string, pipe );
    pclose( pipe );
  }
  return 0;
}
