!-----------------------------------------------------------------------
      INTEGER FUNCTION dpveci( lu, isz, vec )
      use, intrinsic :: ISO_FORTRAN_ENV
!
!kwic dpveci - read DOUBLE PRECISION array
!
      implicit none

!---  passed variables...
      INTEGER lu           !i  i/o unit number
      INTEGER isz          !i  number of elements to read
      REAL(kind = REAL64) ::  vec(isz)     !i  vector to be read
!
!  history:
!     1996-Feb-20[TJG]: initial version
!
!$Id: vecio.f,v 1.1.1.1 2004/04/14 17:39:24 dtn Exp $
!-
      read ( lu, err=9800 ) vec

      dpveci = 0
      return

9800  dpveci = 220
      return

      END ! dpveci ------------------------------------------------------

!-----------------------------------------------------------------------
      INTEGER FUNCTION dpveco( lu, isz, vec )
      use, intrinsic :: ISO_FORTRAN_ENV
!
!kwic dpveco - write DOUBLE PRECISION array
!
      implicit none

!---  passed variables...
      INTEGER lu           !i  i/o unit number
      INTEGER isz          !i  number of elements to write
      REAL(kind = REAL64) :: vec(isz)     !i  vector to be written
!
!  history:
!     1996-Feb-20[TJG]: initial version
!
!$Id: vecio.f,v 1.1.1.1 2004/04/14 17:39:24 dtn Exp $
!-
      write ( lu, err=9800 ) vec

      dpveco = 0
      return

9800  dpveco = 220
      return

      END ! dpveco ------------------------------------------------------

!-----------------------------------------------------------------------
      INTEGER FUNCTION dpari( lu, isz, ihi, khi, ary, wrk )
      use, intrinsic :: ISO_FORTRAN_ENV
!
!kwic dpari - read DOUBLE PRECISION array
!
      implicit none

!---  passed variables...
      INTEGER lu           !i  i/o unit number
      INTEGER isz          !i  1st dimension for array ary
      INTEGER ihi          !i  1st dimension for work array
      INTEGER khi          !i  2nd dimension for array ary
      REAL(kind = REAL64) ::  ary(isz,*)   !i  array to be read
      REAL(kind = REAL64) ::  wrk(ihi,khi) !i  work array
!
!  history:
!     1996-Feb-14[TJG]: initial version; modeled loosely on tglib dpario
!
!$Id: vecio.f,v 1.1.1.1 2004/04/14 17:39:24 dtn Exp $
!-

!---  local variables...
      INTEGER i, j

!---  read data into work array...
      read ( lu, err=9800 ) wrk

!---  copy array from work array...
      do j = 1,khi
         do i = 1,ihi
            ary(i,j) = wrk(i,j)
         enddo
      enddo

      dpari = 0
      return

9800  dpari = 220
      return

      END ! dpari ------------------------------------------------------

!-----------------------------------------------------------------------
      INTEGER FUNCTION dparo( lu, isz, ihi, khi, ary, wrk )
      use, intrinsic :: ISO_FORTRAN_ENV
!
!kwic dparo - write DOUBLE PRECISION array
!
      implicit none

!---  passed variables...
      INTEGER lu           !i  i/o unit number
      INTEGER isz          !i  1st dimension for array ary
      INTEGER ihi          !i  1st dimension for work array
      INTEGER khi          !i  2nd dimension for array ary
      REAL(kind = REAL64)  ary(isz,*)   !i  array to be written
      REAL(kind = REAL64)  wrk(ihi,khi) !i  work array
!
!  history:
!     1996-Feb-14[TJG]: initial version; modeled loosely on tglib dpario
!
!$Id: vecio.f,v 1.1.1.1 2004/04/14 17:39:24 dtn Exp $
!-

!---  local variables...
      INTEGER i, j

!---  copy array into work array...
      do j = 1,khi
         do i = 1,ihi
            wrk(i,j) = ary(i,j)
         enddo
      enddo

!---  blast it out...
      write( lu, err=9800 ) wrk

      dparo = 0
      return

9800  dparo = 220
      return

      END ! dparo ------------------------------------------------------
