
/****************************************************************************
 *
 * Source     : main.c
 * Author     : Terry Gaetz
 *
 * History
 *--------
 * 0.0.0 1995-Apr-07  tjg  original version
 */

#include <stdio.h>

#include <tracefct/tracefct.h>
#include <tparam/tparam.h>

#include "main.h"
#include "common.h"
#include "usage.h"
#include "config.h"

extern Common c;

int
main(int argc, char *argv[])
{
  tf_init( argv[0], 0, 0);

  strncpy(c.prgname, argv[0], NAME_LENGTH);

  gparam(argc, argv);

  if (c.version)
  {
    fprintf( stderr, "%s " VERSION "\n", argv[0] );
    return EXIT_SUCCESS;
  }

  if ( c.help )
  {
    help( );
    return EXIT_SUCCESS;
  }

  if ( c.usage )
  {
    usage( );
    return EXIT_SUCCESS;
  }

  process();

  return EXIT_SUCCESS;
}

