
/****************************************************************************
 * Source     : process.c
 * Author     : Terry Gaetz
 */

#include <stdio.h>

#include "config.h"

#include <tracefct/tracefct.h>
#include <tracefct/exiterrvals.h>
#include "BsplineUtil/splines.h"

#include "main.h"
#include "common.h"

void
process(void)
{
  int input_unit  = 50;
  int output_unit = 60;

  tf_enter("process");

  READ_SPLINE_DATA_F77(  c.input, &input_unit, 
                         &c.rms_amplitude,
		        (long)strlen( c.input+1) );

  WRITE_SPLINE_DATA_F77( c.output, &output_unit,
		        (int const*)&c.output_format, 
                        (long)strlen( c.input+1) );

  SPLINE_CLEANUP_F77();

  tf_leave();
}
