local setup = require 'setup'

local intrinsic = require( 'saotrace.raygen.mock_intrinsics' )
local jitter = require('chandra.saotrace.raygen.jitter')
local pi = require('math').pi


describe( "jitter", function ()

    before_each( setup )

    it( "dither_asol", function ()

           jitter.dither_asol{ file = 'foo.data',
                               ra = 0,
                               dec = 90,
                               roll = 180
           }

           stash = intrinsic.stash[1]

           assert.same( 'jitter', stash.mod )
           assert.same( 'file',   stash.func )
           assert.same( pi, stash[1].optical_axis[1].angle[1] )


    end)

end)
