local setup = require( 'setup' )
local os = require( 'os' )
local srcdir = os.getenv('srcdir') or '.'

local load_sources = require( 'chandra.saotrace.raygen.source' ).load_sources

function srcfile( name )

   return table.concat( { srcdir, 'tests', 'data', name}, '/' )..'.xml'

end

describe( "load sources", function ()

    before_each( setup )


    it( "load_it", function ( )

           assert.has_no.errors( function ()
                 load_sources( srcfile('ngc2516'), {  ra_aimpt = 100,
                                                      dec_aimpt = 20,
                                                      scale = 111,
                 }  )
           end )


    end)

    it( "load_it_fail", function ( )

           assert.error_match( function ()
                 load_sources( srcfile('ngc2516') )
                              end,
              "must specify"
           )

    end)

end)
