local setup = require( 'setup' )
local intrinsic = require( 'saotrace.raygen.mock_intrinsics' )

local srcdir = os.getenv('srcdir') or '.'
local ea_db = table.concat( { srcdir, 'tests', 'data', 'annulus.rdb'}, '/' )
local picket_db = table.concat( { srcdir, 'tests', 'data', 'picket.rdb'}, '/' )

local raygen = require('saotrace.raygen')
local package = package

require('string')

describe( "simple", function ()


     before_each( function()
           setup()
           -- saotrace.config is reset using setup(), so must be able
           -- to reload simple.lua to track changes to saotrace.config there
           package.loaded['chandra.saotrace.raygen.simple'] = nil
     end)


    it( "point", function ()

       local simple = require( 'chandra.saotrace.raygen.simple' )

       simple.point{ name = 'point',
              spectrum = { 33, 44,
                           { type = 'picket', file = picket_db },
                        },
           }

       local stash = intrinsic.stash

       -- start the source
       assert.same(
          { { name = 'point'},
             func = 'start',
             mod = 'source'
          },
          stash[1]
       )

       -- the order of the following is dependent upon what happens in
       -- saotrace.raygen.source.create

       assert.same( 'extent', stash[2].mod );
       assert.same( 'point',    stash[2].func );

       assert.same( 'spectrum', stash[3].mod );
       assert.same( 'mono',     stash[3].func );
       assert.same( 33,         stash[3][1].energy );
       assert.same( 1,          stash[3][1].flux );

       assert.same( 'spectrum', stash[4].mod );
       assert.same( 'mono',     stash[4].func );
       assert.same( 44,         stash[4][1].energy );
       assert.same( 1,          stash[4][1].flux );

       assert.same( 'spectrum', stash[5].mod );
       assert.same( 'mono',     stash[5].func );
       assert.same( 1,          stash[5][1].energy );
       assert.same( 1,          stash[5][1].flux );

       assert.same( 'spectrum', stash[6].mod );
       assert.same( 'mono',     stash[6].func );
       assert.same( 2,          stash[6][1].energy );
       assert.same( 2,          stash[6][1].flux );

       -- finish the source
       assert.same(
          { { name = 'point'},
             func = 'finish',
             mod = 'source'
          },
          stash[#stash]
       )

    end)


    it( "ea", function ()

       local config = require('saotrace.config').raygen
       config.scripts.entrance_aperture.args = { file = ea_db,
                                                 shell = 1,
                                              }
       local simple = require( 'chandra.saotrace.raygen.simple' )

       simple.spectrum = 1.0
       raygen.init('chandra.saotrace.raygen.simple',
                   'spectrum = 1.49'
                )

       local stash = intrinsic.stash[#intrinsic.stash]

       assert.same( 'ea',       stash.mod );
       assert.same( 'annulus',  stash.func );
       assert.same( 10,         stash[1].opts.ro );

       end)


    it( "jitter", function ()

       local simple = require( 'chandra.saotrace.raygen.simple' )

       simple.dither_asol{ file = 'foo.data',
                    ra = 0,
                    dec = 90,
                    roll = 180
                 }

       local stash = intrinsic.stash[1]

       local pi = require('math').pi
       assert.same( 'jitter', stash.mod )
       assert.same( 'file',   stash.func )
       assert.same( pi, stash[1].optical_axis[1].angle[1] )

    end)

end)
