local setup = require( 'setup' )
local intrinsic = require( 'saotrace.raygen.mock_intrinsics' )

local raygen = require('saotrace.raygen')
local source = require( 'chandra.saotrace.raygen.source' )

local srcdir = os.getenv('srcdir') or '.'
local picket_db = table.concat( { srcdir, 'tests', 'data', 'picket.rdb'}, '/' )

local package = package

describe( "source", function () 

    local source
    local stash

    before_each( function ()
       setup()

       package.loaded['chandra.saotrace.raygen.source'] = nil
       source = require( 'chandra.saotrace.raygen.source' )
       stash = intrinsic.stash
    end)


    it( "point", function ()


       source.point{ name = 'point',
                     spectrum = { 33, 44,
                                    { type = 'picket', file = picket_db },
                                 },
                  }


       -- start the source
       assert.same(
          { { name = 'point'},
             func = 'start',
             mod = 'source' 
          },
          stash[1]
       )

       -- the order of the following is dependent upon what happens in
       -- saotrace.raygen.source.create

       assert.same( 'extent', stash[2].mod );
       assert.same( 'point',    stash[2].func );

       local st = stash[3]
       assert.same( 'spectrum', st.mod );
       assert.same( 'mono',     st.func );
       assert.same( 33,         st[1].energy );
       assert.same( 1,          st[1].flux );

       local st = stash[4]
       assert.same( 'spectrum', st.mod );
       assert.same( 'mono',     st.func );
       assert.same( 44,         st[1].energy );
       assert.same( 1,          st[1].flux );

       local st = stash[5]
       assert.same( 'spectrum', st.mod );
       assert.same( 'mono',     st.func );
       assert.same( 1,          st[1].energy );
       assert.same( 1,          st[1].flux );

       local st = stash[6]
       assert.same( 'spectrum', st.mod );
       assert.same( 'mono',     st.func );
       assert.same( 2,          st[1].energy );
       assert.same( 2,          st[1].flux );

       -- finish the source
       assert.same(
          { { name = 'point' },
             func = 'finish',
             mod = 'source'
          },
          stash[#stash]
       )

    end)

    it( "multiple_autonamed", function ()

       source.point{ spectrum = 1.1 }
       source.point{ spectrum = 2.2 }
       source.point{ spectrum = 3.3 }

       local st = stash[1]

       assert.same( 'source', st.mod );
       assert.same( 'start',  st.func );


       assert.same( 'point1',      stash[1][1].name );
       assert.same( 'point1',      stash[2][1].name );
       assert.same( 'point1:spectrum[1]',      stash[3][1].name );
       assert.same( 'point1',      stash[4][1].name );

       assert.same( 'point2',      stash[5][1].name );
       assert.same( 'point2',      stash[6][1].name );
       assert.same( 'point2:spectrum[1]',      stash[7][1].name );
       assert.same( 'point2',      stash[8][1].name );


    end)

end)
