# check for a library using pkg-config or in system spots
# updates LIBS and CFLAGS

# serial 1

# MST_CHECK_LIB_CONFIG(lib, module)
# --------------------------------------------------------------
AC_DEFUN([MST_CHECK_LIB_CONFIG],
[
m4_define([_MST_CHECK_LIB_CONFIG_ERR],
[Unable to find the $1 library. Please set the environmental variables
            $1[]_CFLAGS and $1[]_LIBS
])
m4_define([_UC_LIB],translit($1, 'a-z','A-Z'))
PKG_CHECK_MODULES( [$1], [$2],
		   [AC_SUBST(_UC_LIB[]_LIBS,"$$1_LIBS")
		    AC_SUBST(_UC_LIB[]_CFLAGS,"$$1_CFLAGS")
		    LIBS="$LIBS $$1_LIBS"
	            CFLAGS="$CFLAGS $$1_CFLAGS"
		   ],
		   [AC_PATH_TOOL([$1_CONFIG],[$1-config])dnl
		    if test x"$$1_CONFIG" = x ; then
		      AC_MSG_ERROR(_MST_CHECK_LIB_ERR)
		    else
		      AC_SUBST(_UC_LIB[]_CFLAGS,`$$1_CONFIG --cflags`)
		      AC_SUBST(_UC_LIB[]_LIBS,`$$1_CONFIG --libs`)
		      LIBS="$LIBS $_UC_LIB[]_LIBS"
	              CFLAGS="$CFLAGS $_UC_LIB[]_CFLAGS"
 		      AC_MSG_RESULT([ok])
		   fi
		 ]
)
])
