# serial 2

# ===========================================================================
#    mst_cxx_have_shared_ptr
# ===========================================================================
#
# SYNOPSIS
#
#   MST_CXX_HAVE_SHARED_PTR
#
# DESCRIPTION
#
#   If the C++ library has a working shared_ptr, define HAVE_SHARED_PTR



AC_DEFUN([MST_CXX_HAVE_SHARED_PTR],
[
 AC_CACHE_CHECK([whether the compiler has shared_ptr],
                 [mst_cv_cxx_have_shared_ptr],
 		[
		  AC_REQUIRE([AX_CXX_NAMESPACES])
		  AC_LANG_SAVE
		  AC_LANG([C++])
		  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <memory>
				  #ifdef HAVE_NAMESPACES
				  using namespace std;
				  #endif
				  ]], [[shared_ptr<int> ptr(new int(0)); return 0;]])],[mst_cv_cxx_have_shared_ptr=yes],[mst_cv_cxx_have_shared_ptr=no])
		  AC_LANG_RESTORE
		 ]
 )
if test "X$mst_cv_cxx_have_shared_ptr" = Xyes; then
  AC_DEFINE([HAVE_SHARED_PTR],[],[define if the compiler has shared_ptr])
fi
])
