# serial 2

# MST_DEV_ENV_VARS
#------------
AC_DEFUN_ONCE([MST_DEV_ENV_VARS],
[
AC_ARG_VAR([MST_VAR_PFX],
	[The prefix to environment variables used by the MST software. Defaults to MST])

test -z "$MST_VAR_PFX" \
     && MST_VAR_PFX=MST

AC_ARG_VAR(MST_ROOT, [MST root directory])

test -z "$MST_ROOT" &&
	AC_MSG_ERROR([The MST_ROOT variable must be specified])

AC_SUBST([MST_ROOT_VAR],[${MST_VAR_PFX}_ROOT])
AC_SUBST([MST_SIMUL_ROOT_VAR],[${MST_VAR_PFX}_SIMUL_ROOT])
AC_SUBST([MST_OTS_ROOT_VAR],[${MST_VAR_PFX}_OTS_ROOT])
AC_SUBST([MST_TEMPLATE_ROOT_VAR],[${MST_VAR_PFX}_TEMPLATE_ROOT])
AC_SUBST([MST_PGHOST_VAR],[${MST_VAR_PFX}_PGHOST])
AC_SUBST([MST_SYBASE_VAR],[${MST_VAR_PFX}_SYBASE])
AC_SUBST([MST_LOCATE_PATH_VAR],[${MST_VAR_PFX}_LOCATE_PATH])

# unlike MST_ROOT, these contain shell code, not actual values.  the
# variables cannot have the form MST_XXX_ROOT, as this will override
# the existing environment variable of that name (if MST_VAR_PFX ==
# MST_, which is the default) and this messes up things in the
# development environment
AC_SUBST([MST_SIMUL_ROOT_VAL],[\$${MST_ROOT_VAR}/simul])
AC_SUBST([MST_OTS_ROOT_VAL],[\$${MST_ROOT_VAR}/ots])
AC_SUBST([MST_TEMPLATE_ROOT_VAL],[\$${MST_ROOT_VAR}/lib/templates])


# These will create generic MST_XXX_ROOT variables (if they do not
# exist) and propagate them correctly.

test -z "$MST_SIMUL_ROOT" \
     && eval MST_SIMUL_ROOT="$MST_SIMUL_ROOT_VAL"
AC_SUBST([MST_SIMUL_ROOT])

test -z "$MST_OTS_ROOT" \
     && eval MST_OTS_ROOT="$MST_OTS_ROOT_VAL"
AC_SUBST([MST_OTS_ROOT])

test -z "$MST_TEMPLATE_ROOT" \
     && eval MST_TEMPLATE_ROOT="$MST_TEMPLATE_ROOT_VAL"
AC_SUBST([MST_TEMPLATE_ROOT])



])# MST_DEV_ENV_VARS

# MST_DEV_INIT
#---------
# generic initializations for MST specific (e.g. development) packages
AC_DEFUN([MST_DEV_INIT],
[
  AC_REQUIRE([MST_DEV_ENV_VARS])

]) #MST_DEV_INIT

