# LICENSE
#
#   Copyright (c) 2025 Smithsonian Astrophysical Observatory
#   Copyright (c) 2025 Diab Jerius
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#  When you make and distribute a modified version of the Autoconf
#   Macro, you may extend this special exception to the GPL to apply
#   to your modified version as well.

# serial 1


# SYNOPSIS
#
#   MST_FORTRAN_CHARLEN_T([LANG])
#
AC_DEFUN([MST_FORTRAN_CHARLEN_T],
[
  m4_define([_lang],[$1])
  m4_define([_prefix],[$2])
  m4_if(_lang, [], [AC_MSG_ERROR([ no Fortran lang specified ])])

  MST_GNU_FORTRAN_VERSION([$1])

  AS_IF([test "$mst_gnu_fort_version" = '0.0.0'],
        [AC_MSG_FAILURE([ "Couldn't find a GNU Fortran compiler for: $1"])],
        [
         AC_CONFIG_COMMANDS([mst_fortran_charlen_t.h],
                  [cat  > []_prefix[]mst_fortran_charlen_t.h <<EOF
#ifndef MST_FORTRAN_CHARLEN_T_H
#define MST_FORTRAN_CHARLEN_T_H
#if __GNUC__ > 7
typedef size_t mst_fortran_charlen_t;
#else
typedef int mst_fortran_charlen_t;
#endif
#endif /* MST_FORTRAN_CHARLEN_T_H */
EOF
])
])
])
