# unpack fused gtest sources

# serial 3

# MST_GTEST
#----------
AC_DEFUN([MST_GTEST],
[
AC_SUBST([MST_GTEST_M4])
AC_ARG_WITH( [gtest],
             [AS_HELP_STRING([--with-gtest=ARG],
                             [ARG is path to googletest archive @<:@default=use bundled version@:>@])],
             [],[with_gtest=no]
           )
if test "$with_gtest" = "" ; then

    AC_MSG_ERROR([--with-gtest requires an argument])

elif test "$with_gtest" = no ; then

    AC_CHECK_FILE([$srcdir/tests/gtest/src/gtest-all.cc],
                  [],
                  [AC_CHECK_FILE([tests/gtest/src/gtest-all.cc],
                                 [],
                                 [AC_MSG_ERROR([googletest is not bundled; please specify it with --with-gtest])]
                                 )
                  ]
                 )
    AC_MSG_NOTICE([using bundled googletest])
else

    AC_MSG_NOTICE([trying googletest distribution $with_gtest])
    AC_CHECK_FILE([$with_gtest],
                  [],
                  [AC_MSG_ERROR(cannot find $with_gtest)]
                 )
    AS_CASE( [$with_gtest],
            [*.zip],
            [
                AC_PATH_PROG([UNZIP],[unzip],[no])
                test "$UNZIP" = no && \
                    AC_MSG_ERROR([unzip not found; unable to extract googletest])
                AC_MSG_NOTICE([unpacking $with_gtest])
                AS_MKDIR_P([tests/gtest])

		# find license/copying file
		gtest_license=`unzip -Z -1 $with_gtest | grep -E '^[[^/]]*/LICENSE|COPYING'` \
		   || AC_MSG_ERROR([can't find license file in $with_gtest])
                unzip -o -j -q $with_gtest "$gtest_license" -d tests/gtest \
                      || AC_MSG_ERROR([error extracting googletest license])

                unzip -o -q \
                    $with_gtest "*/googletest/src/*" "*/googletest/include/*" -d tests/gtest/unzip \
                    || AC_MSG_ERROR([error extracting googletest source files])

                rm -rf tests/gtest/src tests/gtest/include
                mv `find tests/gtest/unzip -name src` tests/gtest
                mv `find tests/gtest/unzip -name include` tests/gtest
                rm -rf tests/gtest/unzip
            ],
            [
                AC_MSG_ERROR([do not know how to unpack googletest archive $with_gtest])
            ]
            )

fi

dnl otherwise autoconf flags the below usage as a possible
dnl undefined macro if AM_CXXFLAGS hasn't been mentioned yet
m4_pattern_allow([AM_CXXFLAGS])

# googletest uses variadic macros, which g++ -pedantic-errors is very unhappy about
AC_SUBST([GTEST_CXXFLAGS],
        [`AS_ECHO_N(["$AM_CXXFLAGS $CXXFLAGS"]) | sed s/-pedantic-errors/-pedantic/`]
        )
])
