# serial 1

# MST_CHECK_LIB_CPGPLOT
#------------------
AC_DEFUN([MST_CHECK_LIB_CPGPLOT],
[AC_MSG_NOTICE([Checking for C pgplot in a variety of places])
AC_REQUIRE([AC_FC_LIBRARY_LDFLAGS])
cpgplot_LDFLAGS=""

AC_SUBST(cpgplot_LIBS)
AC_SUBST(cpgplot_LDFLAGS)
AC_SUBST(cpgplot_CFLAGS)

# kind of kludgy.  not sure if png is compiled into PGPLOT or not, so
# see if libpng-config is around; if so, toss png into the mix.  can't hurt
AC_CHECK_PROG( [HAVE_PNG], [libpng-config], [yes], [no] )

if test "$HAVE_PNG" = yes ; then

  PNG_LDFLAGS=`libpng-config --ldflags`
  PNG_CFLAGS=`libpng-config --cflags`

fi



PKG_CHECK_MODULES(cpgplot,cpgplot,
		 [],
		 [AC_MSG_WARN([no pkg-config setup for pgplot; trying system libraries])

		 # need this as it is AC_REQUIRE'd by AC_PATH_XTRA, which ends up putting
		 # it above the code for PKG_CHECK_MODULES
		   AC_PATH_X
		   AC_PATH_XTRA
		   if test "$no_x" = yes; then
		     AC_MSG_ERROR([X Window System not found. Are the development packages installed?!])
		   fi
		   AC_SUBST(X_LIBS)
		   AC_SUBST(X_PRE_LIBS)
		   AC_SUBST(X_EXTRA_LIBS)

	          cpgplot_LIBS="-lpgplot $PNG_LDFLAGS $FLIBS $X_PRE_LIBS $X_EXTRA_LIBS $X_LIBS -lX11"
		  cpgplot_CFLAGS="$PNG_CFLAGS"
	          AC_ARG_WITH(cpgplot-libraries,
			      AS_HELP_STRING([--with-cpgplot-libraries=/path/to/library_dir],
					     [specify path to directory containing pgplot libraries]),
			      [cpgplot_LDFLAGS="-L$with_cpgplot_libraries"])
		  AC_ARG_WITH(cpgplot-includes,
			      AS_HELP_STRING([--with-cpgplot-includes=/path/to/includes_dir],
					     [specify path to directory containing pgplot header files]),
			      [cpgplot_CFLAGS="-I$with_cpgplot_includes"])
	          AC_CHECK_LIB([cpgplot],[cpgopen],[],
		               [AC_MSG_ERROR([unable to find cpgplot])],
		               [$cpgplot_LDFLAGS $cpgplot_LIBS])
	   	 ])


])# MST_CHECK_LIB_CPGPLOT


