# serial 2

AC_DEFUN([MST_PROG_LUA_MODULES],[dnl

m4_define([mst_lua_modules])
m4_foreach([mst_lua_module], m4_split(m4_normalize([$1])),
	  [
	   m4_append([mst_lua_modules],[']mst_lua_module[' ])
          ])

# Make sure we have lua
AS_IF( [test -z "$LUA"],
       [AC_MSG_ERROR( "LUA not set: use [[MST_CHECK_LUA]] to discover the appropriate Lua executable" )]
       )

mst_lua_modules_failed=0

for mst_lua_module in mst_lua_modules; do

  mst_lua_modulex=`echo $mst_lua_module | sed "s/\./_/g"`

  AC_CACHE_CHECK([for lua module $mst_lua_module],
                 [mst_cv_lua_$mst_lua_modulex],
                 [
                  eval mst_cv_lua_$mst_lua_modulex=no
                  $LUA $LUAFLAGS -l $mst_lua_module -e 'return' 2>/dev/null && eval mst_cv_lua_$mst_lua_modulex=yes
		 ]
  )
  AS_IF([eval test "x\${mst_cv_lua_$mst_lua_modulex}" = "xno"],
        [mst_lua_modules_failed=1]
  )
done

# Run optional shell commands
AS_IF( [test "$mst_lua_modules_failed" = 0],
       [  :
          $2
       ],
       [
          :
          $3
       ]
)      

])
