# serial 1

# _MST_PATCH_TEST( VARIABLE, PROG-TO-TEST, [VALUE-IF-OK], [VALUE-IF-NOT] )
# check if patch or applypatch work
#---------------------------------------------------------
AC_DEFUN([_MST_PATCH_TEST],
[# Extract program name to test
AC_MSG_CHECKING([if $2 works correctly])
AS_MKDIR_P(conftest.dir)
echo "b" > conftest.dir/a
echo "a" > conftest.dir/b
cat >conftest.patch <<'_ACEOF'
# This is a patch for conftest.orig to update it to conftest.dir
#
# To apply this patch:
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'applypatch' program with this patch file as input.
#
# If you do not have 'applypatch', it is part of the 'makepatch' package
# that you can fetch from the Comprehensive Perl Archive Network:
# http://www.perl.com/CPAN/authors/Johan_Vromans/makepatch-x.y.tar.gz
# In the above URL, 'x' should be 2 or higher.
#
# To apply this patch without the use of 'applypatch':
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'patch' program with this file as input.
#
#### End of Preamble ####

#### Patch data follows ####
diff -c 'conftest.orig/a' 'conftest.dir/a'
Index: ./a
*** ./a	Fri Feb 10 18:58:58 2006
--- ./a	Fri Feb 10 18:57:54 2006
***************
*** 1 ****
! b
--- 1 ----
! a
diff -c 'conftest.orig/b' 'conftest.dir/b'
Index: ./b
*** ./b	Fri Feb 10 18:59:02 2006
--- ./b	Fri Feb 10 18:58:00 2006
***************
*** 1 ****
! a
--- 1 ----
! b
#### End of Patch data ####

#### ApplyPatch data follows ####
# Data version        : 1.0
# Date generated      : Fri Feb 10 18:59:05 2006
# Generated by        : makepatch 2.00
# Recurse directories : Yes
# p 'a' 2 1139615874 0100644
# p 'b' 2 1139615880 0100644
#### End of ApplyPatch data ####

#### End of Patch kit [created: Fri Feb 10 18:59:05 2006] ####
#### Checksum: 48 1368 35171 ####
_ACEOF
cd conftest.dir
_RC=1
$2 < ../conftest.patch >/dev/null 2>&1 && _RC=0
cd ..
rm -rf conftest.dir conftest.patch
if test $_RC = 0
then
  AC_MSG_RESULT([yes])
  m4_ifvaln([$3],[AS_VAR_SET([$1],[$3])])dnl
else 
  AC_MSG_RESULT([no])
  m4_ifvaln([$4],[AS_VAR_SET([$1],[$4])])dnl
fi
])# _MST_PATCH_TEST


# MST_PROG_PATCH
# --------------
AC_DEFUN([MST_PROG_PATCH],
[
  AC_ARG_VAR([PATCH], [explict path to patch program])
  AC_ARG_WITH([patch],
	      AS_HELP_STRING([--with-patch=/path/to/patch],
			     [explicitly specify path to patch command]),
	      [PATCH=$withval]
	     )
  AC_PATH_PROG([PATCH], [patch])
  if test -n "$PATCH"  ; then
    _MST_PATCH_TEST(PATCH,[$PATCH],,[""])
    if test -z "$PATCH" ; then
    AC_MSG_WARN([broken patch command; try installing GNU patch])
    fi
  fi
  AC_SUBST(PATCH)
])# MST_PROG_PATCH


# MST_PROG_APPLYPATCH
#--------------------
AC_DEFUN([MST_PROG_APPLYPATCH],
[
 AC_ARG_VAR([APPLYPATCH], [explicit path to applypatch program])
 AC_REQUIRE([MST_PROG_PATCH])
 if test -n "$PATCH" ; then	
   AC_PATH_PROG([APPLYPATCH], [applypatch], [] )
 fi
 AC_SUBST(APPLYPATCH)
])# MST_PROG_APPLYPATCH

 
