# serial 1

# MST_PROG_PROVE_EXEC
#--------------------
# test for Perl's prove command which accepts --exec
#
AC_DEFUN([MST_PROG_PROVE_EXEC],
[AC_CACHE_CHECK( [Perl prove with --exec],[mst_cv_prog_prove_exec],
		 [mst_cv_prog_prove_exec=no
		  AC_PATH_PROG(PROVE,prove)
		  if test -n "$PROVE"; then
		   # for some reason prove --help | grep -- --exec
		   # returns 1 upon success on linux.  dunno
		   # why. works if it's written out to a file
		    : ${TMPDIR=/tmp}
		    {
		    	 tmp=`(umask 077 && mktemp -d "$TMPDIR/fooXXXXXX") 2>/dev/null` \
			  && test -n "$tmp" && test -d "$tmp"
		    } || {
		    	 tmp=$TMPDIR/foo$$-$RANDOM
		    	 (umask 077 && mkdir "$tmp")
		    } || exit $?
		    trap "/bin/rm -rf $tmp" 0

		    ${PROVE} --help > $tmp/prove.out 2>&1
		     grep -- --exec $tmp/prove.out > /dev/null 2>&1 &&
		         mst_cv_prog_prove_exec=yes
		  fi
		  ] )
  if test "x$mst_cv_prog_prove_exec" = xno; then
    AC_MSG_ERROR([Cannot find prove which accepts --exec; please update the Test::Harness Perl module])
  fi
])# MST_PROG_PROVE_EXEC
