# generated automatically by aclocal 1.18.1 -*- Autoconf -*-

# Copyright (C) 1996-2025 Free Software Foundation, Inc.

# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

m4_ifndef([AC_CONFIG_MACRO_DIRS], [m4_defun([_AM_CONFIG_MACRO_DIRS], [])m4_defun([AC_CONFIG_MACRO_DIRS], [_AM_CONFIG_MACRO_DIRS($@)])])
# ===========================================================================
#   https://www.gnu.org/software/autoconf-archive/ax_ac_append_to_file.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_AC_APPEND_TO_FILE([FILE],[DATA])
#
# DESCRIPTION
#
#   Appends the specified data to the specified Autoconf is run. If you want
#   to append to a file when configure is run use AX_APPEND_TO_FILE instead.
#
# LICENSE
#
#   Copyright (c) 2009 Allan Caffee <allan.caffee@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 10

AC_DEFUN([AX_AC_APPEND_TO_FILE],[
AC_REQUIRE([AX_FILE_ESCAPES])
m4_esyscmd(
AX_FILE_ESCAPES
[
printf "%s" "$2" >> "$1"
])
])

# ===========================================================================
#   https://www.gnu.org/software/autoconf-archive/ax_ac_print_to_file.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_AC_PRINT_TO_FILE([FILE],[DATA])
#
# DESCRIPTION
#
#   Writes the specified data to the specified file when Autoconf is run. If
#   you want to print to a file when configure is run use AX_PRINT_TO_FILE
#   instead.
#
# LICENSE
#
#   Copyright (c) 2009 Allan Caffee <allan.caffee@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 10

AC_DEFUN([AX_AC_PRINT_TO_FILE],[
m4_esyscmd(
AC_REQUIRE([AX_FILE_ESCAPES])
[
printf "%s" "$2" > "$1"
])
])

# ===========================================================================
#  https://www.gnu.org/software/autoconf-archive/ax_add_am_macro_static.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_ADD_AM_MACRO_STATIC([RULE])
#
# DESCRIPTION
#
#   Adds the specified rule to $AMINCLUDE.
#
# LICENSE
#
#   Copyright (c) 2009 Tom Howard <tomhoward@users.sf.net>
#   Copyright (c) 2009 Allan Caffee <allan.caffee@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 8

AC_DEFUN([AX_ADD_AM_MACRO_STATIC],[
  AC_REQUIRE([AX_AM_MACROS_STATIC])
  AX_AC_APPEND_TO_FILE(AMINCLUDE_STATIC,[$1])
])

# ===========================================================================
#   https://www.gnu.org/software/autoconf-archive/ax_am_macros_static.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_AM_MACROS_STATIC
#
# DESCRIPTION
#
#   Adds support for macros that create Automake rules. You must manually
#   add the following line
#
#     include $(top_srcdir)/aminclude_static.am
#
#   to your Makefile.am files.
#
# LICENSE
#
#   Copyright (c) 2009 Tom Howard <tomhoward@users.sf.net>
#   Copyright (c) 2009 Allan Caffee <allan.caffee@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 11

AC_DEFUN([AMINCLUDE_STATIC],[aminclude_static.am])

AC_DEFUN([AX_AM_MACROS_STATIC],
[
AX_AC_PRINT_TO_FILE(AMINCLUDE_STATIC,[
# ]AMINCLUDE_STATIC[ generated automatically by Autoconf
# from AX_AM_MACROS_STATIC on ]m4_esyscmd([LC_ALL=C date])[
])
])

# ===========================================================================
#    https://www.gnu.org/software/autoconf-archive/ax_cxx_namespaces.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_CXX_NAMESPACES
#
# DESCRIPTION
#
#   If the compiler can prevent names clashes using namespaces, define
#   HAVE_NAMESPACES.
#
# LICENSE
#
#   Copyright (c) 2008 Todd Veldhuizen
#   Copyright (c) 2008 Luc Maisonobe <luc@spaceroots.org>
#   Copyright (c) 2013 Bastien Roucaries <roucaries.bastien+autoconf@gmail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 9

AU_ALIAS([AC_CXX_NAMESPACES], [AX_CXX_NAMESPACES])
AC_DEFUN([AX_CXX_NAMESPACES],
[AC_CACHE_CHECK(whether the compiler implements namespaces,
ax_cv_cxx_namespaces,
[AC_LANG_PUSH([C++])
 AC_COMPILE_IFELSE([AC_LANG_SOURCE([namespace Outer { namespace Inner { int i = 0; }}
                                   using namespace Outer::Inner; int foo(void) { return i;} ])],
                   ax_cv_cxx_namespaces=yes, ax_cv_cxx_namespaces=no)
 AC_LANG_POP
])
if test "$ax_cv_cxx_namespaces" = yes; then
  AC_DEFINE(HAVE_NAMESPACES,,[define if the compiler implements namespaces])
fi
])

# ===========================================================================
#     https://www.gnu.org/software/autoconf-archive/ax_file_escapes.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_FILE_ESCAPES
#
# DESCRIPTION
#
#   Writes the specified data to the specified file.
#
# LICENSE
#
#   Copyright (c) 2008 Tom Howard <tomhoward@users.sf.net>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 8

AC_DEFUN([AX_FILE_ESCAPES],[
AX_DOLLAR="\$"
AX_SRB="\\135"
AX_SLB="\\133"
AX_BS="\\\\"
AX_DQ="\""
])

# ===========================================================================
#          https://www.gnu.org/software/autoconf-archive/ax_lua.html
# ===========================================================================
#
# SYNOPSIS
#
#   AX_PROG_LUA[([MINIMUM-VERSION], [TOO-BIG-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])]
#   AX_LUA_HEADERS[([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])]
#   AX_LUA_LIBS[([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])]
#   AX_LUA_READLINE[([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])]
#
# DESCRIPTION
#
#   Detect a Lua interpreter, optionally specifying a minimum and maximum
#   version number. Set up important Lua paths, such as the directories in
#   which to install scripts and modules (shared libraries).
#
#   Also detect Lua headers and libraries. The Lua version contained in the
#   header is checked to match the Lua interpreter version exactly. When
#   searching for Lua libraries, the version number is used as a suffix.
#   This is done with the goal of supporting multiple Lua installs (5.1,
#   5.2, 5.3, and 5.4 side-by-side).
#
#   A note on compatibility with previous versions: This file has been
#   mostly rewritten for serial 18. Most developers should be able to use
#   these macros without needing to modify configure.ac. Care has been taken
#   to preserve each macro's behavior, but there are some differences:
#
#   1) AX_WITH_LUA is deprecated; it now expands to the exact same thing as
#   AX_PROG_LUA with no arguments.
#
#   2) AX_LUA_HEADERS now checks that the version number defined in lua.h
#   matches the interpreter version. AX_LUA_HEADERS_VERSION is therefore
#   unnecessary, so it is deprecated and does not expand to anything.
#
#   3) The configure flag --with-lua-suffix no longer exists; the user
#   should instead specify the LUA precious variable on the command line.
#   See the AX_PROG_LUA description for details.
#
#   Please read the macro descriptions below for more information.
#
#   This file was inspired by Andrew Dalke's and James Henstridge's
#   python.m4 and Tom Payne's, Matthieu Moy's, and Reuben Thomas's ax_lua.m4
#   (serial 17). Basically, this file is a mash-up of those two files. I
#   like to think it combines the best of the two!
#
#   AX_PROG_LUA: Search for the Lua interpreter, and set up important Lua
#   paths. Adds precious variable LUA, which may contain the path of the Lua
#   interpreter. If LUA is blank, the user's path is searched for an
#   suitable interpreter.
#
#   If MINIMUM-VERSION is supplied, then only Lua interpreters with a
#   version number greater or equal to MINIMUM-VERSION will be accepted. If
#   TOO-BIG-VERSION is also supplied, then only Lua interpreters with a
#   version number greater or equal to MINIMUM-VERSION and less than
#   TOO-BIG-VERSION will be accepted.
#
#   The Lua version number, LUA_VERSION, is found from the interpreter, and
#   substituted. LUA_PLATFORM is also found, but not currently supported (no
#   standard representation).
#
#   Finally, the macro finds four paths:
#
#     luadir             Directory to install Lua scripts.
#     pkgluadir          $luadir/$PACKAGE
#     luaexecdir         Directory to install Lua modules.
#     pkgluaexecdir      $luaexecdir/$PACKAGE
#
#   These paths are found based on $prefix, $exec_prefix, Lua's
#   package.path, and package.cpath. The first path of package.path
#   beginning with $prefix is selected as luadir. The first path of
#   package.cpath beginning with $exec_prefix is used as luaexecdir. This
#   should work on all reasonable Lua installations. If a path cannot be
#   determined, a default path is used. Of course, the user can override
#   these later when invoking make.
#
#     luadir             Default: $prefix/share/lua/$LUA_VERSION
#     luaexecdir         Default: $exec_prefix/lib/lua/$LUA_VERSION
#
#   These directories can be used by Automake as install destinations. The
#   variable name minus 'dir' needs to be used as a prefix to the
#   appropriate Automake primary, e.g. lua_SCRIPS or luaexec_LIBRARIES.
#
#   If an acceptable Lua interpreter is found, then ACTION-IF-FOUND is
#   performed, otherwise ACTION-IF-NOT-FOUND is performed. If ACTION-IF-NOT-
#   FOUND is blank, then it will default to printing an error. To prevent
#   the default behavior, give ':' as an action.
#
#   AX_LUA_HEADERS: Search for Lua headers. Requires that AX_PROG_LUA be
#   expanded before this macro. Adds precious variable LUA_INCLUDE, which
#   may contain Lua specific include flags, e.g. -I/usr/include/lua5.1. If
#   LUA_INCLUDE is blank, then this macro will attempt to find suitable
#   flags.
#
#   LUA_INCLUDE can be used by Automake to compile Lua modules or
#   executables with embedded interpreters. The *_CPPFLAGS variables should
#   be used for this purpose, e.g. myprog_CPPFLAGS = $(LUA_INCLUDE).
#
#   This macro searches for the header lua.h (and others). The search is
#   performed with a combination of CPPFLAGS, CPATH, etc, and LUA_INCLUDE.
#   If the search is unsuccessful, then some common directories are tried.
#   If the headers are then found, then LUA_INCLUDE is set accordingly.
#
#   The paths automatically searched are:
#
#     * /usr/include/luaX.Y
#     * /usr/include/lua/X.Y
#     * /usr/include/luaXY
#     * /usr/local/include/luaX.Y
#     * /usr/local/include/lua-X.Y
#     * /usr/local/include/lua/X.Y
#     * /usr/local/include/luaXY
#
#   (Where X.Y is the Lua version number, e.g. 5.1.)
#
#   The Lua version number found in the headers is always checked to match
#   the Lua interpreter's version number. Lua headers with mismatched
#   version numbers are not accepted.
#
#   If headers are found, then ACTION-IF-FOUND is performed, otherwise
#   ACTION-IF-NOT-FOUND is performed. If ACTION-IF-NOT-FOUND is blank, then
#   it will default to printing an error. To prevent the default behavior,
#   set the action to ':'.
#
#   AX_LUA_LIBS: Search for Lua libraries. Requires that AX_PROG_LUA be
#   expanded before this macro. Adds precious variable LUA_LIB, which may
#   contain Lua specific linker flags, e.g. -llua5.1. If LUA_LIB is blank,
#   then this macro will attempt to find suitable flags.
#
#   LUA_LIB can be used by Automake to link Lua modules or executables with
#   embedded interpreters. The *_LIBADD and *_LDADD variables should be used
#   for this purpose, e.g. mymod_LIBADD = $(LUA_LIB).
#
#   This macro searches for the Lua library. More technically, it searches
#   for a library containing the function lua_load. The search is performed
#   with a combination of LIBS, LIBRARY_PATH, and LUA_LIB.
#
#   If the search determines that some linker flags are missing, then those
#   flags will be added to LUA_LIB.
#
#   If libraries are found, then ACTION-IF-FOUND is performed, otherwise
#   ACTION-IF-NOT-FOUND is performed. If ACTION-IF-NOT-FOUND is blank, then
#   it will default to printing an error. To prevent the default behavior,
#   set the action to ':'.
#
#   AX_LUA_READLINE: Search for readline headers and libraries. Requires the
#   AX_LIB_READLINE macro, which is provided by ax_lib_readline.m4 from the
#   Autoconf Archive.
#
#   If a readline compatible library is found, then ACTION-IF-FOUND is
#   performed, otherwise ACTION-IF-NOT-FOUND is performed.
#
# LICENSE
#
#   Copyright (c) 2015 Reuben Thomas <rrt@sc3d.org>
#   Copyright (c) 2014 Tim Perkins <tprk77@gmail.com>
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <https://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#   This special exception to the GPL applies to versions of the Autoconf
#   Macro released by the Autoconf Archive. When you make and distribute a
#   modified version of the Autoconf Macro, you may extend this special
#   exception to the GPL to apply to your modified version as well.

#serial 45

dnl =========================================================================
dnl AX_PROG_LUA([MINIMUM-VERSION], [TOO-BIG-VERSION],
dnl             [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl =========================================================================
AC_DEFUN([AX_PROG_LUA],
[
  dnl Check for required tools.
  AC_REQUIRE([AC_PROG_GREP])
  AC_REQUIRE([AC_PROG_SED])

  dnl Make LUA a precious variable.
  AC_ARG_VAR([LUA], [The Lua interpreter, e.g. /usr/bin/lua5.1])

  dnl Find a Lua interpreter.
  m4_define_default([_AX_LUA_INTERPRETER_LIST],
    [lua lua5.4 lua54 lua5.3 lua53 lua5.2 lua52 lua5.1 lua51 lua50])

  m4_if([$1], [],
  [ dnl No version check is needed. Find any Lua interpreter.
    AS_IF([test "x$LUA" = 'x'],
      [AC_PATH_PROGS([LUA], [_AX_LUA_INTERPRETER_LIST], [:])])
    ax_display_LUA='lua'

    AS_IF([test "x$LUA" != 'x:'],
      [ dnl At least check if this is a Lua interpreter.
        AC_MSG_CHECKING([if $LUA is a Lua interpreter])
        _AX_LUA_CHK_IS_INTRP([$LUA],
          [AC_MSG_RESULT([yes])],
          [ AC_MSG_RESULT([no])
            AC_MSG_ERROR([not a Lua interpreter])
          ])
      ])
  ],
  [ dnl A version check is needed.
    AS_IF([test "x$LUA" != 'x'],
    [ dnl Check if this is a Lua interpreter.
      AC_MSG_CHECKING([if $LUA is a Lua interpreter])
      _AX_LUA_CHK_IS_INTRP([$LUA],
        [AC_MSG_RESULT([yes])],
        [ AC_MSG_RESULT([no])
          AC_MSG_ERROR([not a Lua interpreter])
        ])
      dnl Check the version.
      m4_if([$2], [],
        [_ax_check_text="whether $LUA version >= $1"],
        [_ax_check_text="whether $LUA version >= $1, < $2"])
      AC_MSG_CHECKING([$_ax_check_text])
      _AX_LUA_CHK_VER([$LUA], [$1], [$2],
        [AC_MSG_RESULT([yes])],
        [ AC_MSG_RESULT([no])
          AC_MSG_ERROR([version is out of range for specified LUA])])
      ax_display_LUA=$LUA
    ],
    [ dnl Try each interpreter until we find one that satisfies VERSION.
      m4_if([$2], [],
        [_ax_check_text="for a Lua interpreter with version >= $1"],
        [_ax_check_text="for a Lua interpreter with version >= $1, < $2"])
      AC_CACHE_CHECK([$_ax_check_text],
        [ax_cv_pathless_LUA],
        [ for ax_cv_pathless_LUA in _AX_LUA_INTERPRETER_LIST none; do
            test "x$ax_cv_pathless_LUA" = 'xnone' && break
            _AX_LUA_CHK_IS_INTRP([$ax_cv_pathless_LUA], [], [continue])
            _AX_LUA_CHK_VER([$ax_cv_pathless_LUA], [$1], [$2], [break])
          done
        ])
      dnl Set $LUA to the absolute path of $ax_cv_pathless_LUA.
      AS_IF([test "x$ax_cv_pathless_LUA" = 'xnone'],
        [LUA=':'],
        [AC_PATH_PROG([LUA], [$ax_cv_pathless_LUA])])
      ax_display_LUA=$ax_cv_pathless_LUA
    ])
  ])

  AS_IF([test "x$LUA" = 'x:'],
  [ dnl Run any user-specified action, or abort.
    m4_default([$4], [AC_MSG_ERROR([cannot find suitable Lua interpreter])])
  ],
  [ dnl Query Lua for its version number.
    AC_CACHE_CHECK([for $ax_display_LUA version],
      [ax_cv_lua_version],
      [ dnl Get the interpreter version in X.Y format. This should work for
        dnl interpreters version 5.0 and beyond.
        ax_cv_lua_version=[`$LUA -e '
          -- return a version number in X.Y format
          local _, _, ver = string.find(_VERSION, "^Lua (%d+%.%d+)")
          print(ver or "")'`]
      ])
    AS_IF([test "x$ax_cv_lua_version" = 'x'],
      [AC_MSG_ERROR([invalid Lua version number])])
    AC_SUBST([LUA_VERSION], [$ax_cv_lua_version])
    AC_SUBST([LUA_SHORT_VERSION], [`echo "$LUA_VERSION" | $SED 's|\.||'`])

    dnl The following check is not supported:
    dnl At times (like when building shared libraries) you may want to know
    dnl which OS platform Lua thinks this is.
    AC_CACHE_CHECK([for $ax_display_LUA platform],
      [ax_cv_lua_platform],
      [ax_cv_lua_platform=[`$LUA -e 'print("unknown")'`]])
    AC_SUBST([LUA_PLATFORM], [$ax_cv_lua_platform])

    dnl Use the values of $prefix and $exec_prefix for the corresponding
    dnl values of LUA_PREFIX and LUA_EXEC_PREFIX. These are made distinct
    dnl variables so they can be overridden if need be. However, the general
    dnl consensus is that you shouldn't need this ability.
    AC_SUBST([LUA_PREFIX], ['${prefix}'])
    AC_SUBST([LUA_EXEC_PREFIX], ['${exec_prefix}'])

    dnl Lua provides no way to query the script directory, and instead
    dnl provides LUA_PATH. However, we should be able to make a safe educated
    dnl guess. If the built-in search path contains a directory which is
    dnl prefixed by $prefix, then we can store scripts there. The first
    dnl matching path will be used.
    AC_CACHE_CHECK([for $ax_display_LUA script directory],
      [ax_cv_lua_luadir],
      [ AS_IF([test "x$prefix" = 'xNONE'],
          [ax_lua_prefix=$ac_default_prefix],
          [ax_lua_prefix=$prefix])

        dnl Initialize to the default path.
        ax_cv_lua_luadir="$LUA_PREFIX/share/lua/$LUA_VERSION"

        dnl Try to find a path with the prefix.
        _AX_LUA_FND_PRFX_PTH([$LUA], [$ax_lua_prefix], [script])
        AS_IF([test "x$ax_lua_prefixed_path" != 'x'],
        [ dnl Fix the prefix.
          _ax_strip_prefix=`echo "$ax_lua_prefix" | $SED 's|.|.|g'`
          ax_cv_lua_luadir=`echo "$ax_lua_prefixed_path" | \
            $SED "s|^$_ax_strip_prefix|$LUA_PREFIX|"`
        ])
      ])
    AC_SUBST([luadir], [$ax_cv_lua_luadir])
    AC_SUBST([pkgluadir], [\${luadir}/$PACKAGE])

    dnl Lua provides no way to query the module directory, and instead
    dnl provides LUA_PATH. However, we should be able to make a safe educated
    dnl guess. If the built-in search path contains a directory which is
    dnl prefixed by $exec_prefix, then we can store modules there. The first
    dnl matching path will be used.
    AC_CACHE_CHECK([for $ax_display_LUA module directory],
      [ax_cv_lua_luaexecdir],
      [ AS_IF([test "x$exec_prefix" = 'xNONE'],
          [ax_lua_exec_prefix=$ax_lua_prefix],
          [ax_lua_exec_prefix=$exec_prefix])

        dnl Initialize to the default path.
        ax_cv_lua_luaexecdir="$LUA_EXEC_PREFIX/lib/lua/$LUA_VERSION"

        dnl Try to find a path with the prefix.
        _AX_LUA_FND_PRFX_PTH([$LUA],
          [$ax_lua_exec_prefix], [module])
        AS_IF([test "x$ax_lua_prefixed_path" != 'x'],
        [ dnl Fix the prefix.
          _ax_strip_prefix=`echo "$ax_lua_exec_prefix" | $SED 's|.|.|g'`
          ax_cv_lua_luaexecdir=`echo "$ax_lua_prefixed_path" | \
            $SED "s|^$_ax_strip_prefix|$LUA_EXEC_PREFIX|"`
        ])
      ])
    AC_SUBST([luaexecdir], [$ax_cv_lua_luaexecdir])
    AC_SUBST([pkgluaexecdir], [\${luaexecdir}/$PACKAGE])

    dnl Run any user specified action.
    $3
  ])
])

dnl AX_WITH_LUA is now the same thing as AX_PROG_LUA.
AC_DEFUN([AX_WITH_LUA],
[
  AC_MSG_WARN([[$0 is deprecated, please use AX_PROG_LUA instead]])
  AX_PROG_LUA
])


dnl =========================================================================
dnl _AX_LUA_CHK_IS_INTRP(PROG, [ACTION-IF-TRUE], [ACTION-IF-FALSE])
dnl =========================================================================
AC_DEFUN([_AX_LUA_CHK_IS_INTRP],
[
  dnl A minimal Lua factorial to prove this is an interpreter. This should work
  dnl for Lua interpreters version 5.0 and beyond.
  _ax_lua_factorial=[`$1 2>/dev/null -e '
    -- a simple factorial
    function fact (n)
      if n == 0 then
        return 1
      else
        return n * fact(n-1)
      end
    end
    print("fact(5) is " .. fact(5))'`]
  AS_IF([test "$_ax_lua_factorial" = 'fact(5) is 120'],
    [$2], [$3])
])


dnl =========================================================================
dnl _AX_LUA_CHK_VER(PROG, MINIMUM-VERSION, [TOO-BIG-VERSION],
dnl                 [ACTION-IF-TRUE], [ACTION-IF-FALSE])
dnl =========================================================================
AC_DEFUN([_AX_LUA_CHK_VER],
[
  dnl Check that the Lua version is within the bounds. Only the major and minor
  dnl version numbers are considered. This should work for Lua interpreters
  dnl version 5.0 and beyond.
  _ax_lua_good_version=[`$1 -e '
    -- a script to compare versions
    function verstr2num(verstr)
      local _, _, majorver, minorver = string.find(verstr, "^(%d+)%.(%d+)")
      if majorver and minorver then
        return tonumber(majorver) * 100 + tonumber(minorver)
      end
    end
    local minver = verstr2num("$2")
    local _, _, trimver = string.find(_VERSION, "^Lua (.*)")
    local ver = verstr2num(trimver)
    local maxver = verstr2num("$3") or 1e9
    if minver <= ver and ver < maxver then
      print("yes")
    else
      print("no")
    end'`]
    AS_IF([test "x$_ax_lua_good_version" = "xyes"],
      [$4], [$5])
])


dnl =========================================================================
dnl _AX_LUA_FND_PRFX_PTH(PROG, PREFIX, SCRIPT-OR-MODULE-DIR)
dnl =========================================================================
AC_DEFUN([_AX_LUA_FND_PRFX_PTH],
[
  dnl Get the script or module directory by querying the Lua interpreter,
  dnl filtering on the given prefix, and selecting the shallowest path. If no
  dnl path is found matching the prefix, the result will be an empty string.
  dnl The third argument determines the type of search, it can be 'script' or
  dnl 'module'. Supplying 'script' will perform the search with package.path
  dnl and LUA_PATH, and supplying 'module' will search with package.cpath and
  dnl LUA_CPATH. This is done for compatibility with Lua 5.0.

  ax_lua_prefixed_path=[`$1 -e '
    -- get the path based on search type
    local searchtype = "$3"
    local paths = ""
    if searchtype == "script" then
      paths = (package and package.path) or LUA_PATH
    elseif searchtype == "module" then
      paths = (package and package.cpath) or LUA_CPATH
    end
    -- search for the prefix
    local prefix = "'$2'"
    local minpath = ""
    local mindepth = 1e9
    string.gsub(paths, "(@<:@^;@:>@+)",
      function (path)
        path = string.gsub(path, "%?.*$", "")
        path = string.gsub(path, "/@<:@^/@:>@*$", "")
        if string.find(path, prefix) then
          local depth = string.len(string.gsub(path, "@<:@^/@:>@", ""))
          if depth < mindepth then
            minpath = path
            mindepth = depth
          end
        end
      end)
    print(minpath)'`]
])


dnl =========================================================================
dnl AX_LUA_HEADERS([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl =========================================================================
AC_DEFUN([AX_LUA_HEADERS],
[
  dnl Check for LUA_VERSION.
  AC_MSG_CHECKING([if LUA_VERSION is defined])
  AS_IF([test "x$LUA_VERSION" != 'x'],
    [AC_MSG_RESULT([yes])],
    [ AC_MSG_RESULT([no])
      AC_MSG_ERROR([cannot check Lua headers without knowing LUA_VERSION])
    ])

  dnl Make LUA_INCLUDE a precious variable.
  AC_ARG_VAR([LUA_INCLUDE], [The Lua includes, e.g. -I/usr/include/lua5.1])

  dnl Some default directories to search.
  LUA_SHORT_VERSION=`echo "$LUA_VERSION" | $SED 's|\.||'`
  m4_define_default([_AX_LUA_INCLUDE_LIST],
    [ /usr/include/lua$LUA_VERSION \
      /usr/include/lua-$LUA_VERSION \
      /usr/include/lua/$LUA_VERSION \
      /usr/include/lua$LUA_SHORT_VERSION \
      /usr/local/include/lua$LUA_VERSION \
      /usr/local/include/lua-$LUA_VERSION \
      /usr/local/include/lua/$LUA_VERSION \
      /usr/local/include/lua$LUA_SHORT_VERSION \
    ])

  dnl Try to find the headers.
  _ax_lua_saved_cppflags=$CPPFLAGS
  CPPFLAGS="$CPPFLAGS $LUA_INCLUDE"
  AC_CHECK_HEADERS([lua.h lualib.h lauxlib.h luaconf.h])
  CPPFLAGS=$_ax_lua_saved_cppflags

  dnl Try some other directories if LUA_INCLUDE was not set.
  AS_IF([test "x$LUA_INCLUDE" = 'x' &&
         test "x$ac_cv_header_lua_h" != 'xyes'],
    [ dnl Try some common include paths.
      for _ax_include_path in _AX_LUA_INCLUDE_LIST; do
        test ! -d "$_ax_include_path" && continue

        AC_MSG_CHECKING([for Lua headers in])
        AC_MSG_RESULT([$_ax_include_path])

        AS_UNSET([ac_cv_header_lua_h])
        AS_UNSET([ac_cv_header_lualib_h])
        AS_UNSET([ac_cv_header_lauxlib_h])
        AS_UNSET([ac_cv_header_luaconf_h])

        _ax_lua_saved_cppflags=$CPPFLAGS
        CPPFLAGS="$CPPFLAGS -I$_ax_include_path"
        AC_CHECK_HEADERS([lua.h lualib.h lauxlib.h luaconf.h])
        CPPFLAGS=$_ax_lua_saved_cppflags

        AS_IF([test "x$ac_cv_header_lua_h" = 'xyes'],
          [ LUA_INCLUDE="-I$_ax_include_path"
            break
          ])
      done
    ])

  AS_IF([test "x$ac_cv_header_lua_h" = 'xyes'],
    [ dnl Make a program to print LUA_VERSION defined in the header.
      dnl TODO It would be really nice if we could do this without compiling a
      dnl program, then it would work when cross compiling. But I'm not sure how
      dnl to do this reliably. For now, assume versions match when cross compiling.

      AS_IF([test "x$cross_compiling" != 'xyes'],
        [ AC_CACHE_CHECK([for Lua header version],
            [ax_cv_lua_header_version],
            [ _ax_lua_saved_cppflags=$CPPFLAGS
              CPPFLAGS="$CPPFLAGS $LUA_INCLUDE"
              AC_COMPUTE_INT(ax_cv_lua_header_version_major,[LUA_VERSION_NUM/100],[AC_INCLUDES_DEFAULT
#include <lua.h>
],[ax_cv_lua_header_version_major=unknown])
              AC_COMPUTE_INT(ax_cv_lua_header_version_minor,[LUA_VERSION_NUM%100],[AC_INCLUDES_DEFAULT
#include <lua.h>
],[ax_cv_lua_header_version_minor=unknown])
              AS_IF([test "x$ax_cv_lua_header_version_major" = xunknown || test "x$ax_cv_lua_header_version_minor" = xunknown],[
                ax_cv_lua_header_version=unknown
              ],[
                ax_cv_lua_header_version="$ax_cv_lua_header_version_major.$ax_cv_lua_header_version_minor"
              ])
              CPPFLAGS=$_ax_lua_saved_cppflags
            ])

          dnl Compare this to the previously found LUA_VERSION.
          AC_MSG_CHECKING([if Lua header version matches $LUA_VERSION])
          AS_IF([test "x$ax_cv_lua_header_version" = "x$LUA_VERSION"],
            [ AC_MSG_RESULT([yes])
              ax_header_version_match='yes'
            ],
            [ AC_MSG_RESULT([no])
              ax_header_version_match='no'
            ])
        ],
        [ AC_MSG_WARN([cross compiling so assuming header version number matches])
          ax_header_version_match='yes'
        ])
    ])

  dnl Was LUA_INCLUDE specified?
  AS_IF([test "x$ax_header_version_match" != 'xyes' &&
         test "x$LUA_INCLUDE" != 'x'],
    [AC_MSG_ERROR([cannot find headers for specified LUA_INCLUDE])])

  dnl Test the final result and run user code.
  AS_IF([test "x$ax_header_version_match" = 'xyes'], [$1],
    [m4_default([$2], [AC_MSG_ERROR([cannot find Lua includes])])])
])

dnl AX_LUA_HEADERS_VERSION no longer exists, use AX_LUA_HEADERS.
AC_DEFUN([AX_LUA_HEADERS_VERSION],
[
  AC_MSG_WARN([[$0 is deprecated, please use AX_LUA_HEADERS instead]])
])


dnl =========================================================================
dnl AX_LUA_LIBS([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl =========================================================================
AC_DEFUN([AX_LUA_LIBS],
[
  dnl TODO Should this macro also check various -L flags?

  dnl Check for LUA_VERSION.
  AC_MSG_CHECKING([if LUA_VERSION is defined])
  AS_IF([test "x$LUA_VERSION" != 'x'],
    [AC_MSG_RESULT([yes])],
    [ AC_MSG_RESULT([no])
      AC_MSG_ERROR([cannot check Lua libs without knowing LUA_VERSION])
    ])

  dnl Make LUA_LIB a precious variable.
  AC_ARG_VAR([LUA_LIB], [The Lua library, e.g. -llua5.1])

  AS_IF([test "x$LUA_LIB" != 'x'],
  [ dnl Check that LUA_LIBS works.
    _ax_lua_saved_libs=$LIBS
    LIBS="$LIBS $LUA_LIB"
    AC_SEARCH_LIBS([lua_load], [],
      [_ax_found_lua_libs='yes'],
      [_ax_found_lua_libs='no'])
    LIBS=$_ax_lua_saved_libs

    dnl Check the result.
    AS_IF([test "x$_ax_found_lua_libs" != 'xyes'],
      [AC_MSG_ERROR([cannot find libs for specified LUA_LIB])])
  ],
  [ dnl First search for extra libs.
    _ax_lua_extra_libs=''

    _ax_lua_saved_libs=$LIBS
    LIBS="$LIBS $LUA_LIB"
    AC_SEARCH_LIBS([exp], [m])
    AC_SEARCH_LIBS([dlopen], [dl])
    LIBS=$_ax_lua_saved_libs

    AS_IF([test "x$ac_cv_search_exp" != 'xno' &&
           test "x$ac_cv_search_exp" != 'xnone required'],
      [_ax_lua_extra_libs="$_ax_lua_extra_libs $ac_cv_search_exp"])

    AS_IF([test "x$ac_cv_search_dlopen" != 'xno' &&
           test "x$ac_cv_search_dlopen" != 'xnone required'],
      [_ax_lua_extra_libs="$_ax_lua_extra_libs $ac_cv_search_dlopen"])

    dnl Try to find the Lua libs.
    _ax_lua_saved_libs=$LIBS
    LIBS="$LIBS $LUA_LIB"
    AC_SEARCH_LIBS([lua_load],
      [ lua$LUA_VERSION \
        lua$LUA_SHORT_VERSION \
        lua-$LUA_VERSION \
        lua-$LUA_SHORT_VERSION \
        lua \
      ],
      [_ax_found_lua_libs='yes'],
      [_ax_found_lua_libs='no'],
      [$_ax_lua_extra_libs])
    LIBS=$_ax_lua_saved_libs

    AS_IF([test "x$ac_cv_search_lua_load" != 'xno' &&
           test "x$ac_cv_search_lua_load" != 'xnone required'],
      [LUA_LIB="$ac_cv_search_lua_load $_ax_lua_extra_libs"])
  ])

  dnl Test the result and run user code.
  AS_IF([test "x$_ax_found_lua_libs" = 'xyes'], [$1],
    [m4_default([$2], [AC_MSG_ERROR([cannot find Lua libs])])])
])


dnl =========================================================================
dnl AX_LUA_READLINE([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl =========================================================================
AC_DEFUN([AX_LUA_READLINE],
[
  AX_LIB_READLINE
  AS_IF([test "x$ac_cv_header_readline_readline_h" != 'x' &&
         test "x$ac_cv_header_readline_history_h" != 'x'],
    [ LUA_LIBS_CFLAGS="-DLUA_USE_READLINE $LUA_LIBS_CFLAGS"
      $1
    ],
    [$2])
])

# ===========================================================================
#     https://www.gnu.org/software/autoconf-archive/ax_prog_doxygen.html
# ===========================================================================
#
# SYNOPSIS
#
#   DX_INIT_DOXYGEN(PROJECT-NAME, [DOXYFILE-PATH], [OUTPUT-DIR], ...)
#   DX_DOXYGEN_FEATURE(ON|OFF)
#   DX_DOT_FEATURE(ON|OFF)
#   DX_HTML_FEATURE(ON|OFF)
#   DX_CHM_FEATURE(ON|OFF)
#   DX_CHI_FEATURE(ON|OFF)
#   DX_MAN_FEATURE(ON|OFF)
#   DX_RTF_FEATURE(ON|OFF)
#   DX_XML_FEATURE(ON|OFF)
#   DX_PDF_FEATURE(ON|OFF)
#   DX_PS_FEATURE(ON|OFF)
#
# DESCRIPTION
#
#   The DX_*_FEATURE macros control the default setting for the given
#   Doxygen feature. Supported features are 'DOXYGEN' itself, 'DOT' for
#   generating graphics, 'HTML' for plain HTML, 'CHM' for compressed HTML
#   help (for MS users), 'CHI' for generating a separate .chi file by the
#   .chm file, and 'MAN', 'RTF', 'XML', 'PDF' and 'PS' for the appropriate
#   output formats. The environment variable DOXYGEN_PAPER_SIZE may be
#   specified to override the default 'a4wide' paper size.
#
#   By default, HTML, PDF and PS documentation is generated as this seems to
#   be the most popular and portable combination. MAN pages created by
#   Doxygen are usually problematic, though by picking an appropriate subset
#   and doing some massaging they might be better than nothing. CHM and RTF
#   are specific for MS (note that you can't generate both HTML and CHM at
#   the same time). The XML is rather useless unless you apply specialized
#   post-processing to it.
#
#   The macros mainly control the default state of the feature. The use can
#   override the default by specifying --enable or --disable. The macros
#   ensure that contradictory flags are not given (e.g.,
#   --enable-doxygen-html and --enable-doxygen-chm,
#   --enable-doxygen-anything with --disable-doxygen, etc.) Finally, each
#   feature will be automatically disabled (with a warning) if the required
#   programs are missing.
#
#   Once all the feature defaults have been specified, call DX_INIT_DOXYGEN
#   with the following parameters: a one-word name for the project for use
#   as a filename base etc., an optional configuration file name (the
#   default is '$(srcdir)/Doxyfile', the same as Doxygen's default), and an
#   optional output directory name (the default is 'doxygen-doc'). To run
#   doxygen multiple times for different configuration files and output
#   directories provide more parameters: the second, forth, sixth, etc
#   parameter are configuration file names and the third, fifth, seventh,
#   etc parameter are output directories. No checking is done to catch
#   duplicates.
#
#   Automake Support
#
#   The DX_RULES substitution can be used to add all needed rules to the
#   Makefile. Note that this is a substitution without being a variable:
#   only the @DX_RULES@ syntax will work.
#
#   The provided targets are:
#
#     doxygen-doc: Generate all doxygen documentation.
#
#     doxygen-run: Run doxygen, which will generate some of the
#                  documentation (HTML, CHM, CHI, MAN, RTF, XML)
#                  but will not do the post processing required
#                  for the rest of it (PS, PDF).
#
#     doxygen-ps:  Generate doxygen PostScript documentation.
#
#     doxygen-pdf: Generate doxygen PDF documentation.
#
#   Note that by default these are not integrated into the automake targets.
#   If doxygen is used to generate man pages, you can achieve this
#   integration by setting man3_MANS to the list of man pages generated and
#   then adding the dependency:
#
#     $(man3_MANS): doxygen-doc
#
#   This will cause make to run doxygen and generate all the documentation.
#
#   The following variable is intended for use in Makefile.am:
#
#     DX_CLEANFILES = everything to clean.
#
#   Then add this variable to MOSTLYCLEANFILES.
#
# LICENSE
#
#   Copyright (c) 2009 Oren Ben-Kiki <oren@ben-kiki.org>
#   Copyright (c) 2015 Olaf Mandel <olaf@mandel.name>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved. This file is offered as-is, without any
#   warranty.

#serial 24


DX_ENV=""
AC_DEFUN([DX_FEATURE_doc],  ON)
AC_DEFUN([DX_FEATURE_dot],  OFF)
AC_DEFUN([DX_FEATURE_man],  OFF)
AC_DEFUN([DX_FEATURE_html], ON)
AC_DEFUN([DX_FEATURE_chm],  OFF)
AC_DEFUN([DX_FEATURE_chi],  OFF)
AC_DEFUN([DX_FEATURE_rtf],  OFF)
AC_DEFUN([DX_FEATURE_xml],  OFF)
AC_DEFUN([DX_FEATURE_pdf],  ON)
AC_DEFUN([DX_FEATURE_ps],   ON)


# DX_ENV_APPEND(VARIABLE, VALUE)
# ------------------------------
# Append VARIABLE="VALUE" to DX_ENV for invoking doxygen and add it
# as a substitution (but not a Makefile variable). The substitution
# is skipped if the variable name is VERSION.
AC_DEFUN([DX_ENV_APPEND],
[AC_SUBST([DX_ENV], ["$DX_ENV $1='$2'"])dnl
m4_if([$1], [VERSION], [], [AC_SUBST([$1], [$2])dnl
AM_SUBST_NOTMAKE([$1])])dnl
])

# DX_DIRNAME_EXPR
# ---------------
# Expand into a shell expression prints the directory part of a path.
AC_DEFUN([DX_DIRNAME_EXPR],
         [[expr ".$1" : '\(\.\)[^/]*$' \| "x$1" : 'x\(.*\)/[^/]*$']])

# DX_IF_FEATURE(FEATURE, IF-ON, IF-OFF)
# -------------------------------------
# Expands according to the M4 (static) status of the feature.
AC_DEFUN([DX_IF_FEATURE], [ifelse(DX_FEATURE_$1, ON, [$2], [$3])])

# DX_REQUIRE_PROG(VARIABLE, PROGRAM)
# ----------------------------------
# Require the specified program to be found for the DX_CURRENT_FEATURE to work.
AC_DEFUN([DX_REQUIRE_PROG], [
AC_PATH_TOOL([$1], [$2])
if test "$DX_FLAG_[]DX_CURRENT_FEATURE$$1" = 1; then
    AC_MSG_WARN([$2 not found - will not DX_CURRENT_DESCRIPTION])
    AC_SUBST(DX_FLAG_[]DX_CURRENT_FEATURE, 0)
fi
])

# DX_TEST_FEATURE(FEATURE)
# ------------------------
# Expand to a shell expression testing whether the feature is active.
AC_DEFUN([DX_TEST_FEATURE], [test "$DX_FLAG_$1" = 1])

# DX_CHECK_DEPEND(REQUIRED_FEATURE, REQUIRED_STATE)
# -------------------------------------------------
# Verify that a required features has the right state before trying to turn on
# the DX_CURRENT_FEATURE.
AC_DEFUN([DX_CHECK_DEPEND], [
test "$DX_FLAG_$1" = "$2" \
|| AC_MSG_ERROR([doxygen-DX_CURRENT_FEATURE ifelse([$2], 1,
                            requires, contradicts) doxygen-$1])
])

# DX_CLEAR_DEPEND(FEATURE, REQUIRED_FEATURE, REQUIRED_STATE)
# ----------------------------------------------------------
# Turn off the DX_CURRENT_FEATURE if the required feature is off.
AC_DEFUN([DX_CLEAR_DEPEND], [
test "$DX_FLAG_$1" = "$2" || AC_SUBST(DX_FLAG_[]DX_CURRENT_FEATURE, 0)
])

# DX_FEATURE_ARG(FEATURE, DESCRIPTION,
#                CHECK_DEPEND, CLEAR_DEPEND,
#                REQUIRE, DO-IF-ON, DO-IF-OFF)
# --------------------------------------------
# Parse the command-line option controlling a feature. CHECK_DEPEND is called
# if the user explicitly turns the feature on (and invokes DX_CHECK_DEPEND),
# otherwise CLEAR_DEPEND is called to turn off the default state if a required
# feature is disabled (using DX_CLEAR_DEPEND). REQUIRE performs additional
# requirement tests (DX_REQUIRE_PROG). Finally, an automake flag is set and
# DO-IF-ON or DO-IF-OFF are called according to the final state of the feature.
AC_DEFUN([DX_ARG_ABLE], [
    AC_DEFUN([DX_CURRENT_FEATURE], [$1])
    AC_DEFUN([DX_CURRENT_DESCRIPTION], [$2])
    AC_ARG_ENABLE(doxygen-$1,
                  [AS_HELP_STRING(DX_IF_FEATURE([$1], [--disable-doxygen-$1],
                                                      [--enable-doxygen-$1]),
                                  DX_IF_FEATURE([$1], [don't $2], [$2]))],
                  [
case "$enableval" in
#(
y|Y|yes|Yes|YES)
    AC_SUBST([DX_FLAG_$1], 1)
    $3
;; #(
n|N|no|No|NO)
    AC_SUBST([DX_FLAG_$1], 0)
;; #(
*)
    AC_MSG_ERROR([invalid value '$enableval' given to doxygen-$1])
;;
esac
], [
AC_SUBST([DX_FLAG_$1], [DX_IF_FEATURE([$1], 1, 0)])
$4
])
if DX_TEST_FEATURE([$1]); then
    $5
    :
fi
if DX_TEST_FEATURE([$1]); then
    $6
    :
else
    $7
    :
fi
])


# DX_XXX_FEATURE(DEFAULT_STATE)
# -----------------------------
AC_DEFUN([DX_DOXYGEN_FEATURE], [AC_DEFUN([DX_FEATURE_doc],  [$1])])
AC_DEFUN([DX_DOT_FEATURE],     [AC_DEFUN([DX_FEATURE_dot], [$1])])
AC_DEFUN([DX_MAN_FEATURE],     [AC_DEFUN([DX_FEATURE_man],  [$1])])
AC_DEFUN([DX_HTML_FEATURE],    [AC_DEFUN([DX_FEATURE_html], [$1])])
AC_DEFUN([DX_CHM_FEATURE],     [AC_DEFUN([DX_FEATURE_chm],  [$1])])
AC_DEFUN([DX_CHI_FEATURE],     [AC_DEFUN([DX_FEATURE_chi],  [$1])])
AC_DEFUN([DX_RTF_FEATURE],     [AC_DEFUN([DX_FEATURE_rtf],  [$1])])
AC_DEFUN([DX_XML_FEATURE],     [AC_DEFUN([DX_FEATURE_xml],  [$1])])
AC_DEFUN([DX_XML_FEATURE],     [AC_DEFUN([DX_FEATURE_xml],  [$1])])
AC_DEFUN([DX_PDF_FEATURE],     [AC_DEFUN([DX_FEATURE_pdf],  [$1])])
AC_DEFUN([DX_PS_FEATURE],      [AC_DEFUN([DX_FEATURE_ps],   [$1])])

# DX_INIT_DOXYGEN(PROJECT, [CONFIG-FILE], [OUTPUT-DOC-DIR], ...)
# --------------------------------------------------------------
# PROJECT also serves as the base name for the documentation files.
# The default CONFIG-FILE is "$(srcdir)/Doxyfile" and OUTPUT-DOC-DIR is
# "doxygen-doc".
# More arguments are interpreted as interleaved CONFIG-FILE and
# OUTPUT-DOC-DIR values.
AC_DEFUN([DX_INIT_DOXYGEN], [

# Files:
AC_SUBST([DX_PROJECT], [$1])
AC_SUBST([DX_CONFIG], ['ifelse([$2], [], [$(srcdir)/Doxyfile], [$2])'])
AC_SUBST([DX_DOCDIR], ['ifelse([$3], [], [doxygen-doc], [$3])'])
m4_if(m4_eval(3 < m4_count($@)), 1, [m4_for([DX_i], 4, m4_count($@), 2,
      [AC_SUBST([DX_CONFIG]m4_eval(DX_i[/2]),
                'm4_default_nblank_quoted(m4_argn(DX_i, $@),
                                          [$(srcdir)/Doxyfile])')])])dnl
m4_if(m4_eval(3 < m4_count($@)), 1, [m4_for([DX_i], 5, m4_count($@,), 2,
      [AC_SUBST([DX_DOCDIR]m4_eval([(]DX_i[-1)/2]),
                'm4_default_nblank_quoted(m4_argn(DX_i, $@),
                                          [doxygen-doc])')])])dnl
m4_define([DX_loop], m4_dquote(m4_if(m4_eval(3 < m4_count($@)), 1,
          [m4_for([DX_i], 4, m4_count($@), 2, [, m4_eval(DX_i[/2])])],
          [])))dnl

# Environment variables used inside doxygen.cfg:
DX_ENV_APPEND(SRCDIR, $srcdir)
DX_ENV_APPEND(PROJECT, $DX_PROJECT)
DX_ENV_APPEND(VERSION, $PACKAGE_VERSION)

# Doxygen itself:
DX_ARG_ABLE(doc, [generate any doxygen documentation],
            [],
            [],
            [DX_REQUIRE_PROG([DX_DOXYGEN], doxygen)
             DX_REQUIRE_PROG([DX_PERL], perl)],
            [DX_ENV_APPEND(PERL_PATH, $DX_PERL)])

# Dot for graphics:
DX_ARG_ABLE(dot, [generate graphics for doxygen documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [DX_REQUIRE_PROG([DX_DOT], dot)],
            [DX_ENV_APPEND(HAVE_DOT, YES)
             DX_ENV_APPEND(DOT_PATH, [`DX_DIRNAME_EXPR($DX_DOT)`])],
            [DX_ENV_APPEND(HAVE_DOT, NO)])

# Man pages generation:
DX_ARG_ABLE(man, [generate doxygen manual pages],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [],
            [DX_ENV_APPEND(GENERATE_MAN, YES)],
            [DX_ENV_APPEND(GENERATE_MAN, NO)])

# RTF file generation:
DX_ARG_ABLE(rtf, [generate doxygen RTF documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [],
            [DX_ENV_APPEND(GENERATE_RTF, YES)],
            [DX_ENV_APPEND(GENERATE_RTF, NO)])

# XML file generation:
DX_ARG_ABLE(xml, [generate doxygen XML documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [],
            [DX_ENV_APPEND(GENERATE_XML, YES)],
            [DX_ENV_APPEND(GENERATE_XML, NO)])

# (Compressed) HTML help generation:
DX_ARG_ABLE(chm, [generate doxygen compressed HTML help documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [DX_REQUIRE_PROG([DX_HHC], hhc)],
            [DX_ENV_APPEND(HHC_PATH, $DX_HHC)
             DX_ENV_APPEND(GENERATE_HTML, YES)
             DX_ENV_APPEND(GENERATE_HTMLHELP, YES)],
            [DX_ENV_APPEND(GENERATE_HTMLHELP, NO)])

# Separate CHI file generation.
DX_ARG_ABLE(chi, [generate doxygen separate compressed HTML help index file],
            [DX_CHECK_DEPEND(chm, 1)],
            [DX_CLEAR_DEPEND(chm, 1)],
            [],
            [DX_ENV_APPEND(GENERATE_CHI, YES)],
            [DX_ENV_APPEND(GENERATE_CHI, NO)])

# Plain HTML pages generation:
DX_ARG_ABLE(html, [generate doxygen plain HTML documentation],
            [DX_CHECK_DEPEND(doc, 1) DX_CHECK_DEPEND(chm, 0)],
            [DX_CLEAR_DEPEND(doc, 1) DX_CLEAR_DEPEND(chm, 0)],
            [],
            [DX_ENV_APPEND(GENERATE_HTML, YES)],
            [DX_TEST_FEATURE(chm) || DX_ENV_APPEND(GENERATE_HTML, NO)])

# PostScript file generation:
DX_ARG_ABLE(ps, [generate doxygen PostScript documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [DX_REQUIRE_PROG([DX_LATEX], latex)
             DX_REQUIRE_PROG([DX_MAKEINDEX], makeindex)
             DX_REQUIRE_PROG([DX_DVIPS], dvips)
             DX_REQUIRE_PROG([DX_EGREP], egrep)])

# PDF file generation:
DX_ARG_ABLE(pdf, [generate doxygen PDF documentation],
            [DX_CHECK_DEPEND(doc, 1)],
            [DX_CLEAR_DEPEND(doc, 1)],
            [DX_REQUIRE_PROG([DX_PDFLATEX], pdflatex)
             DX_REQUIRE_PROG([DX_MAKEINDEX], makeindex)
             DX_REQUIRE_PROG([DX_EGREP], egrep)])

# LaTeX generation for PS and/or PDF:
if DX_TEST_FEATURE(ps) || DX_TEST_FEATURE(pdf); then
    DX_ENV_APPEND(GENERATE_LATEX, YES)
else
    DX_ENV_APPEND(GENERATE_LATEX, NO)
fi

# Paper size for PS and/or PDF:
AC_ARG_VAR(DOXYGEN_PAPER_SIZE,
           [a4wide (default), a4, letter, legal or executive])
case "$DOXYGEN_PAPER_SIZE" in
#(
"")
    AC_SUBST(DOXYGEN_PAPER_SIZE, "")
;; #(
a4wide|a4|letter|legal|executive)
    DX_ENV_APPEND(PAPER_SIZE, $DOXYGEN_PAPER_SIZE)
;; #(
*)
    AC_MSG_ERROR([unknown DOXYGEN_PAPER_SIZE='$DOXYGEN_PAPER_SIZE'])
;;
esac

# Rules:
AS_IF([[test $DX_FLAG_html -eq 1]],
[[DX_SNIPPET_html="## ------------------------------- ##

DX_CLEAN_HTML = \$(DX_DOCDIR)/html]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
                \$(DX_DOCDIR]DX_i[)/html]])[

"]],
[[DX_SNIPPET_html=""]])
AS_IF([[test $DX_FLAG_chi -eq 1]],
[[DX_SNIPPET_chi="
DX_CLEAN_CHI = \$(DX_DOCDIR)/\$(PACKAGE).chi]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).chi]])["]],
[[DX_SNIPPET_chi=""]])
AS_IF([[test $DX_FLAG_chm -eq 1]],
[[DX_SNIPPET_chm="## ------------------------------ ##

DX_CLEAN_CHM = \$(DX_DOCDIR)/chm]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/chm]])[\
${DX_SNIPPET_chi}

"]],
[[DX_SNIPPET_chm=""]])
AS_IF([[test $DX_FLAG_man -eq 1]],
[[DX_SNIPPET_man="## ------------------------------ ##

DX_CLEAN_MAN = \$(DX_DOCDIR)/man]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/man]])[

"]],
[[DX_SNIPPET_man=""]])
AS_IF([[test $DX_FLAG_rtf -eq 1]],
[[DX_SNIPPET_rtf="## ------------------------------ ##

DX_CLEAN_RTF = \$(DX_DOCDIR)/rtf]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/rtf]])[

"]],
[[DX_SNIPPET_rtf=""]])
AS_IF([[test $DX_FLAG_xml -eq 1]],
[[DX_SNIPPET_xml="## ------------------------------ ##

DX_CLEAN_XML = \$(DX_DOCDIR)/xml]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/xml]])[

"]],
[[DX_SNIPPET_xml=""]])
AS_IF([[test $DX_FLAG_ps -eq 1]],
[[DX_SNIPPET_ps="## ----------------------------- ##

DX_CLEAN_PS = \$(DX_DOCDIR)/\$(PACKAGE).ps]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
              \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).ps]])[

DX_PS_GOAL = doxygen-ps

doxygen-ps: \$(DX_CLEAN_PS)

]m4_foreach([DX_i], [DX_loop],
[[\$(DX_DOCDIR]DX_i[)/\$(PACKAGE).ps: \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).tag
	\$(DX_V_LATEX)cd \$(DX_DOCDIR]DX_i[)/latex; \\
	rm -f *.aux *.toc *.idx *.ind *.ilg *.log *.out; \\
	\$(DX_LATEX) refman.tex; \\
	\$(DX_MAKEINDEX) refman.idx; \\
	\$(DX_LATEX) refman.tex; \\
	countdown=5; \\
	while \$(DX_EGREP) 'Rerun (LaTeX|to get cross-references right)' \\
	                  refman.log > /dev/null 2>&1 \\
	   && test \$\$countdown -gt 0; do \\
	    \$(DX_LATEX) refman.tex; \\
            countdown=\`expr \$\$countdown - 1\`; \\
	done; \\
	\$(DX_DVIPS) -o ../\$(PACKAGE).ps refman.dvi

]])["]],
[[DX_SNIPPET_ps=""]])
AS_IF([[test $DX_FLAG_pdf -eq 1]],
[[DX_SNIPPET_pdf="## ------------------------------ ##

DX_CLEAN_PDF = \$(DX_DOCDIR)/\$(PACKAGE).pdf]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
               \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).pdf]])[

DX_PDF_GOAL = doxygen-pdf

doxygen-pdf: \$(DX_CLEAN_PDF)

]m4_foreach([DX_i], [DX_loop],
[[\$(DX_DOCDIR]DX_i[)/\$(PACKAGE).pdf: \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).tag
	\$(DX_V_LATEX)cd \$(DX_DOCDIR]DX_i[)/latex; \\
	rm -f *.aux *.toc *.idx *.ind *.ilg *.log *.out; \\
	\$(DX_PDFLATEX) refman.tex; \\
	\$(DX_MAKEINDEX) refman.idx; \\
	\$(DX_PDFLATEX) refman.tex; \\
	countdown=5; \\
	while \$(DX_EGREP) 'Rerun (LaTeX|to get cross-references right)' \\
	                  refman.log > /dev/null 2>&1 \\
	   && test \$\$countdown -gt 0; do \\
	    \$(DX_PDFLATEX) refman.tex; \\
	    countdown=\`expr \$\$countdown - 1\`; \\
	done; \\
	mv refman.pdf ../\$(PACKAGE).pdf

]])["]],
[[DX_SNIPPET_pdf=""]])
AS_IF([[test $DX_FLAG_ps -eq 1 -o $DX_FLAG_pdf -eq 1]],
[[DX_SNIPPET_latex="## ------------------------------------------------- ##

DX_V_LATEX = \$(_DX_v_LATEX_\$(V))
_DX_v_LATEX_ = \$(_DX_v_LATEX_\$(AM_DEFAULT_VERBOSITY))
_DX_v_LATEX_0 = @echo \"  LATEX \" \$][@;

DX_CLEAN_LATEX = \$(DX_DOCDIR)/latex]dnl
m4_foreach([DX_i], [m4_shift(DX_loop)], [[\\
                 \$(DX_DOCDIR]DX_i[)/latex]])[

"]],
[[DX_SNIPPET_latex=""]])

AS_IF([[test $DX_FLAG_doc -eq 1]],
[[DX_SNIPPET_doc="## --------------------------------- ##

${DX_SNIPPET_html}\
${DX_SNIPPET_chm}\
${DX_SNIPPET_man}\
${DX_SNIPPET_rtf}\
${DX_SNIPPET_xml}\
${DX_SNIPPET_ps}\
${DX_SNIPPET_pdf}\
${DX_SNIPPET_latex}\
DX_V_DXGEN = \$(_DX_v_DXGEN_\$(V))
_DX_v_DXGEN_ = \$(_DX_v_DXGEN_\$(AM_DEFAULT_VERBOSITY))
_DX_v_DXGEN_0 = @echo \"  DXGEN \" \$<;

.PHONY: doxygen-run doxygen-doc \$(DX_PS_GOAL) \$(DX_PDF_GOAL)

.INTERMEDIATE: doxygen-run \$(DX_PS_GOAL) \$(DX_PDF_GOAL)

doxygen-run:]m4_foreach([DX_i], [DX_loop],
                         [[ \$(DX_DOCDIR]DX_i[)/\$(PACKAGE).tag]])[

doxygen-doc: doxygen-run \$(DX_PS_GOAL) \$(DX_PDF_GOAL)

]m4_foreach([DX_i], [DX_loop],
[[\$(DX_DOCDIR]DX_i[)/\$(PACKAGE).tag: \$(DX_CONFIG]DX_i[) \$(pkginclude_HEADERS)
	\$(A""M_V_at)rm -rf \$(DX_DOCDIR]DX_i[)
	\$(DX_V_DXGEN)\$(DX_ENV) DOCDIR=\$(DX_DOCDIR]DX_i[) \$(DX_DOXYGEN) \$(DX_CONFIG]DX_i[)
	\$(A""M_V_at)echo Timestamp >\$][@

]])dnl
[DX_CLEANFILES = \\]
m4_foreach([DX_i], [DX_loop],
[[	\$(DX_DOCDIR]DX_i[)/doxygen_sqlite3.db \\
	\$(DX_DOCDIR]DX_i[)/\$(PACKAGE).tag \\
]])dnl
[	-r \\
	\$(DX_CLEAN_HTML) \\
	\$(DX_CLEAN_CHM) \\
	\$(DX_CLEAN_CHI) \\
	\$(DX_CLEAN_MAN) \\
	\$(DX_CLEAN_RTF) \\
	\$(DX_CLEAN_XML) \\
	\$(DX_CLEAN_PS) \\
	\$(DX_CLEAN_PDF) \\
	\$(DX_CLEAN_LATEX)"]],
[[DX_SNIPPET_doc=""]])
AC_SUBST([DX_RULES],
["${DX_SNIPPET_doc}"])dnl
AM_SUBST_NOTMAKE([DX_RULES])

#For debugging:
#echo DX_FLAG_doc=$DX_FLAG_doc
#echo DX_FLAG_dot=$DX_FLAG_dot
#echo DX_FLAG_man=$DX_FLAG_man
#echo DX_FLAG_html=$DX_FLAG_html
#echo DX_FLAG_chm=$DX_FLAG_chm
#echo DX_FLAG_chi=$DX_FLAG_chi
#echo DX_FLAG_rtf=$DX_FLAG_rtf
#echo DX_FLAG_xml=$DX_FLAG_xml
#echo DX_FLAG_pdf=$DX_FLAG_pdf
#echo DX_FLAG_ps=$DX_FLAG_ps
#echo DX_ENV=$DX_ENV
])

# pkg.m4 - Macros to locate and utilise pkg-config.   -*- Autoconf -*-
# serial 12 (pkg-config-0.29.2)

dnl Copyright © 2004 Scott James Remnant <scott@netsplit.com>.
dnl Copyright © 2012-2015 Dan Nicholson <dbn.lists@gmail.com>
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
dnl General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
dnl 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a
dnl configuration script generated by Autoconf, you may include it under
dnl the same distribution terms that you use for the rest of that
dnl program.

dnl PKG_PREREQ(MIN-VERSION)
dnl -----------------------
dnl Since: 0.29
dnl
dnl Verify that the version of the pkg-config macros are at least
dnl MIN-VERSION. Unlike PKG_PROG_PKG_CONFIG, which checks the user's
dnl installed version of pkg-config, this checks the developer's version
dnl of pkg.m4 when generating configure.
dnl
dnl To ensure that this macro is defined, also add:
dnl m4_ifndef([PKG_PREREQ],
dnl     [m4_fatal([must install pkg-config 0.29 or later before running autoconf/autogen])])
dnl
dnl See the "Since" comment for each macro you use to see what version
dnl of the macros you require.
m4_defun([PKG_PREREQ],
[m4_define([PKG_MACROS_VERSION], [0.29.2])
m4_if(m4_version_compare(PKG_MACROS_VERSION, [$1]), -1,
    [m4_fatal([pkg.m4 version $1 or higher is required but ]PKG_MACROS_VERSION[ found])])
])dnl PKG_PREREQ

dnl PKG_PROG_PKG_CONFIG([MIN-VERSION])
dnl ----------------------------------
dnl Since: 0.16
dnl
dnl Search for the pkg-config tool and set the PKG_CONFIG variable to
dnl first found in the path. Checks that the version of pkg-config found
dnl is at least MIN-VERSION. If MIN-VERSION is not specified, 0.9.0 is
dnl used since that's the first version where most current features of
dnl pkg-config existed.
AC_DEFUN([PKG_PROG_PKG_CONFIG],
[m4_pattern_forbid([^_?PKG_[A-Z_]+$])
m4_pattern_allow([^PKG_CONFIG(_(PATH|LIBDIR|SYSROOT_DIR|ALLOW_SYSTEM_(CFLAGS|LIBS)))?$])
m4_pattern_allow([^PKG_CONFIG_(DISABLE_UNINSTALLED|TOP_BUILD_DIR|DEBUG_SPEW)$])
AC_ARG_VAR([PKG_CONFIG], [path to pkg-config utility])
AC_ARG_VAR([PKG_CONFIG_PATH], [directories to add to pkg-config's search path])
AC_ARG_VAR([PKG_CONFIG_LIBDIR], [path overriding pkg-config's built-in search path])

if test "x$ac_cv_env_PKG_CONFIG_set" != "xset"; then
	AC_PATH_TOOL([PKG_CONFIG], [pkg-config])
fi
if test -n "$PKG_CONFIG"; then
	_pkg_min_version=m4_default([$1], [0.9.0])
	AC_MSG_CHECKING([pkg-config is at least version $_pkg_min_version])
	if $PKG_CONFIG --atleast-pkgconfig-version $_pkg_min_version; then
		AC_MSG_RESULT([yes])
	else
		AC_MSG_RESULT([no])
		PKG_CONFIG=""
	fi
fi[]dnl
])dnl PKG_PROG_PKG_CONFIG

dnl PKG_CHECK_EXISTS(MODULES, [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl -------------------------------------------------------------------
dnl Since: 0.18
dnl
dnl Check to see whether a particular set of modules exists. Similar to
dnl PKG_CHECK_MODULES(), but does not set variables or print errors.
dnl
dnl Please remember that m4 expands AC_REQUIRE([PKG_PROG_PKG_CONFIG])
dnl only at the first occurence in configure.ac, so if the first place
dnl it's called might be skipped (such as if it is within an "if", you
dnl have to call PKG_CHECK_EXISTS manually
AC_DEFUN([PKG_CHECK_EXISTS],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
if test -n "$PKG_CONFIG" && \
    AC_RUN_LOG([$PKG_CONFIG --exists --print-errors "$1"]); then
  m4_default([$2], [:])
m4_ifvaln([$3], [else
  $3])dnl
fi])

dnl _PKG_CONFIG([VARIABLE], [COMMAND], [MODULES])
dnl ---------------------------------------------
dnl Internal wrapper calling pkg-config via PKG_CONFIG and setting
dnl pkg_failed based on the result.
m4_define([_PKG_CONFIG],
[if test -n "$$1"; then
    pkg_cv_[]$1="$$1"
 elif test -n "$PKG_CONFIG"; then
    PKG_CHECK_EXISTS([$3],
                     [pkg_cv_[]$1=`$PKG_CONFIG --[]$2 "$3" 2>/dev/null`
		      test "x$?" != "x0" && pkg_failed=yes ],
		     [pkg_failed=yes])
 else
    pkg_failed=untried
fi[]dnl
])dnl _PKG_CONFIG

dnl _PKG_SHORT_ERRORS_SUPPORTED
dnl ---------------------------
dnl Internal check to see if pkg-config supports short errors.
AC_DEFUN([_PKG_SHORT_ERRORS_SUPPORTED],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])
if $PKG_CONFIG --atleast-pkgconfig-version 0.20; then
        _pkg_short_errors_supported=yes
else
        _pkg_short_errors_supported=no
fi[]dnl
])dnl _PKG_SHORT_ERRORS_SUPPORTED


dnl PKG_CHECK_MODULES(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND],
dnl   [ACTION-IF-NOT-FOUND])
dnl --------------------------------------------------------------
dnl Since: 0.4.0
dnl
dnl Note that if there is a possibility the first call to
dnl PKG_CHECK_MODULES might not happen, you should be sure to include an
dnl explicit call to PKG_PROG_PKG_CONFIG in your configure.ac
AC_DEFUN([PKG_CHECK_MODULES],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
AC_ARG_VAR([$1][_CFLAGS], [C compiler flags for $1, overriding pkg-config])dnl
AC_ARG_VAR([$1][_LIBS], [linker flags for $1, overriding pkg-config])dnl

pkg_failed=no
AC_MSG_CHECKING([for $2])

_PKG_CONFIG([$1][_CFLAGS], [cflags], [$2])
_PKG_CONFIG([$1][_LIBS], [libs], [$2])

m4_define([_PKG_TEXT], [Alternatively, you may set the environment variables $1[]_CFLAGS
and $1[]_LIBS to avoid the need to call pkg-config.
See the pkg-config man page for more details.])

if test $pkg_failed = yes; then
        AC_MSG_RESULT([no])
        _PKG_SHORT_ERRORS_SUPPORTED
        if test $_pkg_short_errors_supported = yes; then
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --short-errors --print-errors --cflags --libs "$2" 2>&1`
        else
	        $1[]_PKG_ERRORS=`$PKG_CONFIG --print-errors --cflags --libs "$2" 2>&1`
        fi
	# Put the nasty error message in config.log where it belongs
	echo "$$1[]_PKG_ERRORS" >&AS_MESSAGE_LOG_FD

	m4_default([$4], [AC_MSG_ERROR(
[Package requirements ($2) were not met:

$$1_PKG_ERRORS

Consider adjusting the PKG_CONFIG_PATH environment variable if you
installed software in a non-standard prefix.

_PKG_TEXT])[]dnl
        ])
elif test $pkg_failed = untried; then
        AC_MSG_RESULT([no])
	m4_default([$4], [AC_MSG_FAILURE(
[The pkg-config script could not be found or is too old.  Make sure it
is in your PATH or set the PKG_CONFIG environment variable to the full
path to pkg-config.

_PKG_TEXT

To get pkg-config, see <http://pkg-config.freedesktop.org/>.])[]dnl
        ])
else
	$1[]_CFLAGS=$pkg_cv_[]$1[]_CFLAGS
	$1[]_LIBS=$pkg_cv_[]$1[]_LIBS
        AC_MSG_RESULT([yes])
	$3
fi[]dnl
])dnl PKG_CHECK_MODULES


dnl PKG_CHECK_MODULES_STATIC(VARIABLE-PREFIX, MODULES, [ACTION-IF-FOUND],
dnl   [ACTION-IF-NOT-FOUND])
dnl ---------------------------------------------------------------------
dnl Since: 0.29
dnl
dnl Checks for existence of MODULES and gathers its build flags with
dnl static libraries enabled. Sets VARIABLE-PREFIX_CFLAGS from --cflags
dnl and VARIABLE-PREFIX_LIBS from --libs.
dnl
dnl Note that if there is a possibility the first call to
dnl PKG_CHECK_MODULES_STATIC might not happen, you should be sure to
dnl include an explicit call to PKG_PROG_PKG_CONFIG in your
dnl configure.ac.
AC_DEFUN([PKG_CHECK_MODULES_STATIC],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
_save_PKG_CONFIG=$PKG_CONFIG
PKG_CONFIG="$PKG_CONFIG --static"
PKG_CHECK_MODULES($@)
PKG_CONFIG=$_save_PKG_CONFIG[]dnl
])dnl PKG_CHECK_MODULES_STATIC


dnl PKG_INSTALLDIR([DIRECTORY])
dnl -------------------------
dnl Since: 0.27
dnl
dnl Substitutes the variable pkgconfigdir as the location where a module
dnl should install pkg-config .pc files. By default the directory is
dnl $libdir/pkgconfig, but the default can be changed by passing
dnl DIRECTORY. The user can override through the --with-pkgconfigdir
dnl parameter.
AC_DEFUN([PKG_INSTALLDIR],
[m4_pushdef([pkg_default], [m4_default([$1], ['${libdir}/pkgconfig'])])
m4_pushdef([pkg_description],
    [pkg-config installation directory @<:@]pkg_default[@:>@])
AC_ARG_WITH([pkgconfigdir],
    [AS_HELP_STRING([--with-pkgconfigdir], pkg_description)],,
    [with_pkgconfigdir=]pkg_default)
AC_SUBST([pkgconfigdir], [$with_pkgconfigdir])
m4_popdef([pkg_default])
m4_popdef([pkg_description])
])dnl PKG_INSTALLDIR


dnl PKG_NOARCH_INSTALLDIR([DIRECTORY])
dnl --------------------------------
dnl Since: 0.27
dnl
dnl Substitutes the variable noarch_pkgconfigdir as the location where a
dnl module should install arch-independent pkg-config .pc files. By
dnl default the directory is $datadir/pkgconfig, but the default can be
dnl changed by passing DIRECTORY. The user can override through the
dnl --with-noarch-pkgconfigdir parameter.
AC_DEFUN([PKG_NOARCH_INSTALLDIR],
[m4_pushdef([pkg_default], [m4_default([$1], ['${datadir}/pkgconfig'])])
m4_pushdef([pkg_description],
    [pkg-config arch-independent installation directory @<:@]pkg_default[@:>@])
AC_ARG_WITH([noarch-pkgconfigdir],
    [AS_HELP_STRING([--with-noarch-pkgconfigdir], pkg_description)],,
    [with_noarch_pkgconfigdir=]pkg_default)
AC_SUBST([noarch_pkgconfigdir], [$with_noarch_pkgconfigdir])
m4_popdef([pkg_default])
m4_popdef([pkg_description])
])dnl PKG_NOARCH_INSTALLDIR


dnl PKG_CHECK_VAR(VARIABLE, MODULE, CONFIG-VARIABLE,
dnl [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl -------------------------------------------
dnl Since: 0.28
dnl
dnl Retrieves the value of the pkg-config variable for the given module.
AC_DEFUN([PKG_CHECK_VAR],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
AC_ARG_VAR([$1], [value of $3 for $2, overriding pkg-config])dnl

_PKG_CONFIG([$1], [variable="][$3]["], [$2])
AS_VAR_COPY([$1], [pkg_cv_][$1])

AS_VAR_IF([$1], [""], [$5], [$4])dnl
])dnl PKG_CHECK_VAR

# AM_COND_IF                                            -*- Autoconf -*-

# Copyright (C) 2008-2025 Free Software Foundation, Inc.
#
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# _AM_COND_IF
# _AM_COND_ELSE
# _AM_COND_ENDIF
# --------------
# These macros are only used for tracing.
m4_define([_AM_COND_IF])
m4_define([_AM_COND_ELSE])
m4_define([_AM_COND_ENDIF])

# AM_COND_IF(COND, [IF-TRUE], [IF-FALSE])
# ---------------------------------------
# If the shell condition COND is true, execute IF-TRUE, otherwise execute
# IF-FALSE.  Allow automake to learn about conditional instantiating macros
# (the AC_CONFIG_FOOS).
AC_DEFUN([AM_COND_IF],
[m4_ifndef([_AM_COND_VALUE_$1],
	   [m4_fatal([$0: no such condition "$1"])])dnl
_AM_COND_IF([$1])dnl
if test -z "$$1_TRUE"; then :
  m4_n([$2])[]dnl
m4_ifval([$3],
[_AM_COND_ELSE([$1])dnl
else
  $3
])dnl
_AM_COND_ENDIF([$1])dnl
fi[]dnl
])

# AM_CONDITIONAL                                            -*- Autoconf -*-

# Copyright (C) 1997-2025 Free Software Foundation, Inc.
#
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# AM_CONDITIONAL(NAME, SHELL-CONDITION)
# -------------------------------------
# Define a conditional.
AC_DEFUN([AM_CONDITIONAL],
[AC_PREREQ([2.52])dnl
 m4_if([$1], [TRUE],  [AC_FATAL([$0: invalid condition: $1])],
       [$1], [FALSE], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_SUBST([$1_TRUE])dnl
AC_SUBST([$1_FALSE])dnl
_AM_SUBST_NOTMAKE([$1_TRUE])dnl
_AM_SUBST_NOTMAKE([$1_FALSE])dnl
m4_define([_AM_COND_VALUE_$1], [$2])dnl
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi
AC_CONFIG_COMMANDS_PRE(
[if test -z "${$1_TRUE}" && test -z "${$1_FALSE}"; then
  AC_MSG_ERROR([[conditional "$1" was never defined.
Usually this means the macro was only invoked conditionally.]])
fi])])

# Copyright (C) 2006-2025 Free Software Foundation, Inc.
#
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# _AM_SUBST_NOTMAKE(VARIABLE)
# ---------------------------
# Prevent Automake from outputting VARIABLE = @VARIABLE@ in Makefile.in.
# This macro is traced by Automake.
AC_DEFUN([_AM_SUBST_NOTMAKE])

# AM_SUBST_NOTMAKE(VARIABLE)
# --------------------------
# Public sister of _AM_SUBST_NOTMAKE.
AC_DEFUN([AM_SUBST_NOTMAKE], [_AM_SUBST_NOTMAKE($@)])

# ===========================================================================
#          http://autoconf-archive.cryp.to/ac_prog_perl_modules.html
# ===========================================================================
#
# SYNOPSIS
#
#   AC_PROG_PERL_MODULES([MODULES], [ACTION-IF-TRUE], [ACTION-IF-FALSE])
#
# DESCRIPTION
#
#   Checks to see if the given perl modules are available. If true the shell
#   commands in ACTION-IF-TRUE are executed. If not the shell commands in
#   ACTION-IF-FALSE are run. Note if $PERL is not set (for example by
#   calling AC_CHECK_PROG, or AC_PATH_PROG), AC_CHECK_PROG(PERL, perl, perl)
#   will be run.
#
#   MODULES is a space separated list of module names. To check for a
#   minimum version of a module, append the version number to the
#   module name, separated by an equals sign.
#
#   Example:
#
#     AC_PROG_PERL_MODULES( Text::Wrap Net::LDAP=1.0.3, ,
#                           AC_MSG_WARN(Need some Perl modules)
#
# LICENSE
#
#   Copyright (c) 2009 Dean Povey <povey@wedgetail.com>
#
#   Copying and distribution of this file, with or without modification, are
#   permitted in any medium without royalty provided the copyright notice
#   and this notice are preserved.
#
# serial 1

AC_DEFUN([AC_PROG_PERL_MODULES],[dnl

m4_define([ac_perl_modules])
m4_foreach([ac_perl_module], m4_split(m4_normalize([$1])),
	  [
	   m4_append([ac_perl_modules],
		     [']m4_bpatsubst(ac_perl_module,=,[ ])[' ])
          ])

# Make sure we have perl
if test -z "$PERL"; then
AC_CHECK_PROG(PERL,perl,perl)
fi

if test "x$PERL" != x; then
  ac_perl_modules_failed=0
  for ac_perl_module in ac_perl_modules; do
    AC_MSG_CHECKING(for perl module $ac_perl_module)

    # Would be nice to log result here, but can't rely on autoconf internals
    $PERL -e "use $ac_perl_module; exit" > /dev/null 2>&1
    if test $? -ne 0; then
      AC_MSG_RESULT(no);
      ac_perl_modules_failed=1
   else
      AC_MSG_RESULT(ok);
    fi
  done

  # Run optional shell commands
  if test "$ac_perl_modules_failed" = 0; then
    :
    $2
  else
    :
    $3
  fi
else
  AC_MSG_WARN(could not find perl)
fi])dnl

# serial 1

# MST_AM_INIT
#------------
# Various automake related initializations which aren't done by
# default.
#
AC_DEFUN([MST_AM_INIT],
[
  # make program_prefix available for interpolation as mst_program_prefix
  mst_program_prefix="$program_prefix"
  test "$mst_program_prefix" = NONE && mst_program_prefix=""
  AC_SUBST(mst_program_prefix)
])# MST_AM_INIT



# MST_AM_OVERRIDE_VAR
#---------------------
#
#  SYNOPSIS
#
#    MST_AM_OVERRIDE_VAR([varname1 varname ... ])
#
#    [ ... other commands which may initialize varname ... ]
#
#    MST_AM_OVERRIDE_FINALIZE
#
#  DESCRIPTION
#
#    This autoconf macro generalizes the approach given in
#
#    http://lists.gnu.org/archive/html/automake/2005-09/msg00108.html
#
#    which moves user specified values for variable 'varname' given at
#    configure time into the corresponding AM_${varname} variable and
#    clears out 'varname', allowing further manipulation by the
#    configure script so that target specific variables can be given
#    specialized versions.  'varname may still be specified on the
#    make command line and will be appended as usual.
#
#    As an example usage, consider a project which might benefit from
#    different compiler flags for different components. Typically this
#    is done via target specific flags, e.g.
#
#       libgtest_la_CXXFLAGS    =                        \
#                        -I $(top_srcdir)/tests          \
#                        -I $(top_builddir)/tests        \
#                        $(GTEST_CXXFLAGS)
#
#    automake will automatically append $(CXXFLAGS) -- provided by the
#    user -- to the build rule for libgtest_la.  That might be problematic,
#    as CXXFLAGS may contain compiler options which are inappropriate for
#    libgtest_la.
#
#    The approach laid out in the referenced mailing list message is
#    to supply a base value for a variable during _configure_ time,
#    during which it is possible to amend it for specific targets.
#    The user may subsequently specify a value for the variable during
#    _build_ time, which make will apply (via the standard automake
#    rules) to all appropriate targets.
#
#    For example,
#
#      MST_AM_OVERRIDE_VAR([CXXFLAGS])
#
#    will store the value of CXXFLAGS specified at configure time into
#    the AM_CXXFLAGS variable, AC_SUBST it, and clear CXXFLAGS.
#    configure may then create a target specific set of flags based
#    upon AM_CXXFLAGS, e.g.
#
#       # googletest uses variadic macros, which g++ -pedantic-errors
#       # is very unhappy about
#       AC_SUBST([GTEST_CXXFLAGS],
#	   [`AS_ECHO_N(["$AM_CXXFLAGS"]) \
#	         | sed s/-pedantic-errors/-pedantic/`
#           ]
#        )
#
#    which would be used in a Makefile.am as above.  Since CXXFLAGS is
#    cleared, the configure time value will not affect the build for
#    libgtest_la.
#
#
#  USAGE
#
#    Prior to _any other command_ which may set ${varname}, call
#
#      MST_AM_OVERRIDE_VAR([varname])
#
#    This will preserve the value (if any) passed to configure in
#    AM_${varname} and AC_SUBST([AM_${varname}).  You may pass a space
#    separated list of variable names, or may call MST_AM_OVERRIDE_VAR
#    multiple times for the same effect.
#
#    If any subsequent configure commands set ${varname} and you wish to
#    capture the resultant value into AM_${varname} in the case where
#    ${varname} was _not_ provided at configure time,  call
#
#      MST_AM_OVERRIDE_FINALIZE
#
#    after _all_ commands which might affect any of the variables
#    specified in calls to MST_AM_OVERRIDE_VAR.  This need be done
#    only once, but repeated calls will not cause harm.
#
#    There is a bit of trickery required to allow further manipulation
#    of the AM_${varname} in a Makefile.am file.  If AM_CFLAGS is used
#    as is in a Makefile.am, e.g.
#
#      libfoo_la_CFLAGS = $(AM_CFLAGS)
#
#    then automake will emit code in Makefile.in which sets AM_CFLAGS from
#    the configure'd value.
#
#    If however, AM_CFLAGS is manipulated (i.e. appended to), you
#    will have to explicitly arrange for the configure'd value to be
#    substituted:
#
#      AM_CFLAGS = @AM_CFLAGS@
#      AM_CFLAGS += -lfoo
#
#    or else automake will complain about using += before =
#
#
#  AUTHOR
#
#  Diab Jerius <djerius@cfa.harvard.edu>
#
#  LICENSE
#
#  Copyright (c) 2013 Smithsonian Astrophysical Observatory
#
#  Copying and distribution of this file, with or without
#  modification, are permitted in any medium without royalty provided
#  the copyright notice and this notice are preserved.  This file is
#  offered as-is, without any warranty.
#
# serial 1


AC_DEFUN([_MST_AM_OVERRIDE_INITIALIZE],
[
	m4_define([_mst_am_override_vars],[])
])


# _MST_AM_OVERRIDE_VAR(varname)
AC_DEFUN([_MST_AM_OVERRIDE_VAR],
[
  m4_define([_mst_am_override_vars], m4_defn([_mst_am_override_vars]) $1 )
  _mst_am_override_$1_set=false

  AS_IF( [test "${$1+set}" = set],
         [AC_SUBST([AM_$1],["$$1"])
	  $1=
	  _mst_am_override_$1_set=:
         ]
  )
]) # _MST_AM_OVERRIDE_VAR

# _MST_AM_OVERRIDE_FINALIZE(varname)
AC_DEFUN([_MST_AM_OVERRIDE_FINALIZE],
[
  AS_IF([$_mst_am_override_$1_set = :],
        [],
	[AC_SUBST([AM_$1],["$$1"])
	 $1=
	 _mst_am_override_$1_set=
        ]
  )
  AC_SUBST($1)
]) # _MST_AM_OVERRIDE_FINALIZE

AC_DEFUN([MST_AM_OVERRIDE_VAR],
[
  AC_REQUIRE([_MST_AM_OVERRIDE_INITIALIZE])
  m4_map_args_w([$1],[_MST_AM_OVERRIDE_VAR(],[)])
])# MST_OVERRIDE_VAR


# MST_AM_OVERRIDE_FINALIZE
AC_DEFUN([MST_AM_OVERRIDE_FINALIZE],
[
  AC_REQUIRE([_MST_AM_OVERRIDE_INITIALIZE])
  m4_map_args_w(_mst_am_override_vars,[_MST_AM_OVERRIDE_FINALIZE(],[)])
]) # MST_AM_OVERRIDE_FINALIZE

# unpack bats source
# serial 3

# MST_BATS
#----------
AC_DEFUN([MST_BATS],
[
AC_SUBST([MST_BATS_M4])
AC_ARG_WITH( [bats],
             [AS_HELP_STRING([--with-bats=ARG],
                             [ARG is path to bats archive @<:@default=use bundled version@:>@])],
             [],[with_bats=no]
           )
AC_CACHE_CHECK([for BATS],[mst_cv_prog_bats],
[
  AS_IF( [test "$with_bats" = ""],
          [AC_MSG_ERROR([--with-bats requires an argument])],
	 [ test "$with_bats" = no],
	 [ AC_CHECK_FILE([$srcdir/tests/bats/bin/bats],
		    [mst_cv_prog_bats=$srcdir/tests/bats/bin/bats],
		    [AC_CHECK_FILE([tests/bats/bin/bats],
				   [mst_cv_prog_bats=tests/bats/bin/bats],
				   [AC_MSG_ERROR([bats is not bundled; please specify it with --with-bats (see https://github.com/sstephenson/bats/releases)])]
				   )
		    ]
           )
           AS_EXECUTABLE_P([$mst_cv_prog_bats]),
           AC_MSG_NOTICE([using bundled bats])
         ],
         [
	   AC_MSG_NOTICE([trying bats distribution $with_bats])
	   AC_CHECK_FILE([$with_bats],
			 [],
			 [AC_MSG_ERROR(cannot find $with_bats)]
			)

	   AS_CASE( [$with_bats],
		   [*.tar.gz],
		   [
		       AC_PATH_PROG([TAR],[tar],[no])
		       test "$TAR" = no && \
			   AC_MSG_ERROR([tar not found; unable to extract bats])
		       AC_MSG_NOTICE([unpacking $with_bats])
		       AS_MKDIR_P([tests/bats])

		       # extract just the bits of bats we need.  GNU vs BSD
		       # tar are different enough that it's easier to extract
		       # everything and copy things over.  For history: GNU
		       # tar doesn't have --include, doesn't like it if
		       # directories are specified before their contents
		       (
			 set -e
			 AS_TMPDIR([mst_bats_])
			 trap "rm -rf $tmp" EXIT

			 $TAR -C $tmp --strip-components 1 -xf $with_bats

			 cp -a \
			    $tmp/LICENSE \
			    $tmp/README.md \
			    $tmp/bin \
			    $tmp/libexec \
			    tests/bats
		       )

		       test $? -ne 0 && AC_MSG_ERROR([error extracting bats])
		       mst_cv_prog_bats=tests/bats/bin/bats
		   ],
		   [
		       AC_MSG_ERROR([do not know how to unpack bats archive $with_bats])
		   ]
	   )
        ]
  )
])
AC_SUBST([BATS],[$mst_cv_prog_bats])
])


# serial 1

# MST_CHECK
#----------
# Check dependencies, recording failure status and report
# failure for all checks at end of list so that user
# sees them all
# 1. MST_CHECK_SETUP
# 2. MST_CHECK_XXX as needed
# 3. MST_CHECK_STATUS to report on the final status of the test
#    and die if necessary

# MST_CHECK_SETUP
#------------------
# Perform setup steps for dependencies.
AC_DEFUN([MST_CHECK_SETUP],
[
 MST_CHECKS_OK=
])# MST_CHECK_SETUP


# MST_CHECK_TEST(command, message)
#-----------------------------------
# Run the command.  If it returns false, report that the dependency
# has failed and update the global dependency state.
AC_DEFUN([MST_CHECK_TEST],
[AC_REQUIRE([MST_CHECK_SETUP])
 mst_check_test=
 AS_IF([$1],[mst_check_test=yes],[mst_check_test=no])
 MST_CHECK_FLAG([$mst_check_test],
                ,
		[AC_MSG_WARN([$2: Missing dependency])]
		)
])# MST_CHECK_TEST

# MST_CHECK_FLAG(result,[ACTION-IF-TRUE],[ACTION-IF-FALSE])
#------------------------------------------------------------
# update the status flag based upon a test result
AC_DEFUN([MST_CHECK_FLAG],
[AC_REQUIRE([MST_CHECK_SETUP])

 AS_IF( [test "x$1" = "xno"],
        [ MST_CHECKS_OK=no
	  $3
	],
	[ AS_IF([test ! "x$MST_CHECKS_OK" = "xno"],[MST_CHECKS_OK=yes])
	  $2
	]
      )
])# MST_CHECK_FLAG

# MST_CHECK_PROG(program)
#-----------------------------------
# check if the program exists
AC_DEFUN([MST_CHECK_PROG],
[AC_REQUIRE([MST_CHECK_SETUP])
 mst_check_prog=no

 m4_define(mst_check_prog,m4_normalize([$1]))
 AS_VAR_PUSHDEF(mst_check_prog_var,mst_check_prog_var_[]mst_check_prog)
 AC_CHECK_PROG(mst_check_prog_var,mst_check_prog,[yes],[no])
 MST_CHECK_FLAG($mst_check_prog_var)
 m4_undefine([mst_check_prog_var])
 m4_undefine([mst_check_prog])

])# MST_CHECK_PROG

# MST_CHECK_PKG_MODULES(VARIABLE-PREFIX, MODULES)
#-----------------------------------
# check if the modules exist. uses pkg-config's PKG_CHECK_MODULES to
# see if the modules exist, but instead of aborting on error, sets the
# MST_CHECK flag appropriately
AC_DEFUN([MST_CHECK_PKG_MODULES],
[PKG_CHECK_MODULES([$1],[$2],
	[MST_CHECK_FLAG([yes])],
	[MST_CHECK_FLAG([no])])
])# MST_CHECK_PKG_MODULES


# MST_CHECK_STATUS
#-------------------
# If any test dependencies have failed, report that.  Exit with error
# unless --disable-testdeps was passed to configure.
# Creates and automake conditional HAVE_CHECKS which reflects the
# state of test dependencies
AC_DEFUN([MST_CHECK_STATUS],
[AC_REQUIRE([MST_CHECK_SETUP])

 AS_IF( [test "x$MST_CHECKS_OK" = "xno"],
        [AC_MSG_ERROR([Missing dependencies. Cannot proceed.] ) ]
      )
])# MST_CHECK_STATUS

# check for a library using pkg-config or in system spots

# serial 1

# MST_CHECK_LIB(lib, module, function, [EXTRA LIBRARIES])
#----------------------
AC_DEFUN([MST_CHECK_LIB],
[
m4_define([_MST_CHECK_LIB_ERR],
[Unable to find the $1 library. Please set the environmental variables
            $1[]_CFLAGS and $1[]_LIBS
])
PKG_CHECK_MODULES( [$1], [$2],
		   [LIBS="$LIBS $$1[]_LIBS"
	            CFLAGS="$CFLAGS $$1[]_CFLAGS"],
		   [AC_CHECK_LIB($1, $3,,
				 [ AC_MSG_ERROR(_MST_CHECK_LIB_ERR)],
				 [$4]) ])
])

# serial 1

# MST_CHECK_LIB_CFITSIO
#----------------------
AC_DEFUN([MST_CHECK_LIB_CFITSIO], [MST_CHECK_LIB(cfitsio, cfitsio, ffopen, [-lm])])

# check for a library using pkg-config or in system spots
# updates LIBS and CFLAGS

# serial 1

# MST_CHECK_LIB_CONFIG(lib, module)
# --------------------------------------------------------------
AC_DEFUN([MST_CHECK_LIB_CONFIG],
[
m4_define([_MST_CHECK_LIB_CONFIG_ERR],
[Unable to find the $1 library. Please set the environmental variables
            $1[]_CFLAGS and $1[]_LIBS
])
m4_define([_UC_LIB],translit($1, 'a-z','A-Z'))
PKG_CHECK_MODULES( [$1], [$2],
		   [AC_SUBST(_UC_LIB[]_LIBS,"$$1_LIBS")
		    AC_SUBST(_UC_LIB[]_CFLAGS,"$$1_CFLAGS")
		    LIBS="$LIBS $$1_LIBS"
	            CFLAGS="$CFLAGS $$1_CFLAGS"
		   ],
		   [AC_PATH_TOOL([$1_CONFIG],[$1-config])dnl
		    if test x"$$1_CONFIG" = x ; then
		      AC_MSG_ERROR(_MST_CHECK_LIB_ERR)
		    else
		      AC_SUBST(_UC_LIB[]_CFLAGS,`$$1_CONFIG --cflags`)
		      AC_SUBST(_UC_LIB[]_LIBS,`$$1_CONFIG --libs`)
		      LIBS="$LIBS $_UC_LIB[]_LIBS"
	              CFLAGS="$CFLAGS $_UC_LIB[]_CFLAGS"
 		      AC_MSG_RESULT([ok])
		   fi
		 ]
)
])

# serial 2

# MST_CXCPARAM_DIR
#-----------------------
#
# enable cxcparamdir configuration parameter
AC_DEFUN([MST_CXCPARAM_DIR],
[
  AC_ARG_VAR(CXCPARAMDIR, [CXC parameter directory [DATADIR/uparm]])
  test "${CXCPARAMDIR+set}" = set || CXCPARAMDIR=${datadir}/uparm
  AC_SUBST([cxcparamdir],[$CXCPARAMDIR])
]
)


# MST_CHECK_LIB_CXCPARAM
#-----------------------
#
# Check for cxcparam library, enable paramdir configuration parameter
AC_DEFUN([MST_CHECK_LIB_CXCPARAM],
[
  MST_CHECK_LIB([cxcparam],[cxcparam], [paramopen])
  AC_REQUIRE([MST_CXCPARAM_DIR])
]
)

# serial 1

# MST_CHECK_LIB_LUA
#----------------------
AC_DEFUN([MST_CHECK_LIB_LUA], [
  define([_VERS], $1)
  ifelse(_VERS, [], [AC_MSG_ERROR([ no Lua library version specified ])])
  MST_CHECK_LIB(lua, lua[]_VERS, lua_load, [-llualib])
])

# serial 1

# MST_CHECK_LIB_PCRE
# ------------------
# Create PCRE_CFLAGS and PCRE_LIBS
#
# First try pkg-config, then pcre-config
AC_DEFUN([MST_CHECK_LIB_PCRE],[
PKG_CHECK_EXISTS( [libpcre], 
		 [ PKG_CHECK_MODULES([PCRE], [libpcre] ) 
		 ],
		 [ 
		   AC_PATH_TOOL([PCRE_CONFIG],[pcre-config])
		   if test x"$PCRE_CONFIG" = x ; then
		     AC_MSG_ERROR([no])
		   else
		     PCRE_CFLAGS=`$PCRE_CONFIG --cflags`
		     PCRE_LIBS=`$PCRE_CONFIG --libs`
		     AC_MSG_RESULT([ok])
		   fi
		 ] )
])

# serial 1

# MST_CHECK_LIB_CPGPLOT
#------------------
AC_DEFUN([MST_CHECK_LIB_CPGPLOT],
[AC_MSG_NOTICE([Checking for C pgplot in a variety of places])
AC_REQUIRE([AC_FC_LIBRARY_LDFLAGS])
cpgplot_LDFLAGS=""

AC_SUBST(cpgplot_LIBS)
AC_SUBST(cpgplot_LDFLAGS)
AC_SUBST(cpgplot_CFLAGS)

# kind of kludgy.  not sure if png is compiled into PGPLOT or not, so
# see if libpng-config is around; if so, toss png into the mix.  can't hurt
AC_CHECK_PROG( [HAVE_PNG], [libpng-config], [yes], [no] )

if test "$HAVE_PNG" = yes ; then

  PNG_LDFLAGS=`libpng-config --ldflags`
  PNG_CFLAGS=`libpng-config --cflags`

fi



PKG_CHECK_MODULES(cpgplot,cpgplot,
		 [],
		 [AC_MSG_WARN([no pkg-config setup for pgplot; trying system libraries])

		 # need this as it is AC_REQUIRE'd by AC_PATH_XTRA, which ends up putting
		 # it above the code for PKG_CHECK_MODULES
		   AC_PATH_X
		   AC_PATH_XTRA
		   if test "$no_x" = yes; then
		     AC_MSG_ERROR([X Window System not found. Are the development packages installed?!])
		   fi
		   AC_SUBST(X_LIBS)
		   AC_SUBST(X_PRE_LIBS)
		   AC_SUBST(X_EXTRA_LIBS)

	          cpgplot_LIBS="-lpgplot $PNG_LDFLAGS $FLIBS $X_PRE_LIBS $X_EXTRA_LIBS $X_LIBS -lX11"
		  cpgplot_CFLAGS="$PNG_CFLAGS"
	          AC_ARG_WITH(cpgplot-libraries,
			      AS_HELP_STRING([--with-cpgplot-libraries=/path/to/library_dir],
					     [specify path to directory containing pgplot libraries]),
			      [cpgplot_LDFLAGS="-L$with_cpgplot_libraries"])
		  AC_ARG_WITH(cpgplot-includes,
			      AS_HELP_STRING([--with-cpgplot-includes=/path/to/includes_dir],
					     [specify path to directory containing pgplot header files]),
			      [cpgplot_CFLAGS="-I$with_cpgplot_includes"])
	          AC_CHECK_LIB([cpgplot],[cpgopen],[],
		               [AC_MSG_ERROR([unable to find cpgplot])],
		               [$cpgplot_LDFLAGS $cpgplot_LIBS])
	   	 ])


])# MST_CHECK_LIB_CPGPLOT



# serial 2

# MST_CHECK_LUA
#----------------------
AC_DEFUN([MST_CHECK_LUA],
[
  m4_define([_MIN_V],[$1])
  m4_define([_MAX_V],[$2])
  m4_if(_MIN_V, [], [AC_MSG_ERROR([ no minimum Lua library version specified ])])
  m4_if(_MAX_V, [], [AC_MSG_ERROR([ no maximum Lua library version specified ])])


  dnl first check if there's a version specific pkg-config file. if not,
  dnl see if the "lua" package exists with a version in the requested range
  dnl make all results AX_LUA compatible, as it gets run afterwards for sanity checks
  m4_define([_MST_LUA_V_TEST],[lua[]_MIN_V])
  PKG_CHECK_EXISTS(
    [_MST_LUA_V_TEST],
    [PKG_CHECK_MODULES(LUA,[_MST_LUA_V_TEST])
     AC_SUBST([INSTALL_LMOD],[`$PKG_CONFIG --variable INSTALL_LMOD "_MST_LUA_V_TEST"`])
     AC_SUBST([INSTALL_CMOD],[`$PKG_CONFIG --variable INSTALL_CMOD "_MST_LUA_V_TEST"`])
     AC_SUBST([LUA_LIB],[$LUA_LIBS])
     AC_SUBST([LUA_INCLUDE],[$LUA_CFLAGS])
     ],
      [
        m4_define([_MST_LUA_V_TEST],[lua >= _MIN_V lua < _MAX_V])

        PKG_CHECK_EXISTS(
                        [ _MST_LUA_V_TEST ],
	                [ PKG_CHECK_MODULES(LUA,[_MST_LUA_V_TEST])
			     AC_SUBST([INSTALL_LMOD],
			      	      [`$PKG_CONFIG --variable INSTALL_LMOD "_MST_LUA_V_TEST"`]
                             )
 			     AC_SUBST([INSTALL_CMOD],
			              [`$PKG_CONFIG --variable INSTALL_CMOD "_MST_LUA_V_TEST"`]
                             )
			     AC_SUBST([LUA_LIB],[$LUA_LIBS])
			     AC_SUBST([LUA_INCLUDE],[$LUA_CFLAGS])
			 ],
		       )
      ]
  )

  AX_PROG_LUA(_MIN_V,_MAX_V)
  AX_LUA_HEADERS
  AX_LUA_LIBS

  AC_SUBST(LUA_VERSION,`${LUA} -e 'print(_VERSION)' | sed ["s,.*\(@<:@$as_cr_digits@:>@@<:@.@:>@@<:@$as_cr_digits@:>@\),\1,g"]`)

  LUASFX=`expr "$LUA" : '.*lua\(@<:@0-9.@:>@*\)$'`
  AC_PATH_PROG(LUAC,[luac$LUASFX])

  AC_ARG_VAR(lualibdir, [Lua module installation directory [PREFIX/share/lua/LUA_VERSION]])
  AC_ARG_VAR(lualiblcdir, [Lua compiled library installation directory [EXECPREFIX/lib/lua/LUA_VERSION]])

  test "${lualibdir+set}"  = set || lualibdir='${prefix}/share/lua/'${LUA_VERSION}

  test "${lualiblcdir+set}" = set || lualiblcdir='${exec_prefix}/lib/lua/'${LUA_VERSION}

])

# serial 2

# ===========================================================================
#    mst_cxx_have_shared_ptr
# ===========================================================================
#
# SYNOPSIS
#
#   MST_CXX_HAVE_SHARED_PTR
#
# DESCRIPTION
#
#   If the C++ library has a working shared_ptr, define HAVE_SHARED_PTR



AC_DEFUN([MST_CXX_HAVE_SHARED_PTR],
[
 AC_CACHE_CHECK([whether the compiler has shared_ptr],
                 [mst_cv_cxx_have_shared_ptr],
 		[
		  AC_REQUIRE([AX_CXX_NAMESPACES])
		  AC_LANG_SAVE
		  AC_LANG([C++])
		  AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[#include <memory>
				  #ifdef HAVE_NAMESPACES
				  using namespace std;
				  #endif
				  ]], [[shared_ptr<int> ptr(new int(0)); return 0;]])],[mst_cv_cxx_have_shared_ptr=yes],[mst_cv_cxx_have_shared_ptr=no])
		  AC_LANG_RESTORE
		 ]
 )
if test "X$mst_cv_cxx_have_shared_ptr" = Xyes; then
  AC_DEFINE([HAVE_SHARED_PTR],[],[define if the compiler has shared_ptr])
fi
])

# serial 2

# MST_DEV_ENV_VARS
#------------
AC_DEFUN_ONCE([MST_DEV_ENV_VARS],
[
AC_ARG_VAR([MST_VAR_PFX],
	[The prefix to environment variables used by the MST software. Defaults to MST])

test -z "$MST_VAR_PFX" \
     && MST_VAR_PFX=MST

AC_ARG_VAR(MST_ROOT, [MST root directory])

test -z "$MST_ROOT" &&
	AC_MSG_ERROR([The MST_ROOT variable must be specified])

AC_SUBST([MST_ROOT_VAR],[${MST_VAR_PFX}_ROOT])
AC_SUBST([MST_SIMUL_ROOT_VAR],[${MST_VAR_PFX}_SIMUL_ROOT])
AC_SUBST([MST_OTS_ROOT_VAR],[${MST_VAR_PFX}_OTS_ROOT])
AC_SUBST([MST_TEMPLATE_ROOT_VAR],[${MST_VAR_PFX}_TEMPLATE_ROOT])
AC_SUBST([MST_PGHOST_VAR],[${MST_VAR_PFX}_PGHOST])
AC_SUBST([MST_SYBASE_VAR],[${MST_VAR_PFX}_SYBASE])
AC_SUBST([MST_LOCATE_PATH_VAR],[${MST_VAR_PFX}_LOCATE_PATH])

# unlike MST_ROOT, these contain shell code, not actual values.  the
# variables cannot have the form MST_XXX_ROOT, as this will override
# the existing environment variable of that name (if MST_VAR_PFX ==
# MST_, which is the default) and this messes up things in the
# development environment
AC_SUBST([MST_SIMUL_ROOT_VAL],[\$${MST_ROOT_VAR}/simul])
AC_SUBST([MST_OTS_ROOT_VAL],[\$${MST_ROOT_VAR}/ots])
AC_SUBST([MST_TEMPLATE_ROOT_VAL],[\$${MST_ROOT_VAR}/lib/templates])


# These will create generic MST_XXX_ROOT variables (if they do not
# exist) and propagate them correctly.

test -z "$MST_SIMUL_ROOT" \
     && eval MST_SIMUL_ROOT="$MST_SIMUL_ROOT_VAL"
AC_SUBST([MST_SIMUL_ROOT])

test -z "$MST_OTS_ROOT" \
     && eval MST_OTS_ROOT="$MST_OTS_ROOT_VAL"
AC_SUBST([MST_OTS_ROOT])

test -z "$MST_TEMPLATE_ROOT" \
     && eval MST_TEMPLATE_ROOT="$MST_TEMPLATE_ROOT_VAL"
AC_SUBST([MST_TEMPLATE_ROOT])



])# MST_DEV_ENV_VARS

# MST_DEV_INIT
#---------
# generic initializations for MST specific (e.g. development) packages
AC_DEFUN([MST_DEV_INIT],
[
  AC_REQUIRE([MST_DEV_ENV_VARS])

]) #MST_DEV_INIT


# serial 1

# MST_DEV_PROG_SYSARCH
AC_DEFUN([MST_DEV_PROG_SYSARCH],
[
   AC_REQUIRE([MST_DEV_ENV_VARS])
   test -x "$MST_SIMUL_ROOT/bin/sysarch" \
     || AC_MSG_ERROR([Cannot find sysarch executable])

   AC_SUBST([SYSARCH_VAL],[\$MST_SIMUL_ROOT/bin/sysarch])
   AC_SUBST([SYSARCH],[$MST_SIMUL_ROOT/bin/sysarch])

]) #MST_DEV_PROG_SYSARCH


# _MST_DOSUBST
# serial 3
#----------
# generate mk-dosubst, which creates dosubst.in from autoconf -t
AC_DEFUN([_MST_DOSUBST],[
AC_SUBST([MST_DOSUBST_M4])
AC_PATH_PROG([PERL],[perl],[])
if test "x$PERL" = "x" ; then
   AC_MSG_ERROR( "Perl is required to build this package" );
fi

AC_REQUIRE([AX_ADD_AM_MACRO_STATIC])
AX_ADD_AM_MACRO_STATIC(
[DISTCLEANFILES += mk-dosubst
])
cat > mk-dosubst <<'EOF_DOSUBST'
#!perl
print <<'EOF';

package veval;

sub main::veval(@S|@) {
   my @S|@s = shift; @S|@s =~ s/@/\\@/g;
   @S|@s =~ s/\@S|@\@S|@/\\\@S|@/g;
   @S|@s =~ s/"/\\"/g;
   my (@S|@ret, @S|@nret ) = (@S|@s);
     @S|@ret = @S|@nret while @S|@ret ne (@S|@nret = eval qq@<:@qq@<:@@S|@ret@:>@@:>@);
   return @S|@ret
}

package main;
use Symbol 'qualify_to_ref';

my @S|@bound = <DATA>;
my ( @S|@var ) = @S|@bound =~ /^(\w+)\s/;
my @S|@value = '';
while ( <DATA> ) {

    if ( @S|@_ eq @S|@bound ) {

        chomp @S|@value;
        @S|@subst{@S|@var} = @S|@value;

	@S|@bound = <DATA>;
	( @S|@var ) = @S|@bound =~ /^(\w+)\s/;
	@S|@value = '';
    }

    else {
        @S|@value .= @S|@_;
    }
}

die( "unexpected end of substitution data\n" ) if defined @S|@bound;

*{qualify_to_ref(@S|@_, 'veval')} = \(@S|@subst{@S|@_}) foreach keys %subst;

my @no_eval;

while ( @ARGV ) {
   last unless @S|@ARGV@<:@0@:>@ =~ /^-/;
   my @S|@arg = shift @ARGV;
   last if @S|@arg eq '--';

   if ( @S|@arg =~ /^--no-eval=(.*)/ ) {
     push @no_eval, @S|@1;
   }
   else {
     die( "unknown option to dosubst: @S|@arg\n" );
   }
}

my %eval;
@eval{ keys %subst } = ();
delete @eval{@no_eval};
@S|@subst{"@S|@{_}_EVAL"} = veval @S|@subst{@S|@_} foreach keys %eval;

while( @ARGV && @S|@ARGV@<:@0@:>@ =~ /(.*)=(.*)/ ) {
  @S|@subst{@S|@1} = @S|@2;
  shift;
}

@S|@re = join( '|', sort keys %subst );

while(<>) { s/@<:@@@:>@(@S|@re)@<:@@@:>@/@S|@subst{@S|@1}/geo; print; }

__DATA__
EOF

use Digest::MD5 qw@<:@ md5_base64 @:>@;

foreach ( <STDIN> ) {
    chomp;
    print @S|@_ . ' ' . md5_base64(@S|@_), "\n";
    print '@' . @S|@_ . '@' . "\n";
    print @S|@_ . ' ' . md5_base64(@S|@_), "\n";
}
EOF_DOSUBST
])

# MST_DOSUBST
#------------------
# Wrapper around _MST_DOSUBST so it is called just once
AC_DEFUN([MST_DOSUBST],
[AC_REQUIRE([_MST_DOSUBST])
])# MST_DOSUBST

# LICENSE
#
#   Copyright (c) 2025 Smithsonian Astrophysical Observatory
#   Copyright (c) 2025 Diab Jerius
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#  When you make and distribute a modified version of the Autoconf
#   Macro, you may extend this special exception to the GPL to apply
#   to your modified version as well.

# serial 2


# SYNOPSIS
#
#   MST_FORTRAN_CHARLEN_T([LANG])
#
AC_DEFUN([MST_FORTRAN_CHARLEN_T],
[
  m4_define([_lang],[$1])
  m4_define([_prefix],[$2])
  m4_if(_lang, [], [AC_MSG_ERROR([ no Fortran lang specified ])])

  MST_GNU_FORTRAN_VERSION([$1])

  AS_IF([test "$mst_gnu_fort_version" = '0.0.0'],
        [AC_MSG_FAILURE([ "Couldn't find a GNU Fortran compiler for: $1"])],
        [
         AC_CONFIG_COMMANDS([mst_fortran_charlen_t.h],
                  [cat  > []_prefix[]mst_fortran_charlen_t.h <<EOF
#ifndef MST_FORTRAN_CHARLEN_T_H
#define MST_FORTRAN_CHARLEN_T_H
#if ( defined(__GNUC__) && __GNUC__ > 7 ) || defined(__clang__)
typedef size_t mst_fortran_charlen_t;
#else
typedef int mst_fortran_charlen_t;
#endif
#endif /* MST_FORTRAN_CHARLEN_T_H */
EOF
])
])
])

# LICENSE
#
#   Copyright (c) 2015-2022 Smithsonian Astrophysical Observatory
#   Copyright (c) 2015-2022 Diab Jerius
#
#   This program is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation, either version 3 of the License, or (at your
#   option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
#   Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   As a special exception, the respective Autoconf Macro's copyright owner
#   gives unlimited permission to copy, distribute and modify the configure
#   scripts that are the output of Autoconf when processing the Macro. You
#   need not follow the terms of the GNU General Public License when using
#   or distributing such scripts, even though portions of the text of the
#   Macro appear in them. The GNU General Public License (GPL) does govern
#   all other use of the material that constitutes the Autoconf Macro.
#
#  When you make and distribute a modified version of the Autoconf
#   Macro, you may extend this special exception to the GPL to apply
#   to your modified version as well.

# serial 2


# SYNOPSIS
#
#   MST_GNU_FORTRAN_VERSION([LANG])
#
AC_DEFUN([MST_GNU_FORTRAN_VERSION],
[
  AC_REQUIRE([AC_PROG_SED])

  AC_LANG_PUSH([$1])

  AS_VAR_PUSHDEF([mst_gnu_fort_is_gnu],[ac_cv_[]_AC_LANG_ABBREV[]_compiler_gnu])

  AS_VAR_PUSHDEF([mst_gnu_fort_version_cv],[mst_cv_prog_[]_AC_LANG_ABBREV[]_version])

  # [\([0-9][0-9]*\)\.\([0-9][0-9]*\)\.\([0-9][0-9]*\)]
  mst_gfv_pattern='\(@<:@0-9@:>@@<:@0-9@:>@*\)\.\(@<:@0-9@:>@@<:@0-9@:>@*\)\.\(@<:@0-9@:>@@<:@0-9@:>@*\)'

  AS_VAR_IF(
    [mst_gnu_fort_is_gnu],[yes],
    [
      AC_CACHE_CHECK(
       [for GNU _AC_LANG compiler version],
       [mst_gnu_fort_version_cv],
       [
         AC_LANG_CASE(
	   [Fortran 77],[_mst_gnu_fort_compiler=$F77],
	   [Fortran],[_mst_gnu_fort_compiler=$FC],
	   [AC_MSG_FAILURE([ _AC_LANG is not recognized as a language? ])]
	 )
         _mst_gnu_fort_version=`$_mst_gnu_fort_compiler --version`
	 _mst_gnu_fort_version_status=$?
	 AS_IF([test $_mst_gnu_fort_version_status = 0],
  	    [
  	      AS_VAR_SET(
  		    [mst_gnu_fort_version_cv],
  		    [`AS_ECHO(["$_mst_gnu_fort_version"]) | $SED -e "1s/.*@<:@@<:@:blank:@:>@@:>@$mst_gfv_pattern.*/\1.\2.\3/" -e '1!d'`]dnl
  	      )
  	    ],
	    [
  	      AC_MSG_FAILURE( [error running $[]_AC_CC([$1])] )
	    ]
  	 )
       ]
      )
    ]
  )

  AS_VAR_POPDEF([mst_gnu_fort_is_gnu])

  AS_VAR_PUSHDEF([mst_gnu_fort_version],[mst_prog_gnu_[]_AC_LANG_ABBREV[]_version])

  AS_VAR_SET_IF(
    [mst_gnu_fort_version_cv],
    [AC_SUBST(mst_gnu_fort_version,$[]mst_gnu_fort_version_cv)],
    [AC_SUBST(mst_gnu_fort_version,[0.0.0])]
  )

  AC_SUBST(mst_gnu_fort_version[]_major,
    [`AS_ECHO([$[]mst_gnu_fort_version]) | $SED -e "s/^$mst_gfv_pattern/\1/"`]dnl
  )

  AC_SUBST(mst_gnu_fort_version[]_minor,
    [`AS_ECHO([$[]mst_gnu_fort_version]) | $SED -e "s/^$mst_gfv_pattern/\2/"`]dnl
  )

  AC_SUBST(mst_gnu_fort_version[]_patch,
    [`AS_ECHO([$[]mst_gnu_fort_version]) | $SED -e "s/^$mst_gfv_pattern/\3/"`]dnl
  )

  AS_VAR_POPDEF([mst_gnu_fort_version_cv])
  AS_VAR_POPDEF([mst_gnu_fort_version])
  AC_LANG_POP([$1])
])

# unpack fused gtest sources

# serial 3

# MST_GTEST
#----------
AC_DEFUN([MST_GTEST],
[
AC_SUBST([MST_GTEST_M4])
AC_ARG_WITH( [gtest],
             [AS_HELP_STRING([--with-gtest=ARG],
                             [ARG is path to googletest archive @<:@default=use bundled version@:>@])],
             [],[with_gtest=no]
           )
if test "$with_gtest" = "" ; then

    AC_MSG_ERROR([--with-gtest requires an argument])

elif test "$with_gtest" = no ; then

    AC_CHECK_FILE([$srcdir/tests/gtest/src/gtest-all.cc],
                  [],
                  [AC_CHECK_FILE([tests/gtest/src/gtest-all.cc],
                                 [],
                                 [AC_MSG_ERROR([googletest is not bundled; please specify it with --with-gtest])]
                                 )
                  ]
                 )
    AC_MSG_NOTICE([using bundled googletest])
else

    AC_MSG_NOTICE([trying googletest distribution $with_gtest])
    AC_CHECK_FILE([$with_gtest],
                  [],
                  [AC_MSG_ERROR(cannot find $with_gtest)]
                 )
    AS_CASE( [$with_gtest],
            [*.zip],
            [
                AC_PATH_PROG([UNZIP],[unzip],[no])
                test "$UNZIP" = no && \
                    AC_MSG_ERROR([unzip not found; unable to extract googletest])
                AC_MSG_NOTICE([unpacking $with_gtest])
                AS_MKDIR_P([tests/gtest])

		# find license/copying file
		gtest_license=`unzip -Z -1 $with_gtest | grep -E '^[[^/]]*/LICENSE|COPYING'` \
		   || AC_MSG_ERROR([can't find license file in $with_gtest])
                unzip -o -j -q $with_gtest "$gtest_license" -d tests/gtest \
                      || AC_MSG_ERROR([error extracting googletest license])

                unzip -o -q \
                    $with_gtest "*/googletest/src/*" "*/googletest/include/*" -d tests/gtest/unzip \
                    || AC_MSG_ERROR([error extracting googletest source files])

                rm -rf tests/gtest/src tests/gtest/include
                mv `find tests/gtest/unzip -name src` tests/gtest
                mv `find tests/gtest/unzip -name include` tests/gtest
                rm -rf tests/gtest/unzip
            ],
            [
                AC_MSG_ERROR([do not know how to unpack googletest archive $with_gtest])
            ]
            )

fi

dnl otherwise autoconf flags the below usage as a possible
dnl undefined macro if AM_CXXFLAGS hasn't been mentioned yet
m4_pattern_allow([AM_CXXFLAGS])

# googletest uses variadic macros, which g++ -pedantic-errors is very unhappy about
AC_SUBST([GTEST_CXXFLAGS],
        [`AS_ECHO_N(["$AM_CXXFLAGS $CXXFLAGS"]) | sed s/-pedantic-errors/-pedantic/`]
        )
])

# serial 1

# MST_PERL_BLIB
#------------
# create PERL_BLIB_ENVVAR 
#
AC_DEFUN([MST_PERL_BLIB],
[
  AC_SUBST([PERL_BLIB_ENVVAR],
           [PERL_BLIB_[]AS_TR_SH(AC_PACKAGE_NAME)]
	   )
])# MST_PERL_BLIB

# serial 1

# MST_PERL_LIBDIR
# --------------
#
#  declare the precious variable 'perllibdir' as the Perl library
#  installation directory. It will default to '${prefix}/lib/perl5'.
#

AC_DEFUN([MST_PERL_LIBDIR],
[
AC_ARG_VAR(perllibdir, [Perl library installation directory [PREFIX/lib/perl5]])
test "${perllibdir+set}" = set || perllibdir='${prefix}/lib/perl5'
])


# serial 2

# MST_PERL_STARTPERL
#------------
# Figure out how to start perl.  Creates a STARTPERL variable
#
AC_DEFUN([MST_PERL_STARTPERL],
[
  # make program_prefix available for interpolation as mst_program_prefix
  AC_PATH_PROG(PERL,perl,NOTFOUND)
  test "$PERL" = NOTFOUND && \
       AC_MSG_ERROR([Require a Perl interpreter])
  eval `$PERL -V:startperl`
  AC_SUBST(STARTPERL,[`echo $startperl | sed 's:#:\\\\#:'`])
])# MST_PERL_STARTPERL

# serial 1

# MST_PERL_USELIB
#------------
# generate a "use lib 'dir';" string if specified. @PERL_USELIB@ must be inserted into code.
#
AC_DEFUN([MST_PERL_USELIB],
[
  AC_SUBST([PERL_USELIB])
  AC_ARG_ENABLE([uselib],
		[AS_HELP_STRING([--enable-uselib@<:@=DIR@:>@],
		                [enable alternate Perl library directory (DIR=PACKAGE-VERSION if not specified)]
				)

		],
		[
		if test "x$enableval" = xyes ; then
		   enableval='$(libdir)/'"$PACKAGE-$VERSION"
		fi 
		PERL_USELIB='use lib "'$enableval'";'
		]
	       )
])# MST_PERL_USELIB

# serial 2

# MST_POD_GEN_DOCS
# ----------------
#
#  Find Pod conversion programs to generate documentation
AC_DEFUN([MST_POD_GEN_DOCS],
[
AC_SUBST([MST_POD_GEN_DOCS_M4])
AC_CHECK_PROG([POD2MAN],[pod2man],[yes],[no])
AM_CONDITIONAL([MST_POD_GEN_DOCS_MAN],[test $POD2MAN = yes])
AM_COND_IF([MST_POD_GEN_DOCS_MAN],
	   [],
	   [AC_MSG_WARN( "unable to generate manual pages; will install distributed version" )
	   ])


AC_CHECK_PROG([POD2HTML],[pod2html],[yes],[no])
AM_CONDITIONAL([MST_POD_GEN_DOCS_HTML],[test $POD2HTML = yes])
AM_COND_IF([MST_POD_GEN_DOCS_HTML],
	   [],
	   [AC_MSG_WARN( "unable to generate HTML documentation; will install distributed version" )
	   ])

AC_CHECK_PROG([POD2README],[pod2readme],[yes],[no])
AM_CONDITIONAL([MST_POD_GEN_DOCS_README],[test $POD2README = yes])
AM_COND_IF([MST_POD_GEN_DOCS_README],
	   [],
	   [AC_MSG_WARN( "unable to generate README from pod" )
	   ])

AC_CHECK_PROG([POD2MARKDOWN],[pod2markdown],[yes],[no])
AM_CONDITIONAL([MST_POD_GEN_DOCS_README_MD],[test $POD2MARKDOWN = yes])
AM_COND_IF([MST_POD_GEN_DOCS_README_MD],
	   [],
	   [AC_MSG_WARN( "unable to generate README.md from pod" )
	   ])


AC_CHECK_PROG([POD2PDF],[pod2pdf],[yes],[no])
AM_CONDITIONAL([HAVE_POD2PDF],[test $POD2PDF = yes])

# if pod2pdf is not available, use pod2man, groff, and ps2pdf
doc_gen_pdf_from_man_ps=no
AM_COND_IF([HAVE_POD2PDF],
	   [],
	   [AM_COND_IF([MST_POD_GEN_DOCS_MAN],
	               [AC_CHECK_PROG([GROFF],[groff],[yes],[no])
		        AS_IF([test $GROFF = yes],
			      [AC_CHECK_PROG([PS2PDF],[ps2pdf],[yes],[no])
			       AS_IF([test $PS2PDF = yes],
			       	     [doc_gen_pdf_from_man_ps=yes]
                                    )
			      ],
			)
		       ]
	    )
           ]
)
AM_CONDITIONAL([MST_POD_GEN_DOCS_PDF_MAN_PS],[test $doc_gen_pdf_from_man_ps = yes])
AM_CONDITIONAL([MST_POD_GEN_DOCS_PDF],[test $POD2PDF = yes -o $doc_gen_pdf_from_man_ps = yes])

AM_COND_IF([MST_POD_GEN_DOCS_PDF],
	   [],
           [AC_MSG_WARN( "unable to generate PDF documentation; will install distributed version" )
           ]
)

]) # MST_POD_GEN_DOCS


# serial 3

# MST_INIT_DOXYGEN([optional path to Doxyfile])
#----------
# Hardwire MST doxygen policy
# failure for all checks at end of list so that user
# sees them all
# 1. MST_CHECK_SETUP
# 2. MST_CHECK_XXX as needed
# 3. MST_CHECK_STATUS to report on the final status of the test
#    and die if necessary

AC_DEFUN([MST_INIT_DOXYGEN],
[AC_SUBST([MST_INIT_DOXYGEN_M4])
 AC_REQUIRE([DX_INIT_DOXYGEN])
 DX_DOXYGEN_FEATURE(ON)
 DX_DOT_FEATURE(ON)
 DX_PDF_FEATURE(ON)
 DX_PS_FEATURE(OFF)
 DX_HTML_FEATURE(ON)
 DX_MAN_FEATURE(OFF)
 AS_IF([test "x$1" = "xnorecurse" ],
  [DX_INIT_DOXYGEN([$PACKAGE],[$(srcdir)/docs/Doxyfile],[docs/doxygen-doc])],
   [DX_INIT_DOXYGEN([$PACKAGE])]
 )
])# MST_INIT_DOXYGEN

# serial 2

AC_DEFUN([MST_PROG_LUA_MODULES],[dnl

m4_define([mst_lua_modules])
m4_foreach([mst_lua_module], m4_split(m4_normalize([$1])),
	  [
	   m4_append([mst_lua_modules],[']mst_lua_module[' ])
          ])

# Make sure we have lua
AS_IF( [test -z "$LUA"],
       [AC_MSG_ERROR( "LUA not set: use [[MST_CHECK_LUA]] to discover the appropriate Lua executable" )]
       )

mst_lua_modules_failed=0

for mst_lua_module in mst_lua_modules; do

  mst_lua_modulex=`echo $mst_lua_module | sed "s/\./_/g"`

  AC_CACHE_CHECK([for lua module $mst_lua_module],
                 [mst_cv_lua_$mst_lua_modulex],
                 [
                  eval mst_cv_lua_$mst_lua_modulex=no
                  $LUA $LUAFLAGS -l $mst_lua_module -e 'return' 2>/dev/null && eval mst_cv_lua_$mst_lua_modulex=yes
		 ]
  )
  AS_IF([eval test "x\${mst_cv_lua_$mst_lua_modulex}" = "xno"],
        [mst_lua_modules_failed=1]
  )
done

# Run optional shell commands
AS_IF( [test "$mst_lua_modules_failed" = 0],
       [  :
          $2
       ],
       [
          :
          $3
       ]
)      

])

# serial 1

# _MST_PATCH_TEST( VARIABLE, PROG-TO-TEST, [VALUE-IF-OK], [VALUE-IF-NOT] )
# check if patch or applypatch work
#---------------------------------------------------------
AC_DEFUN([_MST_PATCH_TEST],
[# Extract program name to test
AC_MSG_CHECKING([if $2 works correctly])
AS_MKDIR_P(conftest.dir)
echo "b" > conftest.dir/a
echo "a" > conftest.dir/b
cat >conftest.patch <<'_ACEOF'
# This is a patch for conftest.orig to update it to conftest.dir
#
# To apply this patch:
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'applypatch' program with this patch file as input.
#
# If you do not have 'applypatch', it is part of the 'makepatch' package
# that you can fetch from the Comprehensive Perl Archive Network:
# http://www.perl.com/CPAN/authors/Johan_Vromans/makepatch-x.y.tar.gz
# In the above URL, 'x' should be 2 or higher.
#
# To apply this patch without the use of 'applypatch':
# STEP 1: Chdir to the source directory.
# STEP 2: Run the 'patch' program with this file as input.
#

diff -c 'conftest.orig/a' 'conftest.dir/a'
Index: ./a
*** ./a	Fri Feb 10 18:58:58 2006
--- ./a	Fri Feb 10 18:57:54 2006
***************
*** 1 ****
! b
--- 1 ----
! a
diff -c 'conftest.orig/b' 'conftest.dir/b'
Index: ./b
*** ./b	Fri Feb 10 18:59:02 2006
--- ./b	Fri Feb 10 18:58:00 2006
***************
*** 1 ****
! a
--- 1 ----
! b

# Data version        : 1.0
# Date generated      : Fri Feb 10 18:59:05 2006
# Generated by        : makepatch 2.00
# Recurse directories : Yes
# p 'a' 2 1139615874 0100644
# p 'b' 2 1139615880 0100644

_ACEOF
cd conftest.dir
_RC=1
$2 < ../conftest.patch >/dev/null 2>&1 && _RC=0
cd ..
rm -rf conftest.dir conftest.patch
if test $_RC = 0
then
  AC_MSG_RESULT([yes])
  m4_ifvaln([$3],[AS_VAR_SET([$1],[$3])])dnl
else 
  AC_MSG_RESULT([no])
  m4_ifvaln([$4],[AS_VAR_SET([$1],[$4])])dnl
fi
])# _MST_PATCH_TEST


# MST_PROG_PATCH
# --------------
AC_DEFUN([MST_PROG_PATCH],
[
  AC_ARG_VAR([PATCH], [explict path to patch program])
  AC_ARG_WITH([patch],
	      AS_HELP_STRING([--with-patch=/path/to/patch],
			     [explicitly specify path to patch command]),
	      [PATCH=$withval]
	     )
  AC_PATH_PROG([PATCH], [patch])
  if test -n "$PATCH"  ; then
    _MST_PATCH_TEST(PATCH,[$PATCH],,[""])
    if test -z "$PATCH" ; then
    AC_MSG_WARN([broken patch command; try installing GNU patch])
    fi
  fi
  AC_SUBST(PATCH)
])# MST_PROG_PATCH


# MST_PROG_APPLYPATCH
#--------------------
AC_DEFUN([MST_PROG_APPLYPATCH],
[
 AC_ARG_VAR([APPLYPATCH], [explicit path to applypatch program])
 AC_REQUIRE([MST_PROG_PATCH])
 if test -n "$PATCH" ; then	
   AC_PATH_PROG([APPLYPATCH], [applypatch], [] )
 fi
 AC_SUBST(APPLYPATCH)
])# MST_PROG_APPLYPATCH

 

# serial 1

# MST_PROG_PROVE_EXEC
#--------------------
# test for Perl's prove command which accepts --exec
#
AC_DEFUN([MST_PROG_PROVE_EXEC],
[AC_CACHE_CHECK( [Perl prove with --exec],[mst_cv_prog_prove_exec],
		 [mst_cv_prog_prove_exec=no
		  AC_PATH_PROG(PROVE,prove)
		  if test -n "$PROVE"; then
		   # for some reason prove --help | grep -- --exec
		   # returns 1 upon success on linux.  dunno
		   # why. works if it's written out to a file
		    : ${TMPDIR=/tmp}
		    {
		    	 tmp=`(umask 077 && mktemp -d "$TMPDIR/fooXXXXXX") 2>/dev/null` \
			  && test -n "$tmp" && test -d "$tmp"
		    } || {
		    	 tmp=$TMPDIR/foo$$-$RANDOM
		    	 (umask 077 && mkdir "$tmp")
		    } || exit $?
		    trap "/bin/rm -rf $tmp" 0

		    ${PROVE} --help > $tmp/prove.out 2>&1
		     grep -- --exec $tmp/prove.out > /dev/null 2>&1 &&
		         mst_cv_prog_prove_exec=yes
		  fi
		  ] )
  if test "x$mst_cv_prog_prove_exec" = xno; then
    AC_MSG_ERROR([Cannot find prove which accepts --exec; please update the Test::Harness Perl module])
  fi
])# MST_PROG_PROVE_EXEC

# serial 1

# MST_PROG_USAGE
# ----------------
#
#  Find conversion programs to generate built-in help and usage
#  documentation from POD source

AC_DEFUN([MST_PROG_USAGE],
[
dnl create macro so can be tested for inclusion by automake
AC_SUBST([MST_PROG_USAGE_M4])

AC_CHECK_PROG([TEXT2USAGE],[text2usage],[yes],[no])
AC_CHECK_PROG([POD2TEXT],[pod2text],[yes],[no])

AS_IF( [test "$TEXT2USAGE" = yes -a "$POD2TEXT" = yes],
       [HAVE_MST_PROG_USAGE=yes],
       [HAVE_MST_PROG_USAGE=no]
)

AM_CONDITIONAL([HAVE_MST_PROG_USAGE],[test $HAVE_MST_PROG_USAGE = yes])
AM_COND_IF([HAVE_MST_PROG_USAGE],
	   [],
	   [AC_MSG_WARN( "unable to regenerate built-in docs; will use distributed version" ) ] )
]) # MST_PROG_USAGE


# serial 3

# MST_TESTDEP_SETUP( mandatory )
#-----------------------------
# Perform setup steps for dependencies needed to run tests
# By default missing test dependencies results in a fatal error.
# This routine provides a configure switch to make them optional,
# as well as creating the variables which will hold state information
#
# Use MST_TESTDEP_TEST and MST_TESTDEP_FLAG to update the state,
# and MST_TESTDEP_STATUS to report on the final status of the test
# dependencies (and die if necessary)
#
# Parameters:

# mandatory: boolean
#   if present and 'yes', the --enable-testdeps configure option is
#   not generated, and MST_TESTDEP_STATUS will abort if test
#   dependencies are not met.

AC_DEFUN([MST_TESTDEP_SETUP],
[

 m4_pushdef([_is_testdep_mandatory],m4_default([$1],[no]))

 m4_case(_is_testdep_mandatory,
        [yes],[MST_REQUIRE_TESTDEPS=mandatory],
        [no], [ AC_ARG_ENABLE(testdeps,
        	AS_HELP_STRING([--enable-testdeps],
	        	       [missing test dependencies are a fatal error. [[default=yes]]]),
                               [MST_REQUIRE_TESTDEPS="$enableval"],
                               [MST_REQUIRE_TESTDEPS=yes] )
                # normalize flag
                test "$MST_REQUIRE_TESTDEPS" != no && MST_REQUIRE_TESTDEPS=yes
           ],
        [m4_fatal([MST_TESTDEP_SETUP: unknown value for mandatory flag: '$1'. must be 'yes' or 'no'])]
        )
        

 MST_HAVE_TESTDEPS=

 m4_popdef([_is_testdep_mandatory])

])# MST_TESTDEP_SETUP


# MST_TESTDEP_TEST(command, message)
#-----------------------------------
# Run the command.  If it returns false, report that the test dependency
# has failed and update the global dependency state.
AC_DEFUN([MST_TESTDEP_TEST],
[AC_REQUIRE([MST_TESTDEP_SETUP])
 AS_IF( [$1],
	[ test "$MST_HAVE_TESTDEPS" != no && MST_HAVE_TESTDEPS=yes ],
	[
	  MST_HAVE_TESTDEPS=no
	  m4_ifnblank([$2],[AC_MSG_WARN([$2: Missing test dependency])])
	]
      )
])# MST_TESTDEP_TEST

# MST_TESTDEP_FLAG( flag value, message)
#---------------------------------------
# If the flag value is "no", report that the test dependency has failed
# and update the global dependency state.
AC_DEFUN([MST_TESTDEP_FLAG],
[
  MST_TESTDEP_TEST([test "$1" != no], [$2])
])# MST_TESTDEP_FLAG


# MST_TESTDEP_STATUS
#-------------------
# If any test dependencies have failed, report that.  Exit with error
# unless --disable-testdeps was passed to configure.
# Creates and automake conditional HAVE_TESTDEPS which reflects the
# state of test dependencies
AC_DEFUN([MST_TESTDEP_STATUS],
[AC_REQUIRE([MST_TESTDEP_SETUP])
  AS_IF([test "$MST_HAVE_TESTDEPS" = no],
        [AS_CASE([$MST_REQUIRE_TESTDEPS],
                [yes], [AC_MSG_ERROR([Missing test dependencies.  Use --disable-testdeps to ignore])],
                [mandatory],[AC_MSG_ERROR([Missing test dependencies.  Please install them and try again.])],
                [no],[AC_MSG_WARN([Missing test dependencies.  Some test will not be run])]
                )
        ])

 AM_CONDITIONAL( HAVE_TEST_DEPS, test "$MST_HAVE_TESTDEPS" != no)
])# MST_TESTDEP_STATUS



# MST_PROG_TESTPERL
# -----------------
# Check if Perl is available.  Sets the global test dependency state.
# Sets the AM_CONDITIONAL HAVE_TESTPERL
AC_DEFUN([MST_PROG_TESTPERL],
[AC_REQUIRE([MST_TESTDEP_SETUP])
 AC_PATH_PROG(PERL,perl)
 MST_TESTDEP_TEST( [test -n "$PERL"], [Can't find Perl])
 AM_CONDITIONAL( HAVE_TESTPERL, [test -n "$PERL"] )
])# MST_PROG_TESTPERL


# MST_PROG_TESTSHELL
# -------------------
# Check if an acceptable shell (bash, ksh) is available.
# Sets the global test dependency state.
# Sets the AM_CONDITIONAL HAVE_TESTSHELL
AC_DEFUN([MST_PROG_TESTSHELL],
[AC_ARG_VAR([TESTSHELL],[shell used to run tests])
 if test "x$ac_cv_env_TESTSHELL_set" != "xset"; then
    AC_MSG_NOTICE([checking for a compatible test shell])
    AC_PATH_PROG(BASHELL,bash)
    TESTSHELL="$BASHELL"
    if test -z "$TESTSHELL"; then
      AC_PATH_PROG(KSHELL,ksh)
      TESTSHELL="$KSHELL"
    fi
    MST_TESTDEP_TEST([test -n "$TESTSHELL"],[Can't find ksh or bash])
 else
   AC_MSG_NOTICE([using $TESTSHELL as the test shell])
 fi
 test -n "$TESTSHELL" && test ! -x "$TESTSHELL" \
	  && AC_MSG_ERROR( [testshell $TESTSHELL is not an executable] )
 AM_CONDITIONAL( HAVE_TESTSHELL, [test -n "$TESTSHELL"] )
])# MST_CHECK_TESTSHELL

# MST_CHECK_TESTPROG(program)
#-----------------------------------
# check if the program exists
AC_DEFUN([MST_CHECK_TESTPROG],
[AC_REQUIRE([MST_TESTDEP_SETUP])
 mst_check_testprog=no

 m4_define(mst_check_testprog,m4_normalize([$1]))
 AS_VAR_PUSHDEF(mst_check_testprog_var,mst_check_testprog_var_[]mst_check_testprog)
 AC_CHECK_PROG(mst_check_testprog_var,mst_check_testprog,[yes],[no])
 MST_TESTDEP_FLAG($mst_check_testprog_var)
 m4_undefine([mst_check_testprog_var])
 m4_undefine([mst_check_testprog])

])# MST_CHECK_TESTPROG

# MST_CHECK_TEST_PKG_MODULES(VARIABLE-PREFIX, MODULES)
#-----------------------------------
# check if the modules exist. uses pkg-config's PKG_CHECK_MODULES to
# see if the modules exist, but instead of aborting on error, sets the
# MST_TESTDEP flag appropriately
AC_DEFUN([MST_CHECK_TEST_PKG_MODULES],
[PKG_CHECK_MODULES([$1],[$2],
	[MST_TESTDEP_FLAG([yes])],
	[MST_TESTDEP_FLAG([no])])
])# MST_CHECK_TEST_PKG_MODULES


