!+
!KWIC ableg4.f
!
!$Id: ableg4.f,v 1.2 2004/03/17 21:23:30 dtn Exp $
!
!Revisions:
!   95-Jan-23[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO ALLOW LEGENDRE POLYNOMIALS FROM ORDER 24 (I.E.,
!        !  25 TERMS) TO ORDER 100 (I.E., 101 TERMS)
!        !  (COMMENTS CHANGED WHERE APPROPRIATE, ALSO), AND
!        !  TO ALLOW UP TO 250 FOURIER TERMS, IN CASE NEEDED
!        !  FOR VERY LOW ORDER LEGENDRE / VERY HIGH ORDER FOURIER EXPANSION
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-16[T. Gaetz]
!      . make AL(NLEG, 1) into assumed size array; allows
!        bounds-checking compiler option to be used.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!-
C
C THIS CODE HAS BEEN TRANSPORTED TO THE VAX BY MARK WILSON AND MICHAEL OTTERMAN
C OF CODE 717. THE ORIGINAL TARGET MACHINE WAS THE NASA GODDARD IBM 360/75
C UNDER OS AND THE APPLICATION PROGRAMS WERE WRITTEN IN USASI FORTRAN IV.
C ANY CHANGES THAT WERE MADE WILL BE MARKED BY '!***'.
C
      SUBROUTINE ABLEG4 (ZN, CT, ST, OL, AL, BL, Q, QT, QZ,IER,ivaxj)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    ABLEG4 FORTRAN
C    *    WRITTEN BY PHILIP GRIBOSKY
C    *            ON 08/28/80
C    *
C    *    UPDATE:   10/23/81
C    *    TIME:     16:20:13
C    *
C    ******************************************/
C
C  EVALUATE THE DEFORMATION OF A SURFACE WITH LEGENDRE-FOURIER
C  DEFORMATIONS AT ZN. ALSO EVALUATE THE PARTIAL DERIVATIVES.
C
      !*** all variables have been changed to real*8
      IMPLICIT DOUBLE PRECISION (A-H,O-Z) 
      IMPLICIT INTEGER (I-N) 

C  INPUT ARGUMENTS:
C    ZN : R*8 - NORMALIZED Z COORD. = 2*Z/L WHERE L = LENGTH OF SURFACE
C    CT : R*8 - COS (THETA) WHERE THETA = ARCTAN (Y/X)
C    ST : R*8 - SIN (THETA) WHERE THETA = ARCTAN (Y/X)
C    OL : R*8 - ARRAY (NLEG) PURE LEGENDRE COEFFICIENTS
C    AL : R*8 - ARRAY (NLEG, NFOUR) LEGENDRE COSINE COEFFICIENTS
C    BL : R*8 - ARRAY (NLEG, NFOUR) LEGENDRE SINE COEFFICIENTS
C
C     !*** on the ibm version the arrays  BL above are adjustable
C     !*** and the dimensions were given through the variables NLEG and 
C     !*** NFOUR via the COMMON block DEFORM.
C     !*** This caused run time errors when the number of FOURIER terms was 0.
C     !*** A correction was made to set the dimension to 1 when NFOUR is 0.
C     !*** The variable IVAXJ is supplied by the calling subroutine ICLEG4
C     !*** to determine the second dimension .
C
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    NLEG  : I*4 - NUMBER OF LEGENDRE TERMS = HIGHEST DEGREE + 1
C    NFOUR : I*4 - NUMBER OF FOURIER TERMS
C
C  OUTPUT ARGUMENTS:
C    Q   : R*8 - TOTAL DEFORMATION
C    QT  : R*8 - PARTIAL DERIVATIVE OF DEFORMATION WRT THETA
C    QZ  : R*8 - PARTIAL DERIVATIVE OF DEFORMATION WRT ZN
C    IER : I*4 - ERROR CODE (SEE LEGEND)
C
C  EXTERNAL REFERENCES: LEGEND
C

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs

      DOUBLE PRECISION OL(NLEG), AL(NLEG, *), BL(NLEG, ivaxj) 
                                                  !*** ivaxj was NFOUR
      DOUBLE PRECISION C(250),S(250),TD(250),PL(101),QL(101)


      DOUBLE PRECISION CT, ST, DFORM, DFORT, DFORZ, FORM, FORT

       DFORM = 0.0D0
       DFORT = 0.0D0
       DFORZ = 0.0D0
       Q = 0.0
       QT = 0.0
       QZ = 0.0
C
       IF(ABS (ZN) .GT. 1) GOTO 1000
C
C   EVALUATE THE LEGENDRE POLYNOMIALS
C
       CALL LEGEND (NLEG,ZN,PL,QL,IER)
C
       IF(IER .NE. 0) GOTO 2000
           CJ = CT
           SJ = ST
C
           IF (NFOUR .LE. 0) GO TO 15
C
           DO 10 J = 1,NFOUR
             C(J) = CJ
             S(J) = SJ
             TD(J) = J
C
C   UPDATE COS(J*THETA), SIN(J*THETA)
C
             H = CJ
             CJ = H * CT - SJ * ST
             SJ = H * ST + SJ * CT
10           CONTINUE
C
C
15         IF (NLEG .LE. 0) GO TO 60
C
           DO 50 I = 1, NLEG
             FORT = 0.0
             FORM = OL(I)
C
             IF (NFOUR .LE. 0) GO TO 40
             DO 30 J = 1, NFOUR
               FORT = FORT + (BL(I,J) * C(J) - AL(I,J) * S(J)) * TD(J)
               FORM = FORM + AL(I,J) * C(J) + BL(I,J) * S(J)
30             CONTINUE
C
40             DFORM = PL(I) * FORM + DFORM
C   PARTIAL WITH RESPECT TO THETA
               DFORT = PL(I) * FORT + DFORT
C   PARTIAL WITH RESPECT TO ZN
               DFORZ = QL(I) * FORM + DFORZ
50             CONTINUE
C
60         Q = DFORM
           QT = DFORT
           QZ = DFORZ
C
           GOTO 3000
C
1000       IER = 1
           GOTO 3000
C
2000       IER = 2
3000       RETURN
           END
