!+
!KWIC abzern.f
!
!$Id: abzern.f,v 1.2 2004/03/17 21:23:30 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!-
!
!  UPDATED 5/9/88 TO ALLOW FOR ANNULAR ZERNIKE POLYNOMIALS,
!  TO ALLOW THE FULL NUMBER (325) OF POLYNOMIALS,
!  AND TO DELETE SINGLE PRECISION MATH
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE ABZERN (XN, YN, ZAP, XAP, YAP, IER)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    ABZERN FORTRAN
C    *    WRITTEN BY LOUIS JACKSON
C    *            ON 08/05/80
C    *
C    *    UPDATE:   11/20/80
C    *    TIME:     16:30:16
C    *
C    ******************************************/
C
C  EVALUATE THE DEFORMATION OF A SURFACE DESCRIBED BY ZERNIKE
C  DEFORMATION COEFFICIENTS AT THE POINT (XN, YN). ALSO EVALUATE THE
C  PARTIAL DERIVATIVES.
C
C  INPUT ARGUMENTS:
C    XN : R*4 - NORMALIZED X COORD. = X / R2S
C    YN : R*4 - NORMALIZED Y COORD. = Y / R2S
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    NDF  : I*4 - NUMBER OF DEFORMATION COEFFICIENTS
C    DEFC : R*4 - ARRAY (NDF) DEFORMATION COEFFICIENTS
C
C  OUTPUT ARGUMENTS:
C    ZAP : R*4 - TOTAL ZERNIKE DEFORMATION
C    XAP : R*4 - PARTIAL DERIVATIVE OF ZAP WRT XN
C    YAP : R*4 - PARTIAL DERIVATIVE OF ZAP WRT YN
C    IER : I*4 - ERROR CODE (SEE ZERNIK)
C
C  EXTERNAL REFERENCE: ANNULR, ZERNIK
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
 
      DOUBLE PRECISION ZERX(325), ZERY(325), ZERP(325)
      DOUBLE PRECISION ZAPD, XAPD, YAPD

      IER = 0
      XAPD = 0.0D0
      YAPD = 0.0D0
      ZAPD = 0.0D0
      ZAP = 0.0
      XAP = 0.0
      YAP = 0.0
C
!  ALLOW CHECKING FOR INNER OBSCURATION
!     IF (XN ** 2 + YN ** 2 .GT. 1.0) GO TO 50
!
      RSQ = XN * XN + YN * YN
      OBSCSQ = OBSC * OBSC
      IF (RSQ .GT. 1.D0 .OR. RSQ .LT. OBSCSQ) GO TO 50
C
      IF (NDF .EQ. 0) GO TO 99
!
!  ALLOW ANNULAR ZERNIKE'S
!     CALL ZERNIK (NDF, XN, YN, ZERP, ZERX, ZERY, IER)
!
      IF (OBSC .EQ. 0.D0)
     *   CALL ZERNIK (NDF, XN, YN, ZERP, ZERX, ZERY, IER)
      IF (OBSC .GT. 0.D0)
     *   CALL ANNULR (NDF, OBSC, NNDX, NDXARR, COFMAT,
     *                XN, YN, ZERP, ZERX, ZERY, IER)
      IF (IER .NE. 0) GOTO 99
      DO 10 I = 1, NDF
         XAPD = DEFC (I) * ZERX (I) + XAPD
         YAPD = DEFC (I) * ZERY (I) + YAPD
         ZAPD = DEFC (I) * ZERP (I) + ZAPD
10    CONTINUE
!
!     XAP = DBLE (XAPD + XAPD)
!     YAP = DBLE (YAPD + YAPD)
!     ZAP = DBLE (ZAPD)
!
      XAP = XAPD + XAPD
      YAP = YAPD + YAPD
      ZAP = ZAPD
      GO TO 99
C
50    IER = 1
C
99    CONTINUE
CBUG  WRITE (8, 800) NDF, ZAP, XAP, YAP
      RETURN
800   FORMAT ('-ABZERN ZXY', I5, 1P, 3E15.6)
      END
