!+
!KWIC anenap.f
!
!$Id: anenap.f,v 1.2 2004/03/17 21:23:30 dtn Exp $
! *Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSACV7.0 modification:
!        !  MODIFIED 5/17/89 TO ALLOW R1=R2=0 IF ONLY ONE RAY
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . elminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE ANENAP (R1, R2, PING, P2, IER) !*** SLASHES TAKEN OUT
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    ANENAP FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 01/11/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     10:51:56
C    *
C    ******************************************/
C
C  ESTABLISH A UNIFORM DENSITY RADIAL PATTERN OF POINTS IN AN ANNULUS
C
C  INPUT ARGUMENTS:
C    R1   : R*8 RADIUS OF INNER RING OF ANNULUS IN MM. 0<=R1.
C           R1 = 0 DENOTES A FULL CIRCULAR APERTURE
C    R2   : R*8 RADIUS OF OUTER RING OF ANNULUS IN MM. R2 >= R1
C           R1 = R2 DENOTES A SINGLE RING
C    PING : R*8 # RINGS DESIRED IN FIRST SPOKE
C    P2   : R*8 # SPOKES DESIRED
C
C  OUTPUT ARGUMENT:
C    IER  : INT*4 ERROR CODE
C         : 0 - NO ERROR
C         : 1 - INCORRECT RADII, R1 < 0 OR R2 > R1
C         : 2 - ILLEGAL NUM OF RINGS : R1 = R2 WITH PING NOT 1
C         : 3 - ILLEGAL NUM OF RINGS : R1 < R2 WITH PING <= 1
C
C  OUTPUT VIA LABELED COMMON /PARX/:
C    MING : I*4  NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4  NUMBER OF SPOKES
C    RZER : R*4  INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4  DELTA (R**2) BETWEEN RINGS
C    H2   : R*4  NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    JRAY : I*4  CURRENT RAY NUMBER                 = 0
C    JING : I*4  CURRENT RING NUMBER                = 0
C    MR   : I*4  NUMBER OF RINGS IN CURRENT SPOKE   = 0
C    J2   : I*4  CURRENT SPOKE NUMBER               = 0
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 

C
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !

      DOUBLE PRECISION  R1, R2, PING, P2, R2TOT, RDOUT, RDCEN
C
!  OSAC V7.0 modification:
!  DON'T CHECK FOR R2 .LE. 0.
!      IF (R1 .LT. 0. .OR. R2 .LE. 0. .OR. R2 .LT. R1) GO TO 100
!
      IF (R1 .LT. 0. .OR. R2 .LT. R1) GO TO 100
      MING = PING + 0.1
      M2 = P2 + 0.1
      DR = 0.0
      IF (R1 .EQ. R2) GO TO 50
C BQ, CQ
      IF (MING .LE. 1) GO TO 110
C  CY1
      R2TOT = R2 * R2 - R1 * R1
      RDOUT = MING - 2.D0
      RDCEN = 1.D0
      IF (R1 .EQ. 0.D0) RDCEN = RDCEN + 1.D0 / M2
      DR = R2TOT / (RDCEN + RDOUT)
      GOTO 60
C
C  BQ
50    IF (MING .NE. 1) GO TO 101
C  BY1 OR CY2, VALID CASE OF ONE OR MORE RINGS
60    IER = 0
      JRAY = 0
      JING = 0
      MR = 0
      J2 = 0
      R2NOT0 = R1 * R1
      IF (R2NOT0 .EQ. 0.) R2NOT0 = DR * RDCEN
      RZER = SQRT (R2NOT0)
      H2 = -1.
      GO TO 200
C
C  ERROR CONDITIONS
C
100   IER = 1
C A2, WRONG RADII
      WRITE (8,601) IER
      WRITE (8,600) MING, M2, PING, P2, R1, R2
      GO TO 200
C
C  INCORRECT NUMBER OF RINGS
101   IER = 2
      GO TO 120
C
110   IER = 3
120   CONTINUE
      WRITE (8,602) IER
      WRITE (8,600) MING, M2, PING, P2, R1, R2
200   RETURN
600   FORMAT (/6X, 'MING', 7X, 'M2', 7X, 'PING', 11X, 'P2', 13X, 'R1',
     &        13X, 'R2'/ 2I10, 1P,4D15.6)
601   FORMAT (/'-ANENAP ERROR CODE', I3, ' :WRONG RADII')
602   FORMAT (/'-ANENAP ERROR CODE', I3, ' :INCORRECT NUMBER OF RINGS')
      END
