!+
!KWIC azinlz.f
!
!$Id: azinlz.f,v 1.2 2004/03/17 21:23:30 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . change DPI2 initialization to PARAMETER
!-

      SUBROUTINE AZINLZ
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    AZINLZ FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/20/81
C    *
C    *    UPDATE:   12/22/81
C    *    TIME:     09:58:53
C    *
C    ******************************************/
C
C  INITIALIZE QUANTITIES NEEDED FOR AZIMUTHAL INTEGRATION OF FFT MEMBERS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    M2 : I*4 - NUMBER OF SPOKES
C
C  INPUT VIA LABELED COMMON /TVECTR/ :
C  IF I = SPOKE NUMBER,
C    ITFLG (I) : LOGICAL*1 - .TRUE.  = SOME GOOD RAYS IN SPOKE
C                            .FALSE. = NO GOOD RAYS IN SPOKE
C
C  OUTPUT VIA LABELED COMMON /TVECTR/ :
C  IF I = SPOKE NUMBER,
C    THETA0 (I) : R*4 - AZIMUTHAL ANGLE OF START OF SPOKE REGION
C    IMODE (I)  : I*4 - INTERPOLATION MODE  1 = CONSTANT IN THETA
C                                           2 = LINEAR IN THETA
C                                           3 = QUADRATIC IN THETA
C    I1 (I)     : I*4 - SPOKE NUMBER FOR 1ST INTERPOLATION THETA
C    I2 (I)     : I*4 - SPOKE NUMBER FOR 2ND INTERPOLATION THETA
C    I3 (I)     : I*4 - SPOKE NUMBER FOR 3RD INTERPOLATION THETA
C
      IMPLICIT INTEGER (I-N) 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /TVECTR/ THETA0 (20), IMODE (20), I1 (20), I2 (20),
     1                I3 (20), ITFLG (20)
      DOUBLE PRECISION THETA0
      LOGICAL * 1 ITFLG

      DOUBLE PRECISION DPI2
      PARAMETER      ( DPI2 = 6.28318 53071 79586 48D0 )
C
C
C  LOOP OVER EACH GOOD SPOKE
      DO 900 J = 1, M2
      IF (.NOT. ITFLG (MOD (J - 1, M2) + 1)) GO TO 900
C
C  SELECT CASE ON VALUE OF M2
      IF (M2 .EQ. 1) GO TO 200
      IF (M2 .EQ. 2) GO TO 300
      GO TO 400
C
C  ONLY ONE SPOKE
200   IMODE (J) = 1
      I1 (J) = J
      GO TO 800
C
C  ONLY TWO SPOKES
300   IF (ITFLG (MOD (J, M2) + 1)) GO TO 350
      IMODE (J) = 1
      I1 (J) = J
      GO TO 800
350   IMODE (J) = 2
      I1 (J) = J
      GO TO 800
C
C  MORE THAN TWO SPOKES
400   IF (ITFLG (MOD (M2 + J - 2, M2) + 1)) GO TO 600
      IF (ITFLG (MOD (J, M2) + 1)) GO TO 500
      IMODE (J) = 1
      I1 (J) = J
      GO TO 800
500   IF (ITFLG (MOD (J + 1, M2) + 1)) GO TO 550
      IMODE (J) = 2
      I1 (J) = J
      GO TO 800
550   IMODE (J) = 3
      I1 (J) = J
      GO TO 800
600   IF (ITFLG (MOD (J, M2) + 1)) GO TO 700
      IF (ITFLG (MOD (M2 + J - 3, M2) + 1)) GO TO 650
      IMODE (J) = 2
      I1 (J) = J - 1
      GO TO 800
650   IMODE (J) = 3
      I1 (J) = J - 2
      GO TO 800
700   IMODE (J) = 3
      I1 (J) = J - 1
C
C  MODE AND START-SPOKE-NUMBER ARE SET - FINISH INITIALIZATION
800   I1 (J) = MOD (M2 + I1 (J) - 1, M2) + 1
      I2 (J) = MOD (I1 (J), M2) + 1
      I3 (J) = MOD (I1 (J) + 1, M2) + 1
      THETA0 (J) = (I1 (J) - 1.D0) * DPI2 / M2
900   CONTINUE
      RETURN
      END
