#if 0
#define CPARAM_DEBUG 1
#endif

/*
 * c_paccess_ - fortran interface to parameter interface paccess 
 *              function (a kludge...)
 *
 * Problem:  present incarnation of parameter interface does not have
 *           a fortran interface to paccess; this routine supplies
 *           it.
 *
 * Author:   T. Gaetz
 * Date:     1995 August 07
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include <suplib/str.h>

#include <cxcparam/parameter.h>

#include "config.h"

#ifdef    CPARAM_DEBUG
static FILE *dbgp; /* --- tjg debug --- */
#endif /* CPARAM_DEBUG */

#define C_PACCESS_F77 F77_FUNC_(c_paccess,C_PACCESS)

/* prototype to make gcc happy */
int C_PACCESS_F77(paramfile *pfile, char *pname, int nname);

int
C_PACCESS_F77(paramfile *pfile, char *pname, int nname)
{
  char *pn;
  int   rc;
  /*
   * make a copy of pname, nul-terminate it, and trim off trailing blanks
   */
  pn = (char *)malloc((nname+1) * sizeof(char));
  if ( !pn )
  {
    fprintf( stderr, 
       "saosacLib(c_paccess_): unable to malloc space for string copy\n" );
    exit(1);
  }
  strncpy( pn, pname, nname );
  pn[nname] = '\0';
  str_trunc( pn );
  /*
   * forward to parameter interface function paccess
   */
  rc = paccess( *pfile, pn );
  free(pn);
  return rc;
}
