!+
!KWIC concyl.f
!
!$Id: concyl.f,v 1.2 2004/03/17 21:23:32 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE CONCYL (RO, K, P, S, KP, LP, NORM, KX, LX, KODE)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    CONCYL FORTRAN
C    *    WRITTEN BY PHILIP GRIBOSKY
C    *            ON 07/01/80
C    *
C    *    UPDATE:   09/10/80
C    *    TIME:     13:29:18
C    *
C    ******************************************/
C
C  REFLECTION OF RAY OFF CONICS OF REVOLUTION & CYLINDERS
C  SURFACE EQUATION OF THE FORM :
C         X ** 2 + Y ** 2 = RO ** 2 + 2K * Z - P * Z ** 2
C
C  INPUT ARGUMENTS:
C  RO    : RADIUS OF CYLINDER AT BODY CENTER
C  K     : 1/2 LINEAR TERM IN SURFACE EQUATION
C  P     : CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C  KP    : IV# A POINT ON THE ENTERING RAY
C  LP    : IV# DIRECTION OF ENTERING RAY
C  NORM  : IV# DESIRED FOR OUTER NORMAL AT INTERSECTION
C  KX    : IV# DESIRED FOR INTERSECTION OF RAY WITH CYLINDER
C  LX    : IV# DESIRED FOR DIRECTION OF REFLECTED RAY
C  KODE  : I*4 INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C        KODE = 2  : INTERNAL REFLECTION
C        KODE = 4  : EXTERNAL REFLECTION
C
C  INPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    V# KP AND V# LP
C
C  OUTPUT ARGUMENTS:
C  S     : DISTANCE FROM V# KP TO V# KX
C  KODE  : INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C        KODE = 0  : INCONSISTENT OR TAUTOLOGICAL EQUATION
C        KODE = 1  : INTERNAL REFRACTION
C        KODE = 2  : INTERNAL REFLECTION
C        KODE = 3  : EXTERNAL REFRACTION
C        KODE = 4  : EXTERNAL REFLECTION
C        KODE = 7  : NEGATIVE DISTANCE
C        KODE = 8  : EXCESSIVE ROUND OFF ERROR
C        KODE = 9  : TOO MANY ITERATIONS
C        KODE = 10 : RAY MISSED SURFACE
C        KODE = 11 : UNDETERMINED ERROR ON INPUT TO CONCYL
C        KODE = 12 : UNDETERMINED ERROR
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    V# NORM, V# KX, V# LX
C
C   XR : VFLECT
C
      IMPLICIT DOUBLE PRECISION  (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 
      DIMENSION KRAP(4)
      DATA KRAP /3, 4, 1, 2 /

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION   K, TS
!     DOUBLE PRECISION   K * 8, TS
CBUG  REAL * 4   F, PS, SK, RS, TEL, XL, YL, ZL,  XS, YS, ZS
C             
CBUG  NAMELIST / CONCI / RS, SK, PS, KPN, LPN, NOR, KXN,
CBUG 2  LXN, KOD, A, B, C, TEL, XS, YS, ZS, XL, YL, ZL, D
CBUG  NAMELIST / CONCYT /  N, B, C, RS, TEL, F, TS, XS, YS, ZS
CBUG  NAMELIST / CONCX / KOD, TEL, XL, YL, ZL, XS, YS, ZS, RS
C
C  INITIALIZATION
C
CBUG  PS = P
CBUG  RS = RO
CBUG  KPN = KP
CBUG  LPN = LP
CBUG  NOR = NORM
CBUG  KXN = KX
CBUG  LXN = LX
CBUG  KOD = KODE
CBUG  SK = K
C  XD, YD, ZD : CURRENT POINT ON LINE
      XD = XV(KP)
      YD = YV(KP)
      ZD = ZV(KP)
C
CBUG  XS = XD
CBUG  YS = YD
CBUG  ZS = ZD
C
C  XL, YL, ZL : DIRECTION OF RAY
CBUG  XL = XV (LP)
CBUG  YL = YV (LP)
CBUG  ZL = ZV (LP)
      R2 = RO ** 2
      PZK = P * ZD - K
CBUG  TEL = PZK
      C = XD ** 2 + YD ** 2 - R2 + (PZK - K) * ZD
      B =  XD * XV(LP)  +  YD * YV(LP) + PZK * ZV(LP)
      A = 1.0D0 + (P - 1.0D0) * ZV(LP) ** 2
C  EQUATION IS NOW  A * S ** 2 + 2 * B * S + C = 0
C
CBUG1     CONTINUE
      D = B*B - A*C
CBUG      WRITE (8, CONCI)
      IF (KODE .LT. 1 .OR. KODE .GT. 4) GO TO 640
C
C  CASE STRUCTURE FOR A, B, C, DEGENERACY, AND KODE
C
C  KEY TO CASE IDENTIFIERS
C     A NUMBER FOLLOWING A, B, AND C SIGNIFIES :
C      1 : < 0
C      2 : = 0
C      3 : > 0
C     A NUMBER FOLLOWING K (FOR KODE) SIGNIFIES :
C      2 : =< 2
C      4 : > 2
C
      IF (D .LT. 0.0D0) GO TO 630
C
      IF (A) 100, 200, 300
C
C  CASE A1 : A < 0
100   CONTINUE
      IF (C) 110, 140, 170
110   CONTINUE
C  CASE A1C1 : A < 0 AND C < 0
      IF (B) 620, 650, 120
120   CONTINUE
C  CASE A1C1B3 : A < 0, C < 0, AND B > 0
      IF (KODE .LE. 2) GO TO 130
C  CASE A1C1B3K2 : A < 0, C < 0, B > 0, AND KODE =< 2
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 400
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      GO TO 430
130   CONTINUE
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 410
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      GO TO 420
140   CONTINUE
C  CASE A1C2 : A < 0 AND C = 0
      IF (KODE .LE. 2) GO TO 150
C  CASE A1C2K4 : A < 0, C = 0, AND KODE > 2
      IF (B .LE. 0.0D0) GO TO 160
      S = -(B + B)/A
      GO TO 500
150   CONTINUE
C  CASE A1C2K2 : A < 0, C = 0, AND KODE =< 2
      IF (B .GE. 0.0D0) GO TO 160
      GO TO 610
160   CONTINUE
      S = 0.0D0
      GO TO 500
170   CONTINUE
C  CASE A1C3 : A < 0 AND C > 0
      IF (KODE .GT. 2) GO TO 180
      GO TO 610
180   CONTINUE
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 400
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      IF (B) 420, 650, 430
C
C  CASE A2 : A = 0
200   CONTINUE
C  QUADRATIC EQUATION IS ACTUALLY LINEAR
      IF (C) 210, 230, 260
210   CONTINUE
C  CASE A2C1 : A = 0 AND C < 0
      IF (B) 620, 600, 220
220   CONTINUE
C  CASE A2C1B3 : A = 0, C < 0, AND B > 0
      IF (KODE .GT. 2) GO TO 610
      S = -C/(B + B)
      GO TO 500
230   CONTINUE
C  CASE A2C2 : A = 0 AND C = 0
      IF (B) 240, 600, 250
240   CONTINUE
C  CASE A2C2B1 : A = 0, C = 0, AND B < 0
      IF (KODE .LE. 2) GO TO 610
      S = 0.0D0
      GO TO 500
250   CONTINUE
C  CASE A2C2B3 : A = 0, C = 0, AND B > 0
      IF (KODE .GT. 2) GO TO 610
      S = 0.0D0
      GO TO 500
260   CONTINUE
C  CASE A2C3 : A = 0 AND C > 0
      IF (B) 270, 600, 620
270   CONTINUE
C  CASE A2C3B1 : A = 0, C > 0, AND B < 0
      IF (KODE .LE. 2) GO TO 610
      S = -C/(B + B)
      GO TO 500
C
C  CASE A3 : A > 0
300   CONTINUE
      IF (C) 310, 320, 350
310   CONTINUE
C  CASE A3C1 : A > 0 AND C < 0
      IF (KODE .GT. 2) GO TO 610
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 410
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      IF (B) 430, 650, 420
320   CONTINUE
C  CASE A3C2 : A > 0 AND C = 0
      IF (KODE .LE. 2) GO TO 330
      IF (B .GT. 0.0D0) GO TO 610
      GO TO 340
330   CONTINUE
C  CASE A3C2K2 : A > 0, C = 0, AND KODE =< 2
      IF (B .GE. 0.0D0) GO TO 340
      S = -(B + B)/A
      GO TO 500
340   CONTINUE
C  CASE A3C2K4 : A > 0, C = 0, AND KODE > 2
      S = 0.0D0
      GO TO 500
350   CONTINUE
C  CASE A3C3 : A > 0 AND C > 0
      IF (B) 360, 650, 620
360   CONTINUE
C  CASE A3C3B1 : A > 0, C > 0, AND B < 0
      IF (KODE .LE. 2) GO TO 370
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 400
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      GO TO 420
370   CONTINUE
C  IS THE QUADRATIC EQUATION IN S DEGENERATE ?
      IF (ABS(DBLE(A*C)) .GT. .004*(DBLE(B*B))) GO TO 410
C  THE QUADRATIC EQUATION IN S IS DEGENERATE
      GO TO 430
C
C  CALCULATE S AND PROCEED
C
400   CONTINUE
C  THE QUADRATIC EQUATION IN S IS NOT DEGENERATE
C  USE THE DAN ROOT OF THE QUADRATIC EQUATION
      D = DSQRT(D)
      S = -(D + B)/A
      GO TO 500
C
410   CONTINUE
C  THE QUADRATIC EQUATION IN S IS NOT DEGENERATE
C  USE THE DAP ROOT OF THE QUADRATIC EQUATION
      D = DSQRT(D)
      S = (D - B)/A
      GO TO 500
C
420   CONTINUE
C  NEAR : THE QUADRATIC EQUATION IN S IS DEGENERATE
C  USE THE MACLAURIN APPROXIMATION OF THE NEAR ROOT
      S = 0.25D0/B
      C = C*S
      D = C + C
      S = S + S
      S = D*A*(S + S)
      S = -(D + C*(S + S*(S + S**2*(1.25 + 1.75*DBLE(S)))))
      GO TO 500
C
430   CONTINUE
C  FAR : THE QUADRATIC EQUATION IN S IS DEGENERATE
C  USE THE MACLAURIN APPROXIMATION OF THE FAR ROOT
      S = 0.25D0/B
      C = C*S
      D = C + C
      S = S + S
      S = D*A*(S + S)
      S = (D + C*(S + S*(S + S**2*(1.25 + 1.75*DBLE(S))))) - (B + B)/A
C
C  TEST INTERSECTION AND REFLECT RAY
C
500    CONTINUE
CBUG  F = C + S*(B + B + A*S)
C
C  D     : INCREMENTAL DISTANCE
      D = S
      KOD = 9
C
      DO 510 N = 1, 5
      XD = XD + D * XV(LP)
      YD = YD + D * YV(LP)
      ZD = ZD + D * ZV(LP)
C  XD, YD, ZD : INTERSECTION
C
C  TEST FOR POINT BEING REALLY ON SURFACE
      PZK = P * ZD - K
      B =  XD * XV(LP)  +  YD * YV(LP) + PZK * ZV(LP)
      C = XD ** 2 + YD ** 2 - R2 + (PZK - K) * ZD
C
C  TS    : SURFACE TEST LIMIT
      TS = (DBLE(XD ** 2 + YD ** 2 + ZD ** 2 + R2) + .004) * 1.E-15
CBUG  TEL = D
CBUG  RS = S
CBUG  XS = XD
CBUG  YS = YD
CBUG  ZS = ZD
C
CBUG  WRITE (8, CONCYT)
      IF (ABS (DBLE (C)) .LT. TS) GO TO 530
C
C  CORRECTION TERM MUST NOT JUMP FAR
      IF (ABS (DBLE(C)+DBLE(C)) .GT. ABS(DBLE(D)*DBLE(B))) GO TO 520
      D = -C / (B + B)
      S = S + D
CBUG  F = C + D*(B + B + A*D)
C
510   CONTINUE
C  KODE = 9 : TOO MANY ITERATIONS
      KOD = 9
      WRITE (8, 1400)
      WRITE (8, 1500) KODE, XD, YD, ZD, R, P, K, PZK, A, B, C, D
      GO TO 540
C
520   CONTINUE
C  KODE = 8 : EXCESSIVE ROUND-OFF ERROR
      KOD = 8
      WRITE (8, 1300)
      WRITE (8, 1500) KODE, XD, YD, ZD, R, P, K, PZK, A, B, C, D
      GO TO 540
C
530    CONTINUE
      KOD = KODE
C
540   CONTINUE
      IF (KODE .EQ. KOD) GO TO 550
      KODE = KOD
      GO TO 700
C
550   CONTINUE
      IF (S .LT. 0.0D0) GO TO 620
C  INTERSECTION FOUND.  TRANSFER TO (KX)
      XV(KX) = XD
      YV(KX) = YD
      ZV(KX) = ZD
C
CBUG  XS = XD
CBUG  YS = YD
CBUG  ZS = ZD
C
      XV(NORM) = XD
      YV(NORM) = YD
      ZV(NORM) = P * ZD - K
      CALL VFLECT (LP, NORM, LX)
      GO TO 700
C
C  SET KODE AND EXIT
C
600   CONTINUE
C  KODE = 0 : INCONSISTENT OR TAUTOLOGICAL EQUATION
      WRITE (8, 1200)
      XL = XV(LP)
      YL = YV(LP)
      ZL = ZV(LP)
      WRITE (8, 1600) KODE,XD,YD,ZD,XL,YL,ZL,R,P,K,PZK,A,B,C,D
      KODE = 0
      GO TO 700
C
610   CONTINUE
C  KODE = KRAP(KODE) : WRONG SIDE OF THE SURFACE
      KODE = KRAP(KODE)
      GO TO 700
C
620   CONTINUE
C  KODE = 7 : NEGATIVE PATH LENGTH
      KODE = 7
      GO TO 700
C
630   CONTINUE
C  KODE = 10 : RAY MISSES THE SURFACE
      KODE = 10
      GO TO 700
C
640   CONTINUE
C  KODE = 11 : UNDETERMINED ERROR ON INPUT TO CONCYL
      WRITE (8, 1000)
      WRITE (8, 1500) KODE, XD, YD, ZD, R, P, K, PZK, A, B, C, D
      KODE = 11
      GO TO 700
C
650   CONTINUE
C  KODE = 12 : UNDETERMINED ERROR
      WRITE (8, 1100)
      XL = XV(LP)
      YL = YV(LP)
      ZL = ZV(LP)
      WRITE (8, 1600) KODE,XD,YD,ZD,XL,YL,ZL,R,P,K,PZK,A,B,C,D
      KODE = 12
C
700   CONTINUE
CBUG  KOD = KODE
CBUG  TEL = D
CBUG  RS  = S
CBUG  XL  = XV (LX)
CBUG  YL  = YV (LX)
CBUG  ZL =  ZV (LX)
CBUG  WRITE (8, CONCX)
      RETURN
1000  FORMAT ('- UNDETERMINED ERROR ON INPUT TO CONCYL ')
1100  FORMAT ('- CONCYL ERROR : UNDETERMINED ERROR ')
1200  FORMAT ('- CONCYL ERROR : INCONSISTENT OR TAUTOLOGICAL EQUATION ')
1300  FORMAT ('- CONCYL ERROR : EXCESSIVE ROUND-OFF ERROR ')
1400  FORMAT ('- CONCYL ERROR : TOO MANY ITERATIONS ')
1500  FORMAT ('- KODE = ',I10,' XD = ',1P,D15.6,' YD = ',1P,D15.6,
     1      ' ZD = ',1P,D15.6,' R = ',1P,D15.5,' P = ',1P,D15.6,/,
     2      ' K = ',1P,D15.6,' PZK = ',1P,D15.5,' A = ',1P,D15.5,
     3      ' B = ',1P,D15.6,' C = ',1P,D15.6,' D = ',1P,D15.6)
1600  FORMAT ('- KODE = ',I10,' XD = ',1P,D15.6,' YD = ',1P,D15.6,
     1      ' ZD = ',1P,D15.6,' XL = ',1P,D15.6,' YL = ',1P,D15.6,
     2      /,' ZL = ',1P,D15.6,' R = ',1P,D15.5,' P = ',1P,D15.6,
     3      ' K = ',1P,D15.6,' PZK = ',1P,D15.5,' A = ',1P,D15.5,
     4      /,' B = ',1P,D15.6,' C = ',1P,D15.6,' D = ',1P,D15.6)
CBUG  DEBUG TRACE
CBUG  AT 1
CBUG  TRACE ON
      END
