!+
!KWIC csin.f
!
!$Id: csin.f,v 1.2 2004/03/17 21:23:32 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . OSAC V7.0 modification:  rename from ccsin to csin
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE CSIN (IVS1, IVBCS)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    CSIN FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C  PURPOSE : CONVERT COMPLEX POLARIZATION AMPLITUDE VECTORS TO BCS
C
C  INPUT ARGUMENTS:
C    IVS1:  IV# OF INCOMING UNIT VECTOR
C    IVBCS: IV# OF START OF ROTATION MATRIX FROM STD TO BCS
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    IV# IVS1, IVBCS-(IVBCS+2)
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    IV#'S 100-103: C AND S VECTORS IN STD (INPUT) AND BCS (OUTPUT)
C                   (ORDER: RE(C), IM(C), RE(S), IM(S)
C    IV#'S 104-150: RESERVED, DEFINED AS FOLLOWS:
C          104-107: PING PONG BUFFER "B" FOR C AND S
C          108-111: PING PONG BUFFER "C" FOR C AND S
C          112-113: X1 AND Y1 UNIT VECTORS (OUTPUT)
C          114-116: T-MATRIX (XY1-STD) (OUTPUT)
C          117: PERPENDICULAR UNIT VECTOR (NOT USED HERE)
C          118-119: PARALLEL UNIT VECTORS 1 AND 2 (NOT USED HERE)
C          120-122: (PERPENDICULAR o PERPENDICULAR) (NOT USED HERE)
C          123-125: (PARALLEL#2 o PARALLEL#1) (NOT USED HERE)
C          126-128: REAL PART OF T-MATRIX (REFL IN BCS) (NOT USED HERE)
C          129-131: IMAG PART OF T-MATRIX (REFL IN BCS) (NOT USED HERE)
C          132-134: T-MATRIX (STD-XY2) (NOT USED HERE)
C
C  XR: MVMULT, PZXY, VSTOR
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/rain.h'      !
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C
C  READ C AND S FROM COMMON INTO BUFFER A (IV# 100-103)
C
      CALL VSTOR (100, DREAL (C2COMP (1)), DREAL (C2COMP (2)), 0.D0)
      CALL VSTOR (101, DIMAG (C2COMP (1)), DIMAG (C2COMP (2)), 0.D0)
      CALL VSTOR (102, DREAL (S2COMP (1)), DREAL (S2COMP (2)), 0.D0)
      CALL VSTOR (103, DIMAG (S2COMP (1)), DIMAG (S2COMP (2)), 0.D0)
C
C  DEFINE THE X1 AND Y1 UNIT VECTORS
C
      CALL PZXY (IVS1, 112, 113)
C
C  TRANSPOSE AND ARRANGE THEM INTO THE T-MATRIX (XY1-STD)
C
      CALL VSTOR (114, XV (112), XV (113), 0.D0)
      CALL VSTOR (115, YV (112), YV (113), 0.D0)
      CALL VSTOR (116, ZV (112), ZV (113), 0.D0)
C
C  MULTIPLY C AND S BY THIS T-MATRIX, PUTTING THE RESULTS IN BUFFER B
C
      DO 120 I = 100, 103
      CALL MVMULT (114, I, I + 4)
120   CONTINUE
C
C  CONVERT THE STD RESULTS IN BUFFER B TO BCS RESULTS IN BUFFER A
C
      DO 140 I = 100, 103
      CALL MVMULT (IVBCS, I + 4, I)
140   CONTINUE
      RETURN
      END
