
!**** file: dbg_rt.f        <> a0.0a <> 1993-Apr-23

!+**********************************************************************
      subroutine dbg_rt( lun, msg, idlo, idhi )
!***********************************************************************
!
!kwic dbg_rt  --- diagnostic output for OSAC
!
!  arguments:
!     lun        -- i , i  -- fortran unit number for output 
!     msg        -- ca, i  -- descriptive string
!     idlo       -- i , i  -- lower ray # for output
!     idhi       -- i , i  -- upper ray # for output
!
!  comments:
!
!     Input via labeled common /parm/:
!       GEN (3) : ZOFF - z offset of focal plane
!
!     Input via labeled common /parx/:
!       KURF : I*4 - surface number
!       NS   : I*4 - number of surfaces in system
!
!     Input via labeled common /rain/:
!       FOP  : fractional portion of path length
!       IOP  : integer portion of path length
!       JRAY : current ray number
!       JING : current ring number
!       J2   : current spoke number
!       KODE : ray status code (see chex output)
!       W    : relative intensity of ray
!       Q3   : 2nd derivative matrix of surface
!       C2COMP: C*16 - 2-d complex amplitude of cos (omega t) polarization
!       S2COMP: C*16 - 2-d complex amplitude of sin (omega t) polarization
!
!     Input via labeled common /xcomp/, /ycomp/, /zcomp/:
!       V#5 : position of ray intersection
!       V#6 : direction of ray after reflection
!
!     if any...
!
!  history:
!     96-Jun-05[T. Gaetz]
!        . /SWITCH/: add save statement; move to include file
!        . /RAIN/:   add save statement; move to include file
!     96-Jun-05[T. Gaetz]
!        . /SUMRY/:  add save statement; move to include file
!        . /RAIN/:   add save statement; move to include file
!     95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!     93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!     93-Apr-23[T. Gaetz] original version
!-
      implicit double precision (a-h,o-z)
      IMPLICIT INTEGER (I-N) 

!PUBLIC ----------------------------------------------------------------

!---  passed variables...
      INTEGER       lun
      CHARACTER*(*) msg
      INTEGER       idlo, idhi

!USES 

!PRIVATE ---------------------------------------------------------------

!---  fixed parameters...

!---  global variables...

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      ! 
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION     pos(3), dir(3)
      INTEGER * 4  M (5)

!---  local variables...
      CHARACTER*(8) str

!CODE dbg_rt -----------------------------------------------------------

      if ( jray .lt. idlo  .or.  jray .gt. idhi ) return

      IN10 = 1.0E8 * W + 0.5
      M(1) = JRAY
      M(2) = JING
      M(3) = J2
      M(4) = KODE
      M(5) = IN10

      write ( lun , * ) ' '

      write ( lun , '(a,5i10)' ) msg, jray, jing, j2, kode, in10

      pos(1) = XV(5)
      pos(2) = YV(5)
      pos(3) = ZV(5)
      dir(1) = XV(6)
      dir(2) = YV(6)
      dir(3) = ZV(6)

      write ( lun , * ) 'iop     ' , iop, fop
      do j=1,20
         str = 'v        '
         write ( str(2:3) , '(i2)' ) j
         write ( lun , * ) str , xv(j), yv(j), zv(j)
      end do
      write ( lun , * ) 'c2comp  ' , c2comp
      write ( lun , * ) 's2comp  ' , s2comp

      END

!**** file: vwrite.f        <> a0.0a <> 1993-Apr-23

!+**********************************************************************
      subroutine vwrite( str, jr, js, iv1, iv2, kkode )
!***********************************************************************
!
!kwic vwrite  --- diagnostic output
!
!  arguments:
!     str1       -- ca, i  -- identifying string
!     jr         -- i , i  -- ring number
!     js         -- i , i  -- spoke number
!     iv1        -- i , i  -- vector 1 index
!     iv2        -- i , i  -- vector 2 index
!     kkode      -- i , i  -- OSAC kode
!
!  comments:
!
!  history:
!     96-Jun-05[T. Gaetz]
!      . /RAIN/:  add save statement; move to include file
!     93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!     93-Apr-23[T. Gaetz] original version
!-
      implicit none

!PUBLIC ----------------------------------------------------------------

!---  passed variables...
      CHARACTER*(*) str
      INTEGER       jr, js, iv1, iv2, kkode 

!USES 

!PRIVATE ---------------------------------------------------------------

!---  fixed parameters...

!---  global variables...

      include 'saosacLib/rain.h'      ! 
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

!CODE vwrite -----------------------------------------------------------

      write ( 81, '(a,t10,4i8)' ) str, jray, jr, js, kkode
      write ( 81, '(t10,i4,1p,3e20.12)' ) iv1, xv(iv1), yv(iv1), zv(iv1)
      write ( 81, '(t10,i4,1p,3e20.12)' ) iv2, xv(iv2), yv(iv2), zv(iv2)

      END
