/*
 * debug_init_ - parses debug input string tokens
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <tracefct/tracefct.h>
#include <tracefct/exiterrvals.h>

#include "config.h"

static int charptr_comp(const void *s1, const void *s2);

#define DELIM ",: "

#define DEBUG_INIT_F77 F77_FUNC_(debug_init,DEBUG_INIT)
#define DBFLAG_F77 F77_FUNC(dbflag,DBFLAG)

static size_t nflags;
static char **flags;

/* prototye to make gcc happy */
void DEBUG_INIT_F77(char *debug_flags);

void
DEBUG_INIT_F77(char *debug_flags)
{
  char *start, *end, **f;

  tf_enter("debug_init");

  /* determine number of flags */
  end = debug_flags;
  end[ 255 ] = '\0';  
  nflags = 0;
  do
  {
    /* find start of token */
    start = end + strspn(end, DELIM);
    end = start + strcspn(start, DELIM);
    nflags++;
  } while (start != end);
  nflags--;

  if (nflags)
  {
    if ((flags = (char **) malloc(nflags * sizeof(char *))) == NULL)
       tf_exit(ExitERR_alloc, "unable to allocate %d debug flags", nflags);
    start = strtok(debug_flags, DELIM);
    f = flags;
    while (start)
    {
      *f++ = start;
      start = strtok(NULL, DELIM);
    };
    qsort((void *) flags, nflags, sizeof(char *), charptr_comp);
  }

  tf_leave();
}


/* prototye to make gcc happy */
int DBFLAG_F77( char *);

int
DBFLAG_F77(char *dbf)
{
   return nflags && bsearch(&dbf, flags, nflags, sizeof(char *), charptr_comp);
}

static int
charptr_comp(const void *s1, const void *s2)
{
  return strcmp(*((char **)s1), *((char **)s2));
}
