!+
!KWIC dedsum.f
!
!$Id: dedsum.f,v 1.2 2004/03/17 21:23:32 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . convert deg initialization to fortran parameter statement;
!        increase precision of named constant:
!           57.295779513082320876798155d0 instead of 57.29578
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!        !  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!        !  EVERY TERM BEING MULTIPLIED BY A COSINE
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-
!
!  UPDATED 2/26/88 TO CHANGE COMMON /AMNMX/; SHOW
!  OF FULL LARGE AMPLITUDE SCATTER CALCULATIONS MADE; AND
!  GET RID OF IRGLG ARGUMENT, SINCE REFLECTIVITY VARIATIONS
!  ARE BEING SCRAPPED
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 12/22/88 TO FIX A BUG WHICH CAUSED "NO CALCULATIONS"
!  TO BE PRINTED WHEN ALL CALCULATIONS WERE NON-TAYLOR BUT ALSO
!  NON-LARGE-AMPLITUDE THEORY
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!        SUBROUTINE DEDSUM (IRFLG)
      SUBROUTINE DEDSUM
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DEDSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/23/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:05:01
C    *
C    ******************************************/
C
C  WRITE SUMMARY REPORTS TO # 6 AND # 8
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUR VIA LABELED COMMON /RAIN/ :
C    JRAY : I*4 - CURRENT RAY NUMBER
C
C  INPUT VIA LABELED COMMON /SUMRY/ :
C    WS1   : WEIGHT OF UNATTENUATED RAYS AT FOCAL PLANE
C    WS2   : WEIGHT OF STREHL-ATTENUATED RAYS AT F.P.
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS AT FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (9, KURF) : LOGICAL*1 - XRAY SURFACE SWITCH
C
C  INPUT VIA LABELED COMMON /AMNMX/ :
C    ARGMAX (1, I, J) : R*4 - MAX VALUE OF V**2 FOR NON-GRATING, OR
C                             MAX U-LOBE NUMBER FOR GRATING SURFACE
C    ARGMAX (2, I, J) : R*4 - MAX V-LOBE NUMBER FOR GRATING SURFACE
C    GRAZMN (J)    : R*4 - MINIMUM SIN OF GRAZING ANGLE
C    GRAZMX (J)    : R*4 - MAXIMUM SIN OF GRAZING ANGLE
C    VZSIMX (I, J) : R*4 - MAXIMUM VALUE OF VZ**2 * SIGMA**2
C    NCALC (I, J)  : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          USING GRATING METHOD OR TAYLOR APPROX
C    NCALC1 (I, J) : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          NOT USING TAYLOR APPROXIMATION
C    NCALC2 (I, J) : I*4 - NUMBER OF RAY-SURFACE CALCULATIONS PERFORMED
C                          USING FULL LARGE AMPLITUDE SCATTER THEORY
C    NDEFS         : I*4 - NUMBER OF ROUGHNESS DEFINITIONS USED
C    NAREAS (J)    : I*4 - NUMBER OF ROUGHNESS AREAS ON SURFACE
C
C  INPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID : R*4 - ARRAY OF PIXEL WEIGHTS
C
C  INPUT VIA LABELED COMMON /LIMITS/ :
C    NTABG : I*4 - NUMBER OF ENTRIES IN G(V**2) LOOK-UP TABLE
C    NTABF : I*4 - # OF ENTRIES IN F(VZ**2*SIG**2) TABLE
C    NTABR : I*4 - # OF ENTRIES IN REFLECTIVITY(SIN THETA) TABLE
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZLAM : R*4 - SYSTEM WAVELENGTH
C
C  INPUT VIA LABELED COMMON /SCLICO/ :
C  IF J = SURFACE NUMBER AND K = ROUGHNESS AREA NUMBER, THEN
C    SCLIM (1 TO 5, J, K) : R*4 - ROUGHNESS AREA BOUNDARY PARAMETERS
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C  IF J = ROUGHNESS DEFINITION NUMBER, THEN
C    SDEF (1 TO 20, J) : R*4 - ROUGHNESS DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (1)                  : R*8 - PIXEL ARRAY CENTER X COORD
C    FOGR (2)                  : R*8 - PIXEL ARRAY CENTER Y COORD
C    FOGR (3)                  : R*8 - PIXEL ARRAY X LENGTH
C    FOGR (4)                  : R*8 - PIXEL ARRAY Y LENGTH
C    FOGR (5)                  : R*8 - NUMBER OF PIXELS IN X DIRECTION
C    FOGR (6)                  : R*8 - NUMBER OF PIXELS IN Y DIRECTION
C    V2TAB (1 TO NTABG + 1, J) : R*4 - VALUES OF V**2
C    GTAB (1 TO NTABG, J)      : R*4 - VALUES OF G(V**2)
C    GTAB1 (1 TO NTABG, J)     : R*4 - PROCESS # 1 COMPONENTS OF GTAB
C    GTAB2 (1 TO NTABG, J)     : R*4 - PROCESS # 2 COMPONENTS OF GTAB
C    GTAB3 (1 TO NTABG, J)     : R*4 - PROCESS # 3 COMPONENTS OF GTAB
C    STHTAB (1 TO NTABR + 1)   : R*4 - VALUES OF SIN-GRAZ-ANG
C    REFTAB (1 TO NTABR)       : R*4 - VALUES OF REFL(SIN-GRAZ-ANG)
C    SIGSQ (1 TO 3, J)         : R*4 - VALUES OF SIGMA**2 FOR EACH
C                                      ROUGHNESS PROCESS 1 TO 3
C    ACCG                      : R*4 - ACCURACY OF G(V**2) TABLE
C    ACCR                      : R*4 - ACCURACY OF REFL(THETA) TABLE
C    ACCF                      : R*4 - ACCURACY OF F(VZ**2*SIG**2) TABLE
C
C  OUTPUT VIA # 6 AND # 8 :
C    SCATTER CALCULATION SUMMARY REPORT
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /FPGRCO/ FPGRID (1)
      COMMON /LIMITS/ NAREA, NDEFN, NDTOT, NGRID, NTABG, NTABR, NTABF
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SCLICO/ SCLIM (5, 21, 1)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
!
!      LOGICAL * 1 IRFLG
!
      double precision deg
      parameter      ( deg = 57.295779513082320876798155d0 )
C
C  WRITE SYSTEM INFORMATION
!     IF (LSW0 (1)) GO TO 120
      CALL INCLIN (4)
      WRITE (8, 8000)
!     GO TO 140
!120  CALL INCLIN (4)
!     WRITE (8, 8020)
140   NX = FOGR (5)
      NY = FOGR (6)
      SCAT = 0.
      ITOP = NX * NY
      DO 150 I = 1, ITOP
      SCAT = SCAT + FPGRID (I)
150   CONTINUE
      CALL INCLIN (12)
      WRITE (8, 8040) NS, ZLAM, (FOGR (I), I = 1, 4), NX, NY,
     1                JRAY, LEFT2
      WRITE (8, 8050) WS1, WS2, SCAT
      DYNG = (1. - ACCG) ** (- NTABG)
      DYNF = (1. - ACCF) ** (- NTABF)
      CALL INCLIN (7)
      WRITE (8, 8060) ACCG, DYNG, ACCF, DYNF, VZSTAB (NTABF)
!
!      IF (.NOT. IRFLG) GO TO 200
!      DYNR = (1. - ACCR) ** (- NTABR)
!      CALL INCLIN (7)
!      WRITE (8, 8080) GEN (5), GEN (6), ACCR, DYNR,
!     1                STHTAB (NTABR), REFTAB (NTABR)
!
C
C  WRITE INFORMATION FOR EACH ROUGHNESS METHOD
200   DO 580 I = 1, NDEFS
      NSYS = SDEF (1, I)
      NLINE = 13
      IF (NSYS .EQ. 7) NLINE = 10 + SDEF (2, I)
      CALL INCLIN (NLINE)
      WRITE (8, 8100) I
!
!  ALLOW THREE MORE METHODS, AND ONE MORE AGAIN
!      GO TO (211, 212, 213, 214, 215, 216, 217, 218), NSYS
!      GO TO (211, 212, 213, 214, 215, 216, 217, 218,
!     *       219, 220, 221), NSYS
!
      GO TO (211, 212, 213, 214, 215, 216, 217, 218,
     *       219, 220, 221, 222), NSYS
211   WRITE (8, 8120) (SDEF (J, I), J = 2, 5), (SIGSQ (J, I), J = 1, 2)
      GO TO 540
212   WRITE (8, 8140) (SDEF (J, I), J = 2, 5), (SIGSQ (J, I), J =1, 2)
      GO TO 540
213   WRITE (8, 8160) (SDEF (J, I), J = 2, 7), (SIGSQ (J, I), J =1, 3)
      GO TO 540
214   WRITE (8, 8180) (SDEF (J, I), J = 2, 7), (SIGSQ (J, I), J =1, 3)
      GO TO 540
215   WRITE (8, 8200) (SDEF (J, I), J = 2, 5), (SIGSQ (J, I), J =1, 2)
      GO TO 540
216   WRITE (8, 8220) (SDEF (J, I), J = 2, 3), SIGSQ (1, I)
      GO TO 540
217   NSEGS = SDEF (2, I)
      WRITE (8, 8240) NSEGS
      DO 2175 K = 1, NSEGS
      JBOT = 3 * K
      JTOP = JBOT + 2
      WRITE (8, 8260) K, (SDEF (J, I), J = JBOT, JTOP)
2175  CONTINUE
      GO TO 540
218   WRITE (8, 8270) (SDEF (J, I), J = 2, 6), (SIGSQ (J, I), J =1, 2)
      GO TO 540
219   WRITE (8, 8272) (SDEF (J, I), J = 2, 7), (SIGSQ (J, I), J =1, 2)
      GO TO 540
220   WRITE (8, 8274) (SDEF (J, I), J = 2, 7), (SIGSQ (J, I), J =1, 2)
      GO TO 540
221   WRITE (8, 8276) (SDEF (J, I), J = 2, 7), (SIGSQ (J, I), J =1, 2)
      GO TO 540
222   WRITE (8, 8278) (SDEF (J, I), J = 2, 4), SIGSQ (1, I)
C
540   SIG2 = SIGSQ (1, I) + SIGSQ (2, I) + SIGSQ (3, I)
      WRITE (8, 8280) SIG2
      IF (NSYS .EQ. 8) GO TO 560
      WRITE (8, 8110) V2TAB (NTABG, I), GTAB (1, I), GTAB (NTABG, I)
      GO TO 580
C
560   NUMAX = SDEF (7, I)
      NVMAX = SDEF (8, I)
      WRITE (8, 8115) NUMAX, NVMAX
580   CONTINUE
C
C  WRITE INFORMATION FOR EACH SURFACE
      DO 880 I = 1, NS
C  (CALCULATE NUMBER OF LINES TO BE PRINTED)
      NLINE = 5
      IF (NAREAS (I) .EQ. 0) GO TO 680
      NSUB = 3
!
!      IF (IRFLG) NSUB = NSUB + 1
!
      NLINE = NLINE + NAREAS (I) * NSUB
      DO 660 J = 1, NDEFS
!  (ALLOW FOR FULL LARGE AMPLITUDE COUNT (AND FIX A BUG ON 12/22/88))
      IF (NCALC (J, I) .EQ. 0 .AND. NCALC1 (J, I) .EQ. 0. .AND.
     *    NCALC2 (J, I) .EQ. 0) GO TO 640
      NLINE = NLINE + 4
!  (NEXT STATEMENT ALLOWS FOR OUTPUTING MAX VZ**2*SIGMA**2 )
      IF (NCALC1 (J, I) .NE. 0 .OR. NCALC2 (J, I) .NE. 0)
     *    NLINE = NLINE + 1
!  (NEXT STATEMENT, WHICH IS NEW, REMOVES A LINE IF ALL WAS DONE WITH
!  FULL LARGE AMPLITUDE, SO THAT MAX V**2 IS NOT SHOWN)
      IF (NCALC (J, I) .EQ. 0 .AND. NCALC1 (J, I) .EQ. 0)
     *    NLINE = NLINE - 1
      GO TO 660
640   NLINE = NLINE + 2
660   CONTINUE
680   CALL INCLIN (NLINE)
C  (NOW OUTPUT PARAMETERS)
      WRITE (8, 8300) I
      WRITE (8, 8340) NAREAS (I)
      IF (NAREAS (I) .EQ. 0) GO TO 880
!
!      IF (.NOT. IRFLG) GO TO 720
!      GMIN = DEG * ASIN (GRAZMN (I))
!      GMAX = DEG * ASIN (GRAZMX (I))
!      WRITE (8, 8320) GMIN, GMAX
!
720   JTOP = NAREAS (I)
      DO 760 J = 1, JTOP
      NDEF = SCLIM (1, I, J)
!     IF (LSW0 (1)) GO TO 740
      IF (LSW (9, I)) GO TO 740
      WRITE (8, 8360) J, NDEF, (SCLIM (K, I, J), K = 2, 5)
      GO TO 760
740   WRITE (8, 8380) J, NDEF, (SCLIM (K, I, J), K = 2, 5)
760   CONTINUE
C  (LOOP FOR EACH ROUGHNESS METHOD AT THIS SURFACE)
      DO 860 J = 1, NDEFS
!  (ALLOW FOR FULL LARGE AMPLITUDE COUNT)
      IF (NCALC (J, I) .EQ. 0 .AND. NCALC1 (J, I) .EQ. 0 .AND.
     *    NCALC2 (J, I) .EQ. 0) GO TO 850
      IF (SDEF (1, J) .EQ. 8.) GO TO 820
!  (DON'T OUTPUT MAX V**2 IF ALL WAS FULL LARGE AMPLITUDE)
      IF (NCALC (J, I) .NE. 0 .OR. NCALC1 (J, I) .NE. 0)
     * WRITE (8, 8400) J, ARGMAX (1, J, I), NCALC (J, I), NCALC1 (J, I),
     *                 NCALC2 (J, I)
      IF (NCALC (J, I) .EQ. 0 .AND. NCALC1 (J, I) .EQ. 0)
     * WRITE (8, 8410) J, NCALC (J, I), NCALC1 (J, I),
     *                 NCALC2 (J, I)
      GO TO 830
820   WRITE (8, 8420) J, (ARGMAX (K, J, I), K = 1, 2), NCALC (J, I)
830   IF (NCALC1 (J, I) .EQ. 0 .AND. NCALC2 (J, I) .EQ. 0) GO TO 860
      WRITE (8, 8460) VZSIMX (J, I)
      GO TO 860
850   WRITE (8, 8480) J
860   CONTINUE
880   CONTINUE
C
      RETURN
C
8000  FORMAT (/ T40, 'SCATTER SUMMARY REPORT' /
     1          T40, '----------------------' /)
!8020 FORMAT (/ T21, 'SCATTER SUMMARY REPORT FOR X-RAY SYSTEM' /
!    1          T21, '---------------------------------------' /)
8040  FORMAT ('  NUMBER OF SURFACES :', T40, I12 /
     1        '  SYSTEM WAVELENGTH :', T40, 1P,E12.5 /
     2        '  PIXEL ARRAY CENTER X COORD :', T40, 1P,D12.5 /
     3        '  PIXEL ARRAY CENTER Y COORD :', T40, 1P,D12.5 /
     4        '  PIXEL ARRAY X LENGTH :', T40, 1P,D12.5 /
     5        '  PIXEL ARRAY Y LENGTH :', T40, 1P,D12.5 /
     6        '  NUMBER OF PIXELS IN X DIRECTION :', T40, 0P,I12 /
     7        '  NUMBER OF PIXELS IN Y DIRECTION :', T40, 0P,I12 /
     8        '  NUMBER OF TRACED RAYS     :', T40, 0P,I12 /
     9        '  NUMBER OF SUCCESSFUL RAYS :', T40, 0P,I12)
8050  FORMAT ('  TOTAL UNATTENUATED RAY WEIGHT :', T40, 0P,F12.5 /
     1        '  TOTAL STREHL-REDUCED RAY WEIGHT :', T40, 0P,F12.5 /
     2        '  TOTAL SCATTERED RAY WEIGHT :', T40, 1P,E12.5)
8060  FORMAT (/ '  ACCURACY OF G(V**2) TABLES :', T40, F12.4 /
     1          '  IMPLIED DYNAMIC RANGE OF TABLES :', T40, 1P,E12.4 //
     2          '  ACCURACY OF F(VZ**2*SIG**2) TABLE :', T40, 0P,F12.4 /
     3          '  IMPLIED DYNAMIC RANGE OF TABLE :', T40, 1P,E12.4 /
     4          '  IMPLIED MAX OF VZ**2 * SIG**2 :', T40, 0P,F12.4)
8080  FORMAT (/ '  REAL PART OF DIELECTRIC CONSTANT :', T40, 1P,E12.5 /
     1          '  IMAG PART OF DIELECTRIC CONSTANT :', T40, 1P,E12.5 /
     2          '  ACCURACY OF R(SIN THETA) TABLE :', T40, 0P,F12.4 /
     3          '  IMPLIED DYNAMIC RANGE OF TABLE :', T40, 1P,E12.4 /
     4          '  IMPLIED MAX OF SIN THETA :', T40, 0P,F12.5 /
     5          '  IMPLIED MIN OF R (SIN THETA) :', T40, 1P,E12.4)
8100  FORMAT (/ T15,
     1  'ROUGHNESS DEFINITION INFORMATION FOR DEFINITION #', I3 / T15,
     2  '----------------------------------------------------')
8110  FORMAT ('  IMPLIED MAX V**2 ((RAD/DIST)**2) :', T40, 1P,E12.4 /
     1        '  IMPLIED MAX G (V**2) :', T40, 1P,E12.4 /
     2        '  IMPLIED MIN G (V**2) :', T40, 1P,E12.4)
8115  FORMAT ('  MAX ALLOWED U-LOBE # :', T40, 0P,I12 /
     1        '  MAX ALLOWED V-LOBE # :', T40, 0P,I12)
8120  FORMAT ('  USER METHOD # 101 :' /
     1        '  ACV (R) = A * K0 (B * R) + C * EXP (- D * R)' /
     2        '  (A, B, C, D) :' / 1P,4E12.4 /
     3        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8140  FORMAT ('  USER METHOD # 102 :' /
     1        '  ACV (R) = A * EXP (- B * R) / SQRT (B * R) +',
     2                                     ' C * EXP (- D * R)' /
     3        '  (A, B, C, D) :' / 1P,4E12.4 /
     4        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8160  FORMAT ('  USER METHOD # 103 :' /
     1        '  ACV (R) = A * K0 (B * R) + EXP (- D * R) *',
     2           ' (C + E * COS (F * R))' /
     3        '  (A, B, C, D, E, F) :' / 1P,6E12.4 /
     4        '  SIGMA**2 FOR THE THREE PROCESSES :', T40, 1P,3E12.4)
8180  FORMAT ('  USER METHOD # 104 :' /
     1        '  ACV (R) = A * EXP (- B*R) / SQRT (B*R) +',
     2           ' EXP (- D * R) * (C + E * COS (F * R))' /
     3        '  (A, B, C, D, E, F) :' / 1P,6E12.4 /
     4        '  SIGMA**2 FOR THE THREE PROCESSES :', T40, 1P,3E12.4)
8200  FORMAT ('  USER METHOD # 105 :' /
     1        '  ACV (R) = A * EXP (- B * R) + C * EXP (- D * R)' /
     2        '  (A, B, C, D) :' / 1P,4E12.4 /
     3        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8220  FORMAT ('  USER METHOD # 106 :' /
     1        '  ACV (R) = A * EXP (- B * R**2)' /
     2        '  (A, B) :' / 1P,2E12.4 /
     3        '  SIGMA**2 FOR THE ONE PROCESS :', T40, 1P,E12.4)
8240  FORMAT ('  USER METHOD # 201 :' /
     1        '  G (V) DEFINED ON', I2, ' SEGMENTS BY',
     2           ' G (V) = A * (V ** -B)')
8260  FORMAT ('  FOR SEGMENT #', I2, ' - (V0, A, B) :', T40, 1P,3E12.4)
8270  FORMAT ('  USER METHOD # 301' /
     1        '  Z (X, Y) = A * COS (B * U) + C * COS (D * V),' /
     2        '  WITH (U,V) AXES ROTATED FROM LOCAL (X,Y) BY PHI' /
     3        '  (A, B, C, D, PHI) :' / 1P,4E12.4, 0P,F12.2 /
     4        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8272  FORMAT ('  USER METHOD # 107 :' /
     1        '  ACV (R) = A * EXP (- B*R) * COS (C*R) +',
     2           ' D * EXP (- E*R) * COS (F*R)' /
     3        '  (A, B, C, D, E, F) :' / 1P,6E12.4 /
     4        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8274  FORMAT ('  USER METHOD # 108 :' /
     1        '  ACV (R) = A * EXP (- B*R) * COS (C*R) +',
     2           ' D * EXP (- E*R**2) * COS (F*R)' /
     3        '  (A, B, C, D, E, F) :' / 1P,6E12.4 /
     4        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8276  FORMAT ('  USER METHOD # 109 :' /
     1        '  ACV (R) = A * EXP (- B*R**2) * COS (C*R) +',
     2           ' D * EXP (- E*R**2) * COS (F*R)' /
     3        '  (A, B, C, D, E, F) :' / 1P,6E12.4 /
     4        '  SIGMA**2 FOR THE TWO PROCESSES :', T40, 1P,2E12.4)
8278  FORMAT ('  USER METHOD # 110 :' /
     1        '  ACV (R) via PSD (F) = const([A=SIGMA**2]) / (F**2 +',
     2           ' [C=f0]**2) ** ([B=b]/2)' /
     3        '  (A, B, C) :' / 1P,3E12.4 /
     4        '  SIGMA**2 FOR THE ONE PROCESS :', T40, 1P,E12.4)
8280  FORMAT ('  TOTAL SIGMA**2 FOR DEFINITION :', T40, 1P,E12.4)
8300  FORMAT (/ T22, 'SURFACE INFORMATION FOR SURFACE #', I3 /
     1          T22, '------------------------------------' /)
8320  FORMAT ('  (MIN, MAX) GRAZING INCIDENCE ANGLE :', T40, 2F12.4)
8340  FORMAT (I4, ' ROUGHNESS REGION(S) DEFINED ON SURFACE')
8360  FORMAT ('  FOR REGION #', I3, ', USING ROUGHNESS DEFINITION #',
     1 I3, ' - -' / '  (XMIN, XMAX, YMIN, YMAX) :' / 1P,4E12.4)
8380  FORMAT ('  FOR REGION #', I3, ', USING ROUGHNESS DEFINITION #',
     1 I3, ' - -' / '  (ZMIN, ZMAX, THETA-MIN, THETA-MAX) :' / 1P,4E12.4
     2 )
!  (ALLOW FOR FULL LARGE AMPLITUDE COUNT)
8400  FORMAT (/ '  FOR ROUGHNESS DEFINITION #', I3, ' - -' /
     1          '  MAXIMUM ACTUAL VALUE OF V**2 :', T40, 1P,E12.4 /
     2          '  CALC''S (TAYLOR, NON-TAYLOR, FULL LARGE-AMPL):',
     3          T50, 3I6)
!  (DO OUTPUT WITHOUT MAX V**2 IF EVERYTHING WAS FULL LARGE AMPL)
8410  FORMAT (/ '  FOR ROUGHNESS DEFINITION #', I3, ' - -' /
     2          '  CALC''S (TAYLOR, NON-TAYLOR, FULL LARGE-AMPL):',
     3          T50, 3I6)
8420  FORMAT (/ '  FOR ROUGHNESS DEFINITION #', I3, ' - -' /
     1          '  MAXIMUM ACTUAL LOBE # (U, V) :', T40, 2F12.1 /
     2          '  NO. OF GRATING CALCULATIONS :', T40, I12)
8460  FORMAT ('  VZ**2*SIG**2 (MAX) (NON-TAYLOR, FULL LARGE-AMPL):',
     1        T55, F12.4)
8480  FORMAT (/ '  (NO CALCULATIONS PERFORMED FOR DEFINITION #',I3, ')')
      END
