!+
!KWIC delgra.f
!
!$Id: delgra.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . initialize PI2 with PARAMETER; add PI
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 2/26/88 TO CHANGE COMMON /AMNMX/ AND TO ASSUME THAT
!  IRFLG2 IS FALSE, SINCE REFLECTIVITY VARIATIONS ARE GONE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE DELGRA (METH, PU, PV, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITFL)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DELGRA FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/16/81
C    *
C    *    UPDATE:   02/05/82
C    *    TIME:     13:24:05
C    *
C    ******************************************/
C
C  FIND ENERGY IN GRATING LOBE, UPDATE PROPER FOCAL PLANE PIXEL
C
C  INPUT PARAMETERS :
C    PU     : R*4 - U LOBE INDEX
C    PV     : R*4 - V LOBE INDEX
C    STH    : R*4 - SIN OF THETA-1 (COMP OF GRAZING ANGLE)
C    CTH    : R*4 - COS OF THETA-1 (COMP OF GRAZING ANGLE)
C    SPSI   : R*4 - SIN OF PSI (ANGLE OF GRATING FROM LOCAL CS)
C    CPSI   : R*4 - COS OF PSI
C    P1-P6  : R*4 - CONVERSION COEFFICIENTS CALCULATED BY FPGRAT
C    IRFLG2 : LOGICAL*1 - .TRUE.  = DO REFLECTIVITY
C                         .FALSE. = DON'T DO REFLECTIVITY
C    IHITFL : I*4 - -99 = CALCULATE MIN-MAX FOR SIN-OF-GRAZING-ANGLES
C                        AT FOLLOWING SURFACES (ONLY PURPOSE OF CALL)
C                   -1 OR 1 REFLECTS CONDITION OF PREVIOUS LOBES :
C                           -1 = ALL FAILED
C                           1  = AT LEAST ONE NOT FAILED
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    KURF : I*4 - NUMBER OF CURRENT SURFACE
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZLAM     : R*4 - SYSTEM WAVELENGTH
C    ZK       : R*4 - SYSTEM WAVENUMBER
C    ZW (I)   : R*4 - ARRAY OF RAY WEIGHTS
C    DP0 (I)  : R*4 - ARRAY OF SINS-OF-GRAZING ANGLES
C    DP1S (I) : R*4 - ARRAY OF SAGGITAL DERIVATIVES OF DP0
C    DP1T (I) : R*4 - ARRAY OF TANGENTIAL DERIVATIVES OF DP0
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (5) : R*4 - NUMBER OF PIXELS IN X DIRECTION
C    FOGR (6) : R*4 - NUMBER OF PIXELS IN Y DIRECTION
C
C  OUTPUT PARAMETER :
C    IHITFL : I*4 - IF NOT -99 ON INPUT, THEN A 1 VALUE MEANS
C                   THAT THE LOBE HIT THE FOCAL PLANE
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    GRAZMN (I) : R*4 - WHEN IHITFL = -99, GRAZMN (I) IS UPDATED TO
C                       BECOME THE NEW MINIMUM OF SIN OF GRAZING
C                       ANGLE AT SURFACE # I
C    GRAZMX (I) : R*4 - MAXIMUM OF SIN-GRAZING-ANGLE
C
C  OUTPUT VIA LABELED COMMON /FPGRCO/ :
C    FPGRID (I) : R*4 - ARRAY OF FOCAL PLANE PIXEL ENERGIES
C
C  XR : EEVAL, INCLIN, !*** MMBSJN HAS BEEN REPLACED BY BESSJN ON THE VAX
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /FPGRCO/ FPGRID (1)
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION SU, SV  !*** MMBSJN HAS BEEN REPLACED BY BESSJN 
      DOUBLE PRECISION STH2, CTH2, CTH3, CDT
      LOGICAL * 1 IRFLG2

      DOUBLE PRECISION PI
      PARAMETER      ( PI       = 3.1415 92653 58979 32384 62643 D+0 )
      DOUBLE PRECISION PI2
      PARAMETER      ( PI2      = 2.D0*PI                            )

C
C
C  SET TOTAL AND CURRENT NUMBER OF COLUMNS, ROWS
      NX = FOGR (5)
      NY = FOGR (6)
      ZLAMU = PI2 / SDEF (3, METH)
      ZLAMV = PI2 / SDEF (5, METH)
      ZI = P1 + P2 * PU + P3 * PV
      ZJ = P4 + P5 * PU + P6 * PV
      I = INT (0.5 + ZI)
      J = INT (0.5 + ZJ)
      IF (IHITFL .EQ. -99) GO TO 150
      IF (I .LT. 1 .OR. I .GT. NX) GO TO 900
      IF (J .LT. 1 .OR. J .GT. NY) GO TO 900
C  (FIND ANGLE DIFFERENTIALS, EVALUATE REFLECTIVITY)
150   DELS = ZLAM * (- PU * SPSI / ZLAMU - PV * CPSI / ZLAMV)
      DELT = (ZLAM / CTH) * (PU * CPSI / ZLAMU - PV * SPSI / ZLAMV)
!
!      IF (IRFLG2) GO TO 170
!
C  (DON'T DO REFLECTIVITY - SET TERM2 AS FINAL RAY WEIGHT)
      TERM2 = ZW (NS)
      GO TO 400
!
!C  (DO REFLECTIVITY - FIND R**2 SURFACE BY SURFACE)
!170   TERM2 = ZW (KURF)
!      KURF1 = KURF + 1
!      NPRE = NS * (KURF - 1) - ((KURF - 1) * KURF) / 2
!C  (LOOP THROUGH EACH FOLLOWING SURFACE)
!      DO 350 M = KURF1, NS
!C  (DEFINE INDEX INTO DERIVATIVE ARRAYS)
!      NDX = NPRE + M - KURF
!      DP = DP0 (M) + DELS * DP1S (NDX) + DELT * DP1T (NDX)
!      IF (IHITFL .EQ. -99) GO TO 200
!C  (EVALUATE REFLECTIVITY AT THIS SURFACE)
!      IF (DP .GT. 0.) GO TO 180
!      WLOSS = 0.
!      GO TO 190
!180   CALL EEVAL (-1, DP, 0, WLOSS, DUM1, DUM2, DUM3) !*** was dum,dum,dum
!190   TERM2 = TERM2 * WLOSS
!      GO TO 350
!C  (EVALUATE MIN-MAX OF SINS OF GRAZING ANGLES)
!200   GRAZMN (M) = DMIN1 (GRAZMN (M), DP)
!      GRAZMX (M) = DMAX1 (GRAZMX (M), DP)
!350   CONTINUE
!C  (IF RAY EXTINCT OR NOT-TO-BE-CALCULATED, RETURN)
!
400   IF (TERM2 .EQ. 0. .OR. IHITFL .EQ. -99) GO TO 900
C  (SHOW LOBE SUCCESSFUL, DO BESSEL FUNCTION CALCULATIONS)
      IHITFL = 1
      C1C2 = 2. * CTH + DELT * STH
      SU = ZK * SDEF (2, METH) * C1C2
      SV = ZK * SDEF (4, METH) * C1C2
      IF (SU .GT. 1.D6) GO TO 520
      IPU = PU
!***       BJU = MMBSJN (IPU, SU, IER)  
!*** THE NUMBERS IN MMBSJN.FOR USED ON THE IBM WERE TOO BIG FOR THE VAX
      CALL BESSJN(SU,IPU,BJU,1.D-13,IER)
      GO TO 530
520   CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8000) KURF, PU, PV, SU
      BJU = 0.
530   IF (SV .GT. 1.D6) GO TO 540
      IPV = PV
!***      BJV = MMBSJN (IPV, SV, IER)
!*** THE NUMBERS IN MMBSJN.FOR USED ON THE IBM WERE TOO BIG FOR THE VAX
      CALL BESSJN(SV,IPV,BJV,1.D-13,IER)
      GO TO 550
540   CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8010) KURF, PU, PV, SV
C
550   TERM4 = BJU * BJU * BJV * BJV
C  (EVALUATE TERM3)
      CDT = 1.D0 - 0.5D0 * DELT * DELT
      STH2 = STH * CDT - CTH * DELT
      CTH2 = CTH * CDT + STH * DELT
      CTH3 = 1.D0 - 0.5D0 * (DELS / STH2) ** 2
      F3 = (1.D0 + CTH * CTH2 - STH * STH2 * CTH3) /
     1      (CTH * (CTH + CTH2))
      TERM3 = F3 * F3 / CTH2
C  (INCREMENT FOCAL PLANE PIXEL)
      DELTA = CTH * TERM2 * TERM3 * TERM4
      NDXFP = (J - 1) * NX + I
      FPGRID (NDXFP) = FPGRID (NDXFP) + DELTA
C
900   RETURN
C
8000  FORMAT ('  DELGRA WARNING - AT SURF #', I3, ', LOBE # (',
     1  F5.1, ',', F5.1, ')' / '  SU IS OUT OF BOUNDS, =', 1P,D12.4)
8010  FORMAT ('  DELGRA WARNING - AT SURF #', I3, ', LOBE # (',
     1  F5.1, ',', F5.1, ')' / '  SV IS OUT OF BOUNDS, =', 1P,D12.4)
      END
