!+
!KWIC dinit.f
!
!$Id: dinit.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ACCOMMONDATE ADDITIONAL VORTHO ARGUMENT
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO IGNORE OBSCURATION SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE DINIT
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DINIT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/11/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:01:56
C    *
C    ******************************************/
C
C  INITIALIZE BCS TRANSFORMATION MATRICES AND
C  FIND DIRECTION COSINES OF INCOMING BUNDLE
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (7)    :  R*8 - AZIMUTH ANGLE OF INCOMING BUNDLE
C    GEN (8)    :  R*8 - ELEVATION ANGLE OF INCOMING BUNDLE
C    SURF (1,J) :  R*8 - X - X COORD. AT SURFACE CENTER
C    SURF (2,J) :  R*8 - Y - Y COORD. AT SURFACE CENTER
C    SURF (3,J) :  R*8 - Z - Z COORD. AT SURFACE CENTER
C    SURF (4,J) :  R*8 - AZF - AZIMUTH OF NORMAL TO FOLD PLANE
C    SURF (5,J) :  R*8 - ELF - ELEVATION OF NORMAL TO FOLD PLANE
C                       Z AXIS WITH FOLD PLANE
C    SURF (7,J) :  R*8 - AZMIS - AZIMUTH MISALIGNMENT OF SURFACE
C                        (DEG.)
C    SURF (8,J) :  R*8 - ELMIS - ELEVATION MISALIGNMENT OF SURFACE
C                        (DEG.)
C    SURF (11,J):  R*8 - ZROT8 - ANGLE ABOUT Z FOR TOROIDAL SURFACE
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW (3,J) :  L*1 - F: NOT FLAT, T : FLAT
C    LSW (5,J) :  L*1 - F: NOT ANNULAR OBSC, T : ANNULAR OBSC
C    LSW (6,J) :  L*1 - F: NOT RECTANGULAR OBSC, T : RECTANGULAR OBSC
C    LSW (8,J) :  L*1 - F: NOT TOROIDAL, T : TOROIDAL
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    CONVERSION MATRICES FROM STD TO BCS, AND
C    DIRECTION COSINES OF INCOMING BUNDLE (V # 15)
C
C  XR : VORTHO, VSTOR
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION AZ, EL
C
C
      DO 200 I = 1, NS
!
!  IGNORE AN OBSCURATION
!
      IF (LSW (5, I) .OR. LSW (6, I)) GO TO 200
!
      NDX = 4 * I + 26
      CALL VSTOR (NDX, SURF (1, I), SURF (2, I), SURF (3, I))
C  (FIND AZ AND EL FOR VARIOUS SURFACES)
      IF (LSW (3, I)) GO TO 150
C  (NON-FLAT SURFACE)
      AZ = SURF (7, I)
      EL = SURF (8, I)
      GO TO 180
C  (FLAT SURFACE)
150   AZ = SURF (4, I) + SURF (7, I)
      EL = SURF (5, I) + SURF (8, I)
C
180   ZROT8 = 0.D0
      IF (LSW (8, I)) ZROT8 = SURF (11, I)
      CALL VORTHO (AZ, EL, ZROT8, NDX + 1, NDX + 2, NDX + 3)
200   CONTINUE
C  (FIND DIRECTION COSINES OF INCOMING BUNDLE)
      AZ = GEN (7)
      EL = GEN (8)
      CALL VAZELD (AZ, EL, 15)
C
      RETURN
      END
