!+
!KWIC dofft.f
!
!$Id: dofft.f,v 1.2 2004/03/17 21:23:33 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . initialize PI2 as PARAMETER
!-

      SUBROUTINE DOFFT (FTI)  !*** SLASHES TAKEN OUT
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    DOFFT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/07/81
C    *
C    *    UPDATE:   01/23/82
C    *    TIME:     18:18:10
C    *
C    ******************************************/
C
C  PERFORM THE APPROPRIATE FFT IN A RADIAL DIRECTION
C
C  OUTPUT VARIABLE :
C    FTI : COMPLEX*8 - FFT ARRAY
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    MING : I*4 - NUMBER OF RINGS
C
C  INPUT VIA LABELED COMMON /IOPRAM/ :
C    ZLAM : R*4 - WAVELENGTH
C    EFL  : R*4 - EFFECTIVE FOCAL LENGTH
C    RA   : R*4 - INNER RADIUS OF ANNULUS
C    RB   : R*4 - OUTER RADIUS OF ANNULUS
C    WMAX : R*4 - MAXIMUM DISTANCE FROM BEST FOCUS, TO CORNERS OF FP
C    NN   : I*4 - NUMBER OF POINTS IN FFT ARRAY
C
C  INPUT VIA LABELED COMMON /RVECTR/ :
C  IF I = RING NUMBER,
C    RAD (I)   : RADIUS OF RING
C    OPD (I)   : OPD OF POINT IN SPOKE
C    WSQRT (I) : SQRT (RAY WEIGHT) OF PONT IN SPOKE
C
C  XR : FFT2C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /IOPRAM/ FOGR (6), ZLAM, EFL, RA, RB, WMAX, NX, NY, MM, NN
      COMMON /RVECTR/ RAD (50), OPD (50), WSQRT (50)
      DIMENSION IWK (10)
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION A, B, C, D, E, F, G, RR, R1, R2, R3,
     1                 R12, R13, R23
      COMPLEX * 16 FTI (1), PUPIL, FACT, CEXPPI
      COMPLEX * 16 PUP1, PUP2, PUP3, C1, C2, C3, AP, BP, CP
      COMPLEX * 16 PCON1, PCON2

      DOUBLE PRECISION PI2
      PARAMETER      ( PI2 = 6.28318 53071 79586 48D0 )

      CEXPPI (X) = CMPLX (COS (PI2 * X), SIN (PI2 * X))
C
C
C  INITIALIZE THE ARRAY
      DO 110 I = 1, NN
      FTI (I) = (0., 0.)
110   CONTINUE
C
C  DEFINE CONSTANTS
      A = 2.D0 * WMAX / (NN - 2.D0)
      B = - WMAX
      C = - ZLAM * EFL / (A * NN)
      D = RB + 0.5D0 * C
      E = - B * C / (ZLAM * EFL)
      F = - A * D / (ZLAM * EFL)
      G = - B * D / (ZLAM * EFL)
C                                            
C  LOOP OOVER ALL GOOD SEGMENTS IN RADIAL DIRECTION
      NEXT = MING
200   IF (NEXT .EQ. 0) GO TO 1500
C  (SET UPPER INDEX OF GOOD SEGMENT)
      NLIM1 = NEXT
220   IF (NLIM1 .EQ. 0) GO TO 240
      IF (WSQRT (NLIM1) .NE. -1.) GO TO 240
      NLIM1 = NLIM1 - 1
      GO TO 220
240   IF (NLIM1 .EQ. 0) GO TO 900
C  (SET LOWER INDEX OF GOOD SEGMENT)
      NLIM2 = NLIM1
260   IF (NLIM2 .EQ. 1) GO TO 280
      IF (WSQRT (NLIM2 - 1) .EQ. -1.) GO TO 280
      NLIM2 = NLIM2 - 1
      GO TO 260
C  (SET UPPER AND LOWER R LIMITS)
280   IF (NLIM1 .EQ. MING) GO TO 300
      RLIM1 = 0.5 * (RAD (NLIM1) + RAD (NLIM1 + 1))
      GO TO 320
300   RLIM1 = RB
320   IF (NLIM2 .EQ. 1) GO TO 340
      RLIM2= 0.5 * (RAD (NLIM2) + RAD (NLIM2 - 1))
      GO TO 360
340   RLIM2 = RA
C  (SET UPPER AND LOWER LIMITS ON (J + 1))
360   J1LIM1 = IDINT ((RLIM1 - D) / C + 1.5D0)
      J1LIM2 = IDINT ((RLIM2 - D) / C + 1.5D0)
C
C  INTERPOLATE FROM J1LIM1 TO J1LIM2
C  (MAKE SURE ARRAY LIMITS NOT EXCEDED)
      J1LIM1 = MAX0 (1, J1LIM1)
      J1LIM2 = MIN0 (NN, J1LIM2)
      IF (J1LIM2 .LT. J1LIM1) GO TO 800
      NSECT = NLIM1 - NLIM2 + 1
      IF (NSECT - 2) 400, 500, 600
C
C  INTERPOLATE FOR ONLY 1 GOOD DATA POINT
400   PUPIL = WSQRT (NLIM1) * CEXPPI (OPD (NLIM1) / ZLAM)
      DO 420 JPLUS1 = J1LIM1, J1LIM2
      RR = C * (JPLUS1 - 1.D0) + D
      FTI (JPLUS1) = RR * PUPIL * CEXPPI (DBLE (E * (JPLUS1 - 1.D0)))
420   CONTINUE
      GO TO 800
C
C  INTERPOLATE FOR ONLY 2 GOOD DATA POINTS
500   PUP1 = WSQRT (NLIM1) * CEXPPI (OPD (NLIM1) / ZLAM)
      PUP2 = WSQRT (NLIM2) * CEXPPI (OPD (NLIM2) / ZLAM)
      PCON1 = (PUP2 - PUP1) / (RAD (NLIM2) - RAD (NLIM1))
      PCON2 = PUP1 - RAD (NLIM1) * PCON1
      DO 520 JPLUS1 = J1LIM1, J1LIM2
      RR = C * (JPLUS1 - 1.D0) + D
      PUPIL = PCON2 + RR * PCON1
      FTI (JPLUS1) = RR * PUPIL * CEXPPI (DBLE (E * (JPLUS1 - 1.D0)))
520   CONTINUE
      GO TO 800
C
C  INTERPOLATE FOR .GT. 2 GOOD DATA POINTS
600   NDX = NLIM1
      JPOLD = J1LIM1 - 1
C  (LOOP OVER ALL GOOD SEGMENTS)
610   IF (NDX .EQ. NLIM2) GO TO 800
      IF (NDX .EQ. NLIM2 + 1) NDX = NLIM2 + 2
C  (SET EVALUATION LIMIT INDECES)
      JBOT = JPOLD + 1
      IF (NDX .EQ. NLIM2 + 2) GO TO 620
      JTOP = IDINT ((RAD (NDX - 2) - D) / C + 1.D0)
      JPOLD = JTOP
      GO TO 640
620   JTOP = J1LIM2
C  (LOOP OVER THIS PARTICULAR GOOD SEGMENT)
640   CONTINUE
      IF (JTOP .LT. JBOT) GO TO 680
C  (SET INTERPOLATION VARIABLES)
      PUP1 = WSQRT (NDX) * CEXPPI (OPD (NDX) / ZLAM)
      PUP2 = WSQRT (NDX - 1) * CEXPPI (OPD (NDX - 1) / ZLAM)
      PUP3 = WSQRT (NDX - 2) * CEXPPI (OPD (NDX - 2) / ZLAM)
      R1 = RAD (NDX)
      R2 = RAD (NDX - 1)
      R3 = RAD (NDX - 2)
      R12 = R1 - R2
      R13 = R1 - R3
      R23 = R2 - R3
      C1 = PUP1 / (R12 * R13)
      C2 = - PUP2 / (R12 * R23)
      C3 = PUP3 / (R13 * R23)
      AP = C1 + C2 + C3
      BP = C1 * (R2 + R3) + C2 * (R1 + R3) + C3 * (R1 + R2)
      CP = C1 * R2 * R3 + C2 * R1 * R3 + C3 * R1 * R2
      DO 660 JPLUS1 = JBOT, JTOP
      RR = C * (JPLUS1 - 1.D0) + D
      PUPIL = RR * RR * AP - RR * BP + CP
      FTI (JPLUS1) = RR * PUPIL * CEXPPI (DBLE (E * (JPLUS1 - 1.D0)))
660   CONTINUE
C  (INCREMENT INDEX FOR NEXT TRIPLET OF GOOD POINTS)
680   NDX = NDX - 2
      GO TO 610
C  (INCREMENT INDEX FOR NEXT GOOD SEGMENT)
800   NEXT = NLIM2 - 1
      GO TO 200
C  (SET INDEX TO ZERO TO SHOW LAST SECTION)
900   NEXT = 0
      GO TO 200
C
C  CALCULATE AND NORMALIZE THE FFT
1500  CONTINUE
      CALL FFT2C (FTI, MM, IWK)
      DO 1520 KPLUS1 = 1, NN
      FACT = - C * CEXPPI (DBLE (F * (KPLUS1 - 1.D0) + G))
      FTI (KPLUS1) = FTI (KPLUS1) * FACT
1520  CONTINUE
      RETURN
      END
