!+
!KWIC f2refs.f
!
!$Id: f2refs.f,v 1.1 2004/03/16 15:49:50 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 10/22/91 TO STOP USING THE NASA-MODIFIED CMLIB ROUTINES,
!        !  AND USE INSTEAD THE BAUER-MODIFIED ROUTINES.  THIS IS TO MAINTAIN
!        !  COMPATIBILITY WITH CMLIB, SINCE THE NASA-MODIFIED ROUTINES WENT
!        !  FROM SINGLE TO DOUBLE PRECISION WITHOUT CHANGING THE ROUTINE NAMES,
!        !  WHILE THE NEW BAUER-MODIFIED ROUTINES USE ENTIRELY NEW NAMES.  THE
!        !  CMLIB PACKAGE IN QUESTION IS VFFT, AND THE NEW PACKAGE IS DVFFT.
!        !  THUS, ALL STATEMENTS WITH 'CALL VR...' HAVE BEEN CHANGED TO
!        !  'CALL DR...')
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 3/12/94 TO CHANGE THE FIRST LETTER IN ALL VFFT ROUTINES FROM
!        !  "D" TO "DV", SO THAT THE FFTPKG CMLIB MODULE CAN BE REPLACED BY
!        !  THE BAUER-MODIFIED DFFTPKG WITHOUT INDUCING NAME CONFLICTS
!        !  (I.E., ALL ORIGINAL 'CALL VR...' STATEMENTS ARE NOW 'CALL DVR')
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!-
      SUBROUTINE F2REFS (N, XR, MDIMR, WSAVE, SCR)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    F2REFS FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 1/9/88
C    *
C   /******************************************/
C
C  PURPOSE: PERFORM THE 2-D FORWARD/BACKWARD FFT OF A
C           REAL, EVEN, SINGLE PRECISION SQUARE INPUT ARRAY
C
C  NOTE: THIS MODIFIED VERSION (3/20/88) USES DOUBLE PRECISION
C        EVERYWHERE, TO WORK WITH THE VERSION OF THE CMLIB ROUTINES
C        WHICH HAVE BEEN MODIFIED BY HARRY FRISCH AT NASA GSFC TO
C        WORK IN DOUBLE PRECISION.
C
C  INPUT PARAMETERS:
C    N = DIMENSION OF THE SQUARE ARRAY OF NUMBERS USED AS INPUT
C    XR (MDIMR, N) = REAL, EVEN, SINGLE PRECISION ARRAY TO BE
C                    TRANSFORMED IN PLACE (I.E., XR IS LOST ON OUTPUT)
C    MDIMR = NUMBER OF ROWS, OR FIRST ACTUAL DIMENSION NUMBER,
C            IN THE FORTRAN INPUT ARRAY XR
C    WSAVE (N + 15) = A 1-D WORK ARRAY WHICH MUST BE INITIALIZED
C                     BY A CALL TO THE VFFT ROUTINE VRFFTI.  WSAVE
C                     MUST NOT BE CHANGED LATER, AND VRFFTI NEED
C                     NOT BE CALLED AGAIN, BETWEEN SUBSEQUENT CALLS
C                     TO THE VFFT PACKAGE OR THIS ROUTINE, USING THE
C                     SAME VALUE OF THE DIMENSION N.
C    SCR (N, N) = SCRATCH ARRAY
C
C  OUTPUT PARAMETERS:
C    XR (MDIMR, N) = THE FORWARD DISCRETE TRANSFORM OF XR, DEFINED BY
C      XR(L,M) = (1/N) SUM(J,K=0,N-1)
C                [EXP (-(2 PI i / N) (L J + M K)) XR(J,K)]
C      (IN THIS NOTATION, THE INDICES RANGE FROM 0 TO N-1.  THUS,
C       THE FORTRAN ARRAY INDICES ARE 1 GREATER THAN L,M,J,K.)
C    NOTE: SINCE XR IS REAL AND EVEN ON INPUT, IT IS ALSO ON OUTPUT
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION XR (MDIMR * N), SCR (N * N)
      DIMENSION WSAVE (N + 15)
C
C
C  TRANSFORM XR IN PLACE, USING THE VFFT ROUTINE VRFFTF
C
      CALL DVRFFTF (N, N, XR, SCR, MDIMR, WSAVE)
C
C  EXTEND THE REAL PART AND TRANSPOSE THE RESULT, PLACING IT IN SCR.
C  IN THE NOTATION BELOW, F(I,K) REFERS TO THE OUTPUT, WHERE
C                         I = 1 TO N = ROW NUMBER
C                         K = 0 TO N-1 = MEMBER NUMBER
C                         (I,K APPLY BEFORE TRANSPOSING)
C
      MDIMR2 = MDIMR + MDIMR
      N2 = N + N
      NMOD2 = MOD (N, 2)
      IF (NMOD2 .EQ. 0) NOVER2 = N / 2
      IF (NMOD2 .EQ. 1) NOVER2 = (N + 1) / 2
      NO2P1 = NOVER2 + 1
      NO2M1 = NOVER2 - 1
      DO 190 I = 1, N
      NDXO1 = (I - 1) * N + 1
      NDXO2 = I * N
C  (STORE F(I,0))
      SCR (NDXO1) = XR (I)
      NDXO1 = NDXO1 + 1
      NDXIN = MDIMR + I
      DO 180 K = 1, NO2M1
C  (STORE F(I,K))
      SCR (NDXO1) = XR (NDXIN)
      NDXO1 = NDXO1 + 1
C  (STORE F(I,N-K))
      SCR (NDXO2) = XR (NDXIN)
      NDXO2 = NDXO2 - 1
      NDXIN = NDXIN + MDIMR2
180   CONTINUE
      IF (NMOD2 .EQ. 1) GO TO 190
C  (STORE F(I,N/2))
      SCR (NDXO1) = XR (NDXIN)
190   CONTINUE
C
C  TRANSFORM SCR IN PLACE
C
      CALL DVRFFTF (N, N, SCR, XR, N, WSAVE)
C
C  EXTEND THE REAL PART AND TRANSPOSE THE RESULT, PLACING IT IN XR
C
      DO 290 I = 1, N
      NDXO1 = (I - 1) * MDIMR + 1
      NDXO2 = I * MDIMR + N - MDIMR
C  (STORE F(I,0)) (1,I)
      XR (NDXO1) = SCR (I)
      NDXO1 = NDXO1 + 1
      NDXIN = N + I
      DO 280 K = 1, NO2M1
C  (STORE F(I,K)) (K+1,I)
      XR (NDXO1) = SCR (NDXIN)
      NDXO1 = NDXO1 + 1
C  (STORE F(I,N-K)) (N-K+1,I)
      XR (NDXO2) = SCR (NDXIN)
      NDXO2 = NDXO2 - 1
      NDXIN = NDXIN + N2
280   CONTINUE
      IF (NMOD2 .EQ. 1) GO TO 290
C  (STORE F(I,N/2)) (N/2+1,I)
      XR (NDXO1) = SCR (NDXIN)
      NDXO1 = NDXO1 + 1
290   CONTINUE
      RETURN
      END
