!  UPDATED 5/20/97: CHANGE RTIME TO CHARACTER*(8)
!  DAVID GRUMM
!
!  UPDATED 5/9/88 TO MAKE THE OUTPUT PIXEL ARRAY DOUBLE PRECISION
!  AND TO MAKE DFID CHARACTER * 4
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 4/1/91 TO GO FROM 101x101 TO 1001x1001 PIXELS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE FILOUT (FOGOUT, ZLOUT, ITOUT, FPOUT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    FILOUT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/09/82
C    *
C    *    UPDATE:   02/23/82
C    *    TIME:     10:52:03
C    *
C    ******************************************/
C
C  PURPOSE : TO OUTPUT THE FPCOM FILE
C
C  INPUT PARAMETERS :
C    FOGOUT (6) : R*8 - ARRAY OF FOCAL PLANE DEFINITION PARAMETERS
C    ZLOUT      : R*4 - WAVELENGTH
C    ITOUT      : I*4 - FILE TYPE
C    FPOUT      : R*4 - TWO-DIMENSIONAL PIXEL ARRAY
C
C  INPUT VIA LABELED COMMON /IDENT/ :
C    GID   : R*4 - 64 CHARACTER PERMANENT IDENTIFIER LINE
C    GDATE : CHAR*8 - 8 CHARACTER DATE
C    GTIME : R*8 - 8 CHARACTER TIME
C    RID   : R*4 - 64 CHARACTER LOOK FILE IDENTIFIER LINE
C    RDATE : CHAR*8 - 8CHARACTER DATE
C    RTIME : CHAR*8 - 8 CHARACTER TIME
C
C  OUTPUT VIA UNIT # 2 :
C    BINARY FILE WITH FOLLOWING RECORDS :
C      1 : GID (1 - 16), GDATE, GTIME (1) = LOOK FILE IDENTIFIER LINE
C      2 : FOGOUT (1) -- FOGOUT (6)  (FOGOUT (5) = NX = # OF COLUMNS)
C                                    (FOGOUT (6) = NY = # OF ROWS)
C          ZLOUT = WAVELENGTH
C          ITOUT = FILE TYPE NUMBER
C      3 : FPOUT (1, 1) -- FPOUT (NX, 1) = FIRST ROW
C      4 : FPOUT (1, 2) -- FPOUT (NX, 2) = SECOND ROW
C      ETC.
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/ident.h'
C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)
!
!     REAL*4  FPOUT (101, 101)
!     DIMENSION FPOUT (101, 101)
      DIMENSION FPOUT (1001, 1001)
!
C      DOUBLE PRECISION GTIME
C      CHARACTER*4 GID,RID
C      CHARACTER*4 DFID
C      CHARACTER*(8) GDATE , RDATE, RTIME !*** WERE DOUBLE PRECISION
      DOUBLE PRECISION FOGOUT (6)
C
C
C  OUTPUT IDENTIFIERS
      WRITE (2) RID, RDATE, RTIME (1)
      WRITE (2) GID, GDATE, GTIME (1)
C
C  OUTPUT FOGOUT AND WAVELENGTH AND FILE TYPE
      WRITE (2) FOGOUT, ZLOUT, ITOUT
C
C  OUTPUT PIXEL ARRAY
      NX = FOGOUT (5)
      NY = FOGOUT (6)
      DO 200 J = 1, NY
      WRITE (2) (FPOUT (I, J), I = 1, NX)
200   CONTINUE
      RETURN
      END
