!+
!KWIC flazer.f
!
!$Id: flazer.f,v 1.2 2004/03/17 21:23:34 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Jan-27[T. Gaetz]
!      . change dimension of LSW to (10, 21) for consistency w/ other routines
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE FLAZER (KP, LP, LFO, NFO, H, NORM, KX, LX, KKODE)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    FLAZER FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 08/28/80
C    *
C    *    UPDATE:   03/12/82
C    *    TIME:     15:26:02
C    *
C    ******************************************/
C
C  REFLECTION OF A RAY OFF OF A FLAT SURFACE WITH ZERNIKE DEFORMATIONS
C
C  INPUT ARGUMENTS:
C    KP   : I*4 - IV# OF POSITION OF ENTERING RAY IN BCS
C    LP   : I*4 - IV# OF DIRECTION OF ENTERING RAY IN BCS
C    LFO  : I*4 - IV# OF THE FOLD ORIGIN WRT BCS
C    NFO  : I*4 - IV# OF UNIT FOLD NORMAL WRT BCS
C    KX   : I*4 - IV# DESIRED FOR POSITION OF REFLECTED RAY IN FOLDED
C                 COORD. SYSTEM
C    LX   : I*4 - IV# DESIRED FOR DIRECTION OF REFLECTED RAY IN FOLDED
C                 COORD. SYSTEM
C    NORM : I*4 - IV# DESIRED FOR THE NORMAL TO THE SURFACE IN BCS
C    KKODE : I*4 - RAY STATUS CODE:
C                 2 - INTERNAL REFLECTION
C
C  INPUT VIA LABELED COMMON /COMIC/:
C    PHIL : R*4 - 1/R2S
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    DEFT : R*4 - SQUARE ROOT OF THE SUM OF THE SQUARES OF DEFORMATION
C                 COEFFICIENTS
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    SWITCH FOR SURFACE #J:
C    LSW (2, J) : L*1 - F : NO DEFORMATIONS, T : DEFORMATIONS
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#S IFO, JFO, KFO, LFO, KP, LP
C
C  OUTPUT ARGUMENTS:
C    H    : R*8 - DISTANCE FROM V# KP TO V# KX
C    KKODE : I*4 - RAY STATUS CODE:
C                 0 - INCONSISTENT OR TAUTOLOGICAL EQUATION
C                 2 - INTERNAL REFLECTION
C                 6 - (XN, YN) OUT OF RANGE
C                 7 - NEGATIVE DISTANCE
C                 8 - EXCESSIVE DEFORMATION OR ZERO DIVIDE
C                 9 - TOO MANY ITERATIONS
C                 11 - UNDETERMINED ERROR ON INPUT
C                 12 - UNDETERMINED ERROR
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    Q3 :  2ND DERIVATIVE MATRIX FILLED INSTEAD WITH
C          S-HAT AND T-HAT VECTORS
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#S KX, LX, NORM
C
C  EXTERNAL REFERENCES: ABZERN, VCROSS, VDOT, VFLECT, VFOLD, VUNIT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION VDOT
      DOUBLE PRECISION H
      DOUBLE PRECISION RNRM
C
      IF (KKODE .LT. 1 .OR. KKODE .GT. 4) GO TO 500
C
      IF (ZV (LP) .EQ. 0.0D0) GO TO 550
C
C  FIND H, DISTANCE OF POINT ON INPUT RAY TO FLAT SURFACE
      H = - ZV (KP) / ZV (LP)
C
C  IS H NEGATIVE ?
      IF (H .LT. 0.0D0) GO TO 570
C
C  FIND POSITION VECTOR OF INTERSECTION OF RAY WITH FLAT SURFACE
      XV (KX) = XV (KP) + H * XV (LP)
      YV (KX) = YV (KP) + H * YV (LP)
      ZV (KX) = ZV (KP) + H * ZV (LP)
C
C  ARE THERE DEFORMATION TERMS?
      IF (.NOT. LSW (2, KURF)) GO TO 50
C
C  INTERSECT RAY WITH DEFORMED SURFACE
      XD = XV (KX)
      YD = YV (KX)
      ZD = ZV (KX)
      XL = XV (LP)
      YL = YV (LP)
      ZL = ZV (LP)
C
C  SET THE TOLERANCE
      DEL = 64. * (DEFT + ABS (DBLE (ZD)))
      TS = DEFT * 1.0E-6 + ABS (DBLE (ZD))
C
C  PREPARE FOR ITERATION LOOP
      TEL = 0.0D0
      IT = 0
      GO TO 20
C
10    FDOT = XG * XL + YG * YL + ZL
      IF (ABS (FDOT * DEL) .LT. 4.0 * ABS (F)) GO TO 250
C
C  EVALUATE AND USE DEL
      DEL = - F / FDOT
      TEL = TEL + DEL
      XD = XD + DEL * XL
      YD = YD + DEL * YL
      ZD = ZD + DEL * ZL
C
C  EVALUATE THE SURFACE FUNCTION F
20    XN = XD * PHIL
      YN = YD * PHIL
      CALL ABZERN (XN, YN, ZAP, XAP, YAP, IER)
      IF (IER .EQ. 1) GO TO 300
      IF (IER .NE. 0) GO TO 350
      F = ZD - ZAP
      XG = - XAP
      YG = - YAP
C
      IF (ABS (F) .LT. TS) GO TO 60
      IT = IT + 1
      IF (IT .LE. 5) GO TO 10
C
C  KKODE = 9 : TOO MANY ITERATIONS
      KKODE = 9
      GO TO 600
C
50    XV (NORM) = 0.0D0
      YV (NORM) = 0.0D0
      ZV (NORM) = 1.0D0
      GO TO 65
C
C  FOUND INTERSECTION WITH DEFORMED SURFACE
60    XV (NORM) = XG
      YV (NORM) = YG
      ZV (NORM) = 1.0D0
      H = H + TEL
      XV (KX) = XD
      YV (KX) = YD
      ZV (KX) = ZD
C
C  REFLECT RAY
65    CALL VFLECT (LP, NORM, LX)
CBUG  CALL VWRITE ('FLAK', KX, LX, KX, LX, KKODE)
C
C  FOLD RAY
      CALL VFOLD (KX, LX, LFO, NFO, KX, LX)
C
C   ** ADDITIONS **  BEFORE GOING TO 600, SET UP S-HAT AND T-HAT
C  FOLD THE INCIDENT RAY
      CALL VFOLD (KP, LP, LFO, NFO, 22, 23)
C  IS THE INCIDENT RAY NORMAL TO THE SURFACE?
      DP = VDOT (LP, NORM)
      IF (ABS (DP) .GT. .9999) GO TO 150
C  NO, SET NS0 AS TRUE INDEX OF INCIDENT RAY
      NS0 = 23
      GO TO 160
C  YES, DERIVE ARBITRARY S-HAT
150   NS0 = 26
      XV (NS0) = 1.D0
      YV (NS0) = 0.D0
      ZV (NS0) = 0.D0
      DP = VDOT (NS0, LX)
      IF (ABS (DP) .LT. .9999) GO TO 160
      XV (NS0) = 0.D0
      YV (NS0) = 1.D0
C  NS0 VECTOR IS NOW DEFINITELY NON-PARALLEL TO LX VECTOR
160   CALL VCROSS (LX, NS0, 24)
      CALL VUNIT (24, 24, RNRM)
      CALL VCROSS (LX, 24, 25)
C  BRING S-HAT AND T-HAT TO STD C. S.
      CALL VDERO (KX, 24, 14, 11, 12, 13, 22, 24)
      CALL VDERO (KX, 25, 14, 11, 12, 13, 22, 25)
C  PUT S-HAT AND T-HAT INTO Q3 MATRIX
      Q3 (1) = XV (24)
      Q3 (2) = YV (24)
      Q3 (3) = ZV (24)
      Q3 (4) = XV (25)
      Q3 (5) = YV (25)
      Q3 (6) = ZV (25)
C  ** END OF ADDITIONS **
      GO TO 600
C
C  EXCESSIVE DEFORMATION OR ZERO DIVIDE
250   KKODE = 8
      GO TO 600
C
C  (XN, YN) OUT OF RANGE
300   KKODE = 6
      GO TO 600
C
C  UNDETERMINED ERROR
350   KKODE = 12
      WRITE (8, 1000)
      GO TO 600
C
C  UNDETERMINED ERROR ON INPUT
500   KKODE = 11
      WRITE (8, 1010)
      GO TO 600
C
C  INCONSISTENT OR TAUTOLOGICAL EQUATION
550   KKODE = 0
      WRITE (8, 1020)
      GO TO 600
C
C  NEGATIVE PATH LENGTH
570   KKODE = 7
C
600   RETURN
1000  FORMAT ('-FLAZER ERROR: UNDETERMINED ERROR')
1010  FORMAT ('-FLAZER ERROR: UNDETERMINED ERROR ON INPUT')
1020  FORMAT ('-FLAZER ERROR: INCONSISTENT  OR TAUTOLOGICAL EQUATION')
      END
