!+
!KWIC flxfrm.f
!
!$Id: flxfrm.f,v 1.1 2004/03/16 15:49:52 dtn Exp $
!
!Revisions:
!   95-Jan-31[T. Gaetz]
!      . bugfix:  function argument funcin is a function, but wasn'nt
!        declared as external
!-
!
!  UPDATED 10/22/91 TO STOP USING THE NASA-MODIFIED CMLIB ROUTINES,
!  AND USE INSTEAD THE BAUER-MODIFIED ROUTINES.  THIS IS TO MAINTAIN
!  COMPATIBILITY WITH CMLIB, SINCE THE NASA-MODIFIED ROUTINES WENT
!  FROM SINGLE TO DOUBLE PRECISION WITHOUT CHANGING THE ROUTINE NAMES,
!  WHILE THE NEW BAUER-MODIFIED ROUTINES USE ENTIRELY NEW NAMES.  THE
!  CMLIB PACKAGE IN QUESTION IS VFFT, AND THE NEW PACKAGE IS DVFFT.
!  THUS, ALL STATEMENTS WITH 'CALL VR...' HAVE BEEN CHANGED TO
!  'CALL DR...')
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 3/12/94 TO CHANGE THE FIRST LETTER IN ALL VFFT ROUTINES FROM
!  "D" TO "DV", SO THAT THE FFTPKG CMLIB MODULE CAN BE REPLACED BY
!  THE BAUER-MODIFIED DFFTPKG WITHOUT INDUCING NAME CONFLICTS
!  (I.E., ALL ORIGINAL 'CALL VR...' STATEMENTS ARE NOW 'CALL DVR')
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE FLXFRM (FUNCIN, RMIN, RMAX, FRAD0, RATIO,
     *                   PXOUT, IXAOUT, IXOUT, JYOUT,
     *                   X0OUT, Y0OUT, DXOUT, DYOUT, CON)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    FLXFRM FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/15/88
C    *
C   /******************************************/
C
C  PURPOSE: TRANSFORM A FUNCTION (2-D FFT) BY APPLYING MULTIPLE
C           FILTERS, EACH WITH ITS OWN APPROPRIATE GRID DENSITY.
C           THE ANSWER IS ADDED TO THE OUTPUT ARRAY, RATHER THAN
C           REPLACING IT.  THE ROUTINE ALSO MULTIPLIES THE RESULTING
C           TRANSFORM BY A USER-DEFINED CONSTANT BEFORE INCREMENTING
C           THE OUTPUT ARRAY.
C
C  NOTE: THIS MODIFIED VERSION (3/20/88) USES DOUBLE PRECISION
C        EVERYWHERE, TO WORK WITH THE VERSION OF THE CMLIB ROUTINES
C        WHICH HAVE BEEN MODIFIED BY HARRY FRISCH AT NASA GSFC TO
C        WORK IN DOUBLE PRECISION.
C
C  INPUT PARAMETERS:
C    FUNCIN: R*8 - USER-SUPPLIED REAL DOUBLE PRECISION FUNCTION OF
C                  TWO COORDINATES (X AND Y), WHOSE FUNCTIONAL OUTPUT
C                  IS THE FUNCTION TO BE TRANSFORMED.
C                  FUNCIN IS ASSUMED SYMMETRIC, SO THAT
C                  FUNCIN (-X, -Y) = FUNCIN (X, Y).
C                  FUNCIN MUST BE DECLARED EXTERNAL IN THE CALLING
C                  PROGRAM.
C    RMIN: R*8 - MINIMUM VALUE OF R (FOR ANY POLAR ANGLE THETA) AT
C                WHICH THE FUNCTION SHOULD BE EVALUATED TO GIVE GOOD
C                NUMERICAL RESULTS (OF COURSE, SMALLER VALUES
C                CAN BE USED, BUT IN THE JUDGEMENT OF THE
C                CALLING PROGRAM, THEY WOULD NOT BE NEEDED)
C    RMAX: R*8 - MAXIMUM VALUE OF R (FOR ANY POALR ANGLE THETA) AT
C                WHICH THE FUNCTION SHOULD BE EVALUATED (BEYOND THIS
C                POINT, THE FUNCTION VALUE IS JUDGED BY THE CALLING
C                PROGRAM TO BE INSIGNIFCANT)
C    FRAD0: R*8 - 1/E RADIUS OF THE INITIAL FILTER TO BE USED
C                 (IF THE PROGRAM DECIDES TO USE A SMALLER VALUE
C                 THAN RMIN, THEN IT ALSO USES A SMALLER VALUE OF
C                 FRAD0 BY THE SAME RATIO)
C    RATIO: R*8 - FACTOR BY WHICH THE SPACING AND THE FILTER LENGTH
C                 SHOULD BE MULTIPLIED BETWEEN SUCCESSIVE ITERATIONS
C    IXAOUT: I*4 - ACTUAL NUMBER OF ROWS (I.E., X-DIM) IN PXOUT
C    IXOUT: I*4 - NUMBER OF ROWS USED IN PXOUT
C    JYOUT: I*4 - NUMBER OF COLUMNS (I.E., Y-DIM) IN PXOUT
C    X0OUT: R*8 - X-COORDINATE OF PXOUT (1, 1)
C    Y0OUT: R*8 - Y-COORDINATE OF PXOUT (1, 1)
C    DXOUT: R*8 - X-SPACING BETWEEN PIXELS IN PXOUT (> 0)
C    DYOUT: R*8 - Y-SPACING BETWEEN PIXELS IN PXOUT (> 0)
C    CON: R*8 - A CONSTANT BY WHICH TO MULTIPLY THE TRANSFORMED
C               VALUE BEFORE INCREMENTING PXOUT
C
C  OUTPUT PARAMETERS:
C    PXOUT (IXAOUT, JYOUT): R*8 - OUTPUT ARRAY TO BE INCREMENTED
C                                 NOTE: THE COORDINATE CONVERSION
C                                 BETWEEN FUNCIN AND PXOUT FOLLOWS
C                                 FOURIER TRANSFORM CONVENTIONS, VIZ.
C                                 PXOUT(F) = INTGRL ( FUNCIN(R) *
C                                            EXP (- 2 pi i F R) DR )
C
C  XR: F2REFS, PXINCR, VRFFTI
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      EXTERNAL FUNCIN   ! [T. Gaetz]1995-Jan-31 bugfix
      DIMENSION PXOUT (IXAOUT, JYOUT)
      DIMENSION GINOUT (129, 129), SCR (129, 129), WSAVE (143)
      DATA N /128/, INIT /0/
      NP1 = N + 1
      NOVER2 = N / 2
      NO2P1 = NOVER2 + 1
C
C
C  INITIALIZE THE FFT ROUTINE IF THIS IS THE FIRST RUN THROUGH
C
      IF (INIT .EQ. 1) GO TO 100
      INIT = 1
      CALL DVRFFTI (N, WSAVE)
100   CONTINUE
C
C  SET THE MINIMUM SPACING (LOWER THE INPUT VALUE IF APPROPRIATE TO
C  COVER THE ENTIRE OUTPUT ARRAY)
C
      FXMAX = DMAX1 (DABS (X0OUT),
     *               DABS (X0OUT + (IXOUT - 1.D0) * DXOUT))
      FYMAX = DMAX1 (DABS (Y0OUT),
     *               DABS (Y0OUT + (JYOUT - 1.D0) * DYOUT))
      FMAX = DSQRT (FXMAX * FXMAX + FYMAX * FYMAX)
      RMINA = DMIN1 (RMIN, 1.D0 / FMAX)
      FRAD0A = FRAD0 * RMINA / RMIN
C
C  DETERMINE THE NUMBER OF CYCLES OF FILTERING/TRANSFORMING TO
C  GO THROUGH, BASED ON THE RATIO OF MAX TO MIN RADIUS
C
      NCYC = 2 + IDINT (DLOG (RMAX / RMIN) / DLOG (RATIO))
C
C  LOOP THROUGH THE FILTERING/TRANSFORMING CYCLES
C
      FR0SQ = FRAD0A * FRAD0A
      RATSQ = RATIO * RATIO
      DXY = RMINA
      DO 300 ICYC = 1, NCYC
C
C  EVALUATE THE FUNCTION ARGUMENTS AND THE FILTER
C
      RX = 0.D0
      DO 190 I = 1, NO2P1
      RY = 0.D0
      DO 180 J = 1, NO2P1
      RSQ = RX * RX + RY * RY
      IF (ICYC .GT. 1) GO TO 120
C  (CYCLE = 1)
      FILT = 0.D0
      ARG = RSQ / FR0SQ
      IF (ARG .LT. 40.D0) FILT = DEXP (- ARG)
      GO TO 150
C  (CYCLE > 1: START WITH THE FIRST (ICYC-1) PARTS OF THE FILTER)
120   JCTOP = ICYC - 1
      FILT = 1.D0
      FRADSQ = FR0SQ
      DO 130 JCYC = 1, JCTOP
      ARG = RSQ / FRADSQ
      IF (ARG .LT. 40.D0) FILT = FILT * (1.D0 - DEXP (- ARG))
      FRADSQ = FRADSQ * RATSQ
130   CONTINUE
      IF (ICYC .EQ. NCYC) GO TO 150
C  (IF CYCLE < NCYC, ADD IN THE LAST PART OF THE FILTER)
      ARG = RSQ / FRADSQ
      EXPARG = 0.D0
      IF (ARG .LT. 40.D0) EXPARG = DEXP (- ARG)
      FILT = FILT * EXPARG
C
C  THE FILTER IS FINISHED - IF NON-ZERO, EVALUATE THE FUNCTIONS,
C  MULTIPLY, AND PUT THE TWO RESULTS IN THE PROPER FOUR PLACES IN
C  GINOUT (I.E., TAKE ADVANTAGE OF THE SYMMETRY)
C
150   FLFNQ1 = 0.D0
      FLFNQ2 = 0.D0
      IF (FILT .EQ. 0) GO TO 160
      FLFNQ1 = FILT * FUNCIN (RX, RY)
      FLFNQ2 = FILT * FUNCIN (- RX, RY)
C  (QUADRANT 1 GOES TO LOWER LEFT HAND QUADRANT)
160   GINOUT (I, J) = FLFNQ1
C  (QUADRANT 2 GOES TO LOWER RIGHT HAND QUADRANT)
      IF (I .GT. 1)
     *   GINOUT (N - I + 2, J) = FLFNQ2
C  (QUADRANT 3 (=1) GOES TO UPPER RIGHT HAND QUADRANT)
      IF (I .GT. 1 .AND. J .GT. 1)
     *   GINOUT (N - I + 2, N - J + 2) = FLFNQ1
C  (QUADRANT 4 (=2) GOES TO UPPER LEFT HAND QUADRANT)
      IF (J .GT. 1)
     *   GINOUT (I, N - J + 2) = FLFNQ2
C
C  INPUT EVALUATION IS DONE - FINISH THE LOOPS OVER INPUT PIXELS
C
      RY = RY + DXY
180   CONTINUE
      RX = RX + DXY
190   CONTINUE
C
C  TRANSFORM THE FUNCTION AND DEFINE THE TRANSFORMED SAMPLING INTERVAL
C
      CALL F2REFS (N, GINOUT, NP1, WSAVE, SCR)
      DFXY = 1.D0 / (N * DXY)
C
C  REARRANGE THE RESULTS AND PUT THEM IN THE SCR ARRAY,
C  WITH THE ORIGIN IN THE MIDDLE OF THE ARRAY
C
C  (COPY THE +X AND +Y AXES TO THE ARRAY EDGES)
      DO 210 IJARR = 1, NP1
      GINOUT (IJARR, NP1) = GINOUT (IJARR, 1)
      GINOUT (NP1, IJARR) = GINOUT (1, IJARR)
210   CONTINUE
C  (COPY THE INTERNAL PIXELS)
      DO 240 IARR = 1, NO2P1
      DO 230 JARR = 1, NO2P1
C  (TRANSFER TO THE DISPLACED QUADRANT 1)
      SCR (NOVER2 + IARR, NOVER2 + JARR) = GINOUT (IARR, JARR)
C  (TRANSFER TO THE DISPLACED QUADRANT 2)
      SCR (IARR, NOVER2 + JARR) = GINOUT (NOVER2 + IARR, JARR)
C  (TRANSFER TO THE DISPLACED QUADRANT 3)
      SCR (IARR, JARR) = GINOUT (NOVER2 + IARR, NOVER2 + JARR)
C  (TRANSFER TO THE DISPLACED QUADRANT 4)
      SCR (NOVER2 + IARR, JARR) = GINOUT (IARR, NOVER2 + JARR)
230   CONTINUE
240   CONTINUE
C
C  RESCALE THE FINAL RESULTS AND INCREMENT THE OUTPUT ARRAY
C
      CONA = N * DXY * DXY * CON
      XY0INP = - NOVER2 * DFXY
      CALL PXINCR (SCR, NP1, NP1, NP1, XY0INP, XY0INP,
     *             DFXY, DFXY, PXOUT, IXAOUT, IXOUT, JYOUT,
     *             X0OUT, Y0OUT, DXOUT, DYOUT, CONA)
C
C  FINISH THE LOOP OVER FILTERING/TRANSFORMING CYCLES, AND RETURN
C
      DXY = DXY * RATIO
300   CONTINUE
      RETURN
      END
