!+
!KWIC fpfill.f
!
!$Id: fpfill.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO GO FROM 101x101 TO 1001x1001 PIXELS
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO WORK WITH EXPANDED RAY FILES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO MAKE THE OUTPUT PIXEL ARRAY DOUBLE PRECISION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE FPFILL (NSPEC, NPIXL, FOGOUT, FPIN, FPOUT)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    FPFILL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/09/82
C    *
C    *    UPDATE:   03/16/82
C    *    TIME:     14:51:07
C    *
C    ******************************************/
C
C  PURPOSE : TO FILL THE OUTPUT PIXEL ARRAY WITH THE INPUT ARRAYS
C
C  INPUT PARAMETERS :
C    NSPEC  : I*4 - NUMBER OF SPECULAR RAY FILES INPUT
C    NPIXL  : I*4 - NUMBER OF PIXEL ARRAY FILES INPUT
C    FOGOUT : R*8 - OUTPUT PIXEL ARRAY DEFINITION ARRAY
C    FPIN   : R*4 - SCRATCH ARRAY FOR INPUT PIXEL ARRAYS
C
C  OUTPUT PARAMETERS :
C    FPOUT : R*4 - OUTPUT PIXEL ARRAY
C
C  INPUT VIA #  9 - 15 : INPUT SPECULAR RAY FILES
C
C  INPUT VIA # 16 - 29 : INPUT PIXEL ARRAY FILES
C
C  XR : NONE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

!
!     REAL*4 FPOUT
!
!     DIMENSION FPIN (101, 101), FPOUT (101, 101)
      DIMENSION FPIN (1001, 1001), FPOUT (1001, 1001)
      DOUBLE PRECISION FOGIN (6), FOGOUT (6), X, Y
      DOUBLE PRECISION AX, BX, AY, BY, AI, BI, AJ, BJ
      DOUBLE PRECISION ZI, ZIMIN, ZIMAX, ZJ, ZJMIN, ZJMAX
C
C
C  SET UP LOOPING LIMITS
      NXOUT = FOGOUT (5)
      NYOUT = FOGOUT (6)
C
C  LOOP OVER SPECULAR RAY FILES
      IF (NSPEC .EQ. 0) GO TO 500
C  (DEFINE CONSTANTS FOR CONVERTING (X,Y)-INPUT TO (I,J)-OUTPUT)
      AX = FOGOUT (5) / FOGOUT (3)
      BX = 0.5D0 * FOGOUT (5) + 1.D0 - FOGOUT (1) * AX
      AY = FOGOUT (6) / FOGOUT (4)
      BY = 0.5D0 * FOGOUT (6) + 1.D0 - FOGOUT (2) * AY
      DO 400 N = 1, NSPEC
      IUNIT = 8 + N
120   READ (IUNIT, 9000) KRAY, KING, K2, JODE, JN10
      IF (KRAY .LT. 0) GO TO 400
      IF (JODE .GT. 4) GO TO 120
C  (SUCCESSFUL RAY)
!  (WITH TWO ADDITIONAL RECORDS)
      READ (IUNIT, 9010) X, Y
      I = IDINT (AX * X + BX)
      IF (I .LT. 1 .OR. I .GT. NXOUT) GO TO 120
      J = IDINT (AY * Y + BY)
      IF (J .LT. 1 .OR. J .GT. NYOUT) GO TO 120
      FPOUT (I, J) = FPOUT (I, J) + 1.D-8 * JN10
      GO TO 120
400   CONTINUE
C
C  LOOP OVER PIXEL ARRAY FILES
500   IF (NPIXL .EQ. 0) GO TO 900
      DO 800 N = 1, NPIXL
      IUNIT = 15 + N
      READ (IUNIT) FOGIN, ZLAM, ITYPE
      NXIN = FOGIN (5)
      NYIN = FOGIN (6)
      DO 520 J = 1, NYIN
      READ (IUNIT) (FPIN (I, J), I = 1, NXIN)
520   CONTINUE
C  (DEFINE CONSTANTS FOR CONVERTING (I,J)-OUTPUT TO (I,J)-INPUT)
      AI = FOGOUT (3) * FOGIN (5) / (FOGOUT (5) * FOGIN (3))
      BI = - 0.5D0 * AI * (FOGOUT (5) + 1.D0) +
     1     0.5D0 * (FOGIN (5) + 1.D0) +
     2     (FOGOUT (1) - FOGIN (1)) * FOGIN (5) / FOGIN (3)
      AJ = FOGOUT (4) * FOGIN (6) / (FOGOUT (6) * FOGIN (4))
      BJ = - 0.5D0 * AJ * (FOGOUT (6) + 1.D0) +
     1     0.5D0 * (FOGIN (6) + 1.D0) +
     2     (FOGOUT (2) - FOGIN (2)) * FOGIN (6) / FOGIN (4)
C  (LOOP OVER OUTPUT PIXELS)
C  ((ZI,ZJ) ARE (I,J) COORD'S OF LOWER LEFT CORNER OF OUTPUT PIXEL,
C  RELATIVE TO INPUT GRID SYSTEM)
      ZI = BI - 0.5D0 * AI
      DO 700 I = 1, NXOUT
      ZI = ZI + AI
      IF (ZI .GT. FOGIN (5) + 0.5D0) GO TO 700
      IF (ZI + AI .LT. 0.5D0) GO TO 700
      ZJ = BJ - 0.5D0 * AJ
      DO 600  J = 1, NYOUT
      ZJ = ZJ  + AJ
      IF (ZJ .GT. FOGIN (6) + 0.5D0) GO TO 600
      IF (ZJ + AJ .LT. 0.5D0) GO TO 600
      IBOT = MAX0 (1, IDINT (ZI + 0.5D0))
      ITOP = MIN0 (NXIN, IDINT (ZI + AI + 0.5D0))
      JBOT = MAX0 (1, IDINT (ZJ + 0.5D0))
      JTOP = MIN0 (NYIN, IDINT (ZJ + AJ + 0.5D0))
C  (LOOP OVER APPROPRIATE INPUT PIXELS)
      DO 560 IIN = IBOT, ITOP
      DO 550 JIN = JBOT, JTOP
      ZIMIN = DMAX1 (ZI, -0.5D0 + IIN)
      ZIMAX = DMIN1 (ZI + AI, 0.5D0 + IIN)
      ZJMIN = DMAX1 (ZJ, -0.5D0 + JIN)
      ZJMAX = DMIN1 (ZJ + AJ, 0.5D0 + JIN)
      IF (ZIMIN .GE. ZIMAX .OR. ZJMIN .GE. ZJMAX) GO TO 550
      P = (ZIMAX - ZIMIN) * (ZJMAX - ZJMIN)
      FPOUT (I, J) = FPOUT (I, J) + P * FPIN (IIN, JIN)
550   CONTINUE
560   CONTINUE
600   CONTINUE
700   CONTINUE
800   CONTINUE
900   RETURN
C
9000  FORMAT (5I10)
!  (READ TWO MORE RECORDS)
9010  FORMAT (2D25.17 / / / /)
      END
