!+
!KWIC fpgrat.f
!
!$Id: fpgrat.f,v 1.2 2004/03/17 21:23:35 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!      . convert PI2, RAD to real*8 values; initialize as parameters
!   95-Mar-21[T. Gaetz]
!      . /PARM/: add save stmt; move to include file
!   95-Jan-26[T. Gaetz]
!      . comment out IRFLG declaration; never used
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO CHANGE COMMON /AMNMX/ AND GET RID OF IRFLG
!  (ALL CALLS TO DELGRA WITH IRFLG2 AS A PARAMETER HAVE BEEN 
!  CHANGED TO USE IFALSE)
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!      SUBROUTINE FPGRAT (IRFLG, METH, STR)
!
      SUBROUTINE FPGRAT (METH, STR)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    FPGRAT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/17/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:04:25
C    *
C    ******************************************/
C
C  UPDATE FOCAL PLANE ARRAY AND STREHL FACTOR FOR GRATING SURFACE
C
C  INPUT PARAMETERS :
C    METH  : I*4 - SCATTER DEFINITION NUMBER
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    SURF (4, KURF)  : R*8 - P CONIC CONSTANT
C    SURF (5, KURF)  : R*8 - K CONIC CONSTANT
C    SURF (11, KURF) : R*8 - AZIMUTH OF FLAT NORMAL
C    SURF (12, KURF) : R*8 - ELEVATION OF FLAT NORMAL
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    KURF : I*4 - NUMBER OF CURRENT SURFACE
C    NS   : I*4 - TOTAL NUMBER OF SURFACES
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (3, KURF) : LOGICAL*1 - FLAT SURFACE SWITCH
C    LSW (9, KURF) : LOGICAL*1 - XRAY SURFACE SWITCH
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5  : FOCAL PLANE INTERSECTION POSITION
C    V # 12 : CURRENT SURFACE INTERSECTION POSITION
C    V # 13 : CURRENT SURFACE INTERSECTION DIRECTION
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZLAM     : R*4 - SYSTEM WAVELENGTH
C    ZK       : R*4 - SYSTEM WAVENUMBER
C    ZW       : R*4 - ARRAY OF RAY WEIGHTS AT EACH SURFACE
C    SFX,SFY,TFX,TFY (I) : ARRAYS OF SUSEQ SCALE FACTORS
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    FOGR (I) : R*4 - ARRAY OF FOCAL PLANE PIXEL ARRAY DEFINITION PARAMS
C
C  OUTPUT PARAMETER :
C    STR : R*4 - STREHL FACTOR FOR SCATTER AT CURRENT SURFACE
C
C  OUTPUT VIA LABELED COMMON /AMNMX/ :
C    ARGMAX (1, I, J) : R*4 - MAX U-LOBE NUMBER
C    ARGMAX (2, I, J) : R*4 - MAX V-LOBE NUMBER
C    NCALC (I, J)  : I*4 - ARRAY OF NUMBER-OF-CALCULATIONS-DONE
C                          FOR EACH METHOD AT EACH SURFACE
C
C  XR : DELGRA, VAZELD, VDOT, VSTOR, VUNIT
C       !***MMBSJN WAS REPLACED BY BESSJN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /AMNMX/ ARGMAX (2, 5, 21), GRAZMN (21), GRAZMX (21),
     1 VZSIMX (5, 21), NCALC (5, 21), NCALC1 (5, 21), NCALC2 (5, 21),
     2 NDEFS, NAREAS (21)
      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)
      DOUBLE PRECISION VDOT !*** MMBSJN 
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION XX, YY, RR, PZK, ZPRM, RPRM, SIZE
      DOUBLE PRECISION SU, SV
!tjg  LOGICAL * 1 IRFLG, IRFLG2
      LOGICAL * 1        IRFLG2
      LOGICAL * 1 IFALSE
      real*8      PI2
      parameter ( PI2 = 6.283185307179586476925287d0 )
      real*8      RAD
      parameter ( RAD = 1.7453292519943295769237d-2 )
      DATA IFALSE /.FALSE./
C
C
C  SHOW ONE MORE GRATING CALCULATION DONE
      NCALC (METH, KURF) = NCALC (METH, KURF) + 1
C
C
C  SET INTEGER TOTAL COLUMN, ROW NUMBERS
      NX = FOGR (5)
      NY = FOGR (6)
C
C
C  DEFINE ORIENTATION OF LOCAL COORDINATE SYSTEM
      IF (LSW (3, KURF)) GO TO 200
C  (SURFACE IS NOT FLAT)
      XX = XV (12)
      YY = YV (12)
      RR = DSQRT (XX * XX + YY * YY)
      PZK = SURF (5, KURF) - SURF (4, KURF) * ZV (12)
!     IF (LSW0 (1)) GO TO 180
      IF (LSW (9, KURF)) GO TO 180
C  (CONVENTIONAL SYSTEM)
      ZPRM = RR / PZK
      IF (DABS (ZPRM) .LT. 1.D-30) GO TO 120
      CALL VSTOR (20, - XX, - YY, - ZPRM * RR)
      CALL VSTOR (21, - YY, XX, 0.D0)
      GO TO 280
120   CALL VSTOR (20, 1.D0, 0.D0, 0.D0)
      CALL VSTOR (21, 0.D0, 1.D0, 0.D0)
      GO TO 280
C  (X-RAY SYSTEM)
180   RPRM = PZK / RR
      CALL VSTOR (20, RPRM * XX, RPRM * YY, RR)
      CALL VSTOR (21, -YY, XX, 0.D0)
      GO TO 280
C  (FLAT SURFACE)
C  (FOR A FLAT, THE NORMAL IS THE Z AXIS OF THE XFRM MATRIX - GET IT)
200   NDX = 4 * KURF + 29
      CALL VSTOR (22, XV (NDX), YV (NDX), ZV (NDX))
      IF (DABS (YV (22)) .EQ. 1.D0) GO TO 220
C  (MIRROR NORMAL NOT PARALLEL TO X-AXIS)
      IF (ZV (22) .LT. 0.D0) GO TO 210
      XV (22) = - XV (22)
      YV (22) = - YV (22)
      ZV (22) = - ZV (22)
210   CALL VSTOR (20, -XV (22) * YV (22),
     1  1.D0 - YV (22) * YV (22), - YV (22) * ZV (22))
      CALL VSTOR (21, - ZV (22), 0.D0, XV (22))
      GO TO 280
C  (MIRROR NORMAL PARALLEL TO Y-AXIS)
220   CALL VSTOR (20, 0.D0, 0.D0, 1.D0)
      CALL VSTOR (21, 1.D0, 0.D0, 0.D0)
C
280   CALL VUNIT (20, 20, SIZE)
      CALL VUNIT (21, 21, SIZE)
C  (FIND PSI, ANGLE OF GRATING RELATIVE TO LOCAL COORDINATE SYSTEM)
      ALPHX = VDOT (13, 20)
      ALPHY = VDOT (13, 21)
      ALPHA = ATAN2 (ALPHY, ALPHX)
      PSI = RAD * SDEF (6, METH) - ALPHA
      SPSI = SIN (PSI)
      CPSI = COS (PSI)
!
!C  (SET LOCAL REFLECTIVITY FLAG)
!      IF (KURF .EQ. NS) GO TO 320
!      IRFLG2 = IRFLG
!      GO TO 330
!
320   IRFLG2 = IFALSE
C  (CALCULATE BASIC PARAMETERS FOR ALL GRATINGS)
330   CTH = DP0 (KURF)
      CTHSQ = CTH * CTH
      STHSQ = 1. - CTHSQ
      STH = SQRT (STHSQ)
      P1 = (FOGR (5) / FOGR (3)) * (XV (5) - FOGR (1)) +
     1  (FOGR (5) + 1.D0) / 2.D0
      P4 = (FOGR (6) / FOGR (4)) * (YV (5) - FOGR (2)) +
     1  (FOGR (6) + 1.D0) / 2.D0
C  (EVALUATE P2, P5 IF THERE IS U-RIPPLE)
      IF (SDEF (2, METH) .EQ. 0.) GO TO 420
      ZLAMU = PI2 / SDEF (3, METH)
      P2 = (FOGR (5) * ZLAM / (FOGR (3) * ZLAMU)) *
     1  (- SFX (KURF) * SPSI + TFX (KURF) * CPSI / CTH)
      P5 = (FOGR (6) * ZLAM / (FOGR (4) * ZLAMU)) *
     1  (- SFY (KURF) * SPSI + TFY (KURF) * CPSI / CTH)
C  (EVALUATE P3, P6 IF THERE IS V-RIPPLE)
420   IF (SDEF (4, METH) .EQ. 0.) GO TO 340
      ZLAMV = PI2 / SDEF (5, METH)
      P3 = (FOGR (5) * ZLAM / (FOGR (3) * ZLAMV)) *
     1  (- SFX (KURF) * CPSI - TFX (KURF) * SPSI / CTH)
      P6 = (FOGR (6) * ZLAM / (FOGR (4) * ZLAMV)) *
     1  (- SFY (KURF) * CPSI - TFY (KURF) * SPSI / CTH)
C
C  CHOOSE WHICH LOBE LOOP TO PERFORM
340   IF (SDEF (2, METH) .EQ. 0.) GO TO 1000
      IF (SDEF (4, METH) .EQ. 0.) GO TO 2000
      GO TO 3000
C
C  LOOP FOR ALL PV, WITH PU = 0
1000  IDONE = -1
      IOLDFL = -1
      MXORDV = SDEF (8, METH)
      DO 1040 IPVABS = 1, MXORDV
      PVABS = IPVABS
      IHITFL = -1
      CALL DELGRA (METH, 0d0, - PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITFL)
      CALL DELGRA (METH, 0d0, PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITFL)
      IF (IOLDFL .GT. 0 .AND. IHITFL .LT. 0) GO TO 1020
      IOLDFL = IHITFL
      GO TO 1030
1020  IDONE = 1
1030  IF (IDONE .GT. 0) GO TO 1100
1040  CONTINUE
C  (EVALUATE PV ON ALL 4 BOUNDARIES TO GET MAX VALUE)
1100  IF (ABS (P3) .LT. 1.E-30) GO TO 1180
      PPV1 = (0.5 - P1) / P3
      PPJ1 = P4 + P6 * PPV1
      IF (PPJ1 .LT. 0.5 .OR. PPJ1 .GT. (NY + 0.5)) PPV1 = 0.
      PPV2 = (NX + 0.5 - P1) / P3
      PPJ2 = P4 + P6 * PPV2
      IF (PPJ2 .LT. 0.5 .OR. PPJ2 .GT. (NY + 0.5)) PPV2 = 0.
      GO TO 1200
1180  PPV1 = 0.
      PPV2 = 0.
1200  IF (ABS (P6) .LT. 1.E-30) GO TO 1280
      PPV3 = (0.5 - P4) / P6
      PPI3 = P1 + P3 * PPV3
      IF (PPI3 .LT. 0.5 .OR. PPI3 .GT. (NX + 0.5)) PPV3 = 0.
      PPV4 = (NY + 0.5 - P4) / P6
      PPI4 = P1 + P3 * PPV4
      IF (PPI4 .LT. 0.5 .OR. PPI4 .GT. (NX + 0.5)) PPV4 = 0.
      GO TO 1300
1280  PPV3 = 0.
      PPV4 = 0.
1300  PVMAX = MAX (ABS (PPV1), ABS (PPV2), ABS (PPV3), ABS (PPV4)) 
      ARGMAX (2, METH, KURF) = MAX (ARGMAX (2, METH, KURF), PVMAX)
      GO TO 5000
C
C  LOOP FOR ALL PU, WITH PV = 0
2000  IDONE = -1
      IOLDFL = -1
      MXORDU = SDEF (7, METH)
      DO 2040 IPUABS = 1, MXORDU
      PUABS = IPUABS
      IHITFL = -1
      CALL DELGRA (METH, - PUABS, 0d0, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITFL)
      CALL DELGRA (METH, PUABS, 0d0, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITFL)
      IF (IOLDFL .GT. 0 .AND. IHITFL .LT. 0) GO TO 2020
      IOLDFL = IHITFL
      GO TO 2030
2020  IDONE = 1
2030  IF (IDONE .GT. 0) GO TO 2100
2040  CONTINUE
C  (EUALUATE PU ON ALL 4 BOUNDARIES TO GET MAX UALUE)
2100  IF (ABS (P2) .LT. 1.E-30) GO TO 2180
      PPU1 = (0.5 - P1) / P2
      PPJ1 = P4 + P5 * PPU1
      IF (PPJ1 .LT. 0.5 .OR. PPJ1 .GT. (NY + 0.5)) PPU1 = 0.
      PPU2 = (NX + 0.5 - P1) / P2
      PPJ2 = P4 + P5 * PPU2
      IF (PPJ2 .LT. 0.5 .OR. PPJ2 .GT. (NY + 0.5)) PPU2 = 0.
      GO TO 2200
2180  PPU1 = 0.
      PPU2 = 0.
2200  IF (ABS (P5) .LT. 1.E-30) GO TO 2280
      PPU3 = (0.5 - P4) / P5
      PPI3 = P1 + P2 * PPU3
      IF (PPI3 .LT. 0.5 .OR. PPI3 .GT. (NX + 0.5)) PPU3 = 0.
      PPU4 = (NY + 0.5 - P4) / P5
      PPI4 = P1 + P2 * PPU4
      IF (PPI4 .LT. 0.5 .OR. PPI4 .GT. (NX + 0.5)) PPU4 = 0.
      GO TO 2300
2280  PPU3 = 0.
      PPU4 = 0.
2300  PUMAX = MAX (ABS (PPU1), ABS (PPU2), ABS (PPU3), ABS (PPU4))
      ARGMAX (1, METH, KURF) = MAX (ARGMAX (1, METH, KURF), PUMAX)
      GO TO 5000
C
C  LOOP FOR ALL PU AND ALL PV
3000  MXORDU = SDEF (7, METH)
      MXORDV = SDEF (8, METH)
      IDONEU = -1
      IDONEV = -1
      IOLDV = -1
C  (CALCULATE FOR ALL PV WITH PU = 0)
      DO 3040 IPVABS = 1, MXORDV
      PVABS = IPVABS
      IHITU = -1
      CALL DELGRA (METH, 0d0, - PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITU)
      CALL DELGRA (METH, 0d0, PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITU)
      IHITV = IHITU
      IF (IOLDV .GT. 0 .AND. IHITV .LT. 0) GO TO 3020
      IOLDV = IHITV
      GO TO 3030
3020  IDONEV = 1
3030  IF (IDONEV .GT. 0) GO TO 3100
3040  CONTINUE
C  (SET ONE MORE FLAG FOR OVERALL U LOOP)
3100  IOLDU = IHITU
C  (LOOP FOR ALL PU, WITH THE REMAINING PV .NE. 0)
      DO 3300 IPUABS = 1, MXORDU
      PUABS = IPUABS
      IHITU = -1
      CALL DELGRA (METH, - PUABS, 0d0, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITU)
      CALL DELGRA (METH, PUABS, 0d0, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITU)
      IDONEV = -1
      IOLDV = IHITU
C  (DO INNERMOST LOOP WHERE PV .NE. 0)
      DO 3180 IPVABS = 1, MXORDV
      PVABS = IPVABS
      IHITV = -1
      CALL DELGRA (METH, - PUABS, - PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITV)
      CALL DELGRA (METH, PUABS, - PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITV)
      CALL DELGRA (METH, - PUABS, PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITV)
      CALL DELGRA (METH, PUABS, PVABS, STH, CTH, SPSI, CPSI,
     1  P1, P2, P3, P4, P5, P6, IRFLG2, IHITV)
      IF (IHITV .EQ. 1) IHITU = 1
      IF (IOLDV .GT. 0 .AND. IHITV .LT. 0) GO TO 3160
      IOLDV = IHITV
      GO TO 3170
3160  IDONEV = 1
3170  IF (IDONEV .GT. 0) GO TO 3200
3180  CONTINUE
C
3200  IF (IOLDU .GT. 0 .AND. IHITU .LT. 0) GO TO 3250
      IOLDU = IHITU
      GO TO 3270
3250  IDONEU = 1
3270  IF (IDONEU .GT. 0) GO TO 3500
3300  CONTINUE
C  (EVALUATE PU AND PV ON ALL 4 CORNERS TO GET MAX VALUES)
3500  DETINV = 1. / (P2 * P6 - P3 * P5)
      PPU1 = ((0.5 - P1) * P6 - (0.5 - P4) * P3) * DETINV
      PPU2 = ((NX + 0.5 - P1) * P6 - (0.5 - P4) * P3) * DETINV
      PPU3 = ((0.5 - P1) * P6 - (NY + 0.5 - P4) * P3) * DETINV
      PPU4 = ((NX + 0.5 - P1) * P6 - (NY + 0.5 - P4) * P3) * DETINV
      PUMAX = MAX (ABS (PPU1), ABS (PPU2), ABS (PPU3), ABS (PPU4))
C
      PPV1 = ((0.5 - P4) * P2 - (0.5 - P1) * P5) * DETINV
      PPV2 = ((0.5 - P4) * P2 - (NX + 0.5 - P1) * P5) * DETINV
      PPV3 = ((NY + 0.5 - P4) * P2 - (0.5 - P1) * P5) * DETINV
      PPV4 = ((NY + 0.5 - P4) * P2 - (NX + 0.5 - P1) * P5) * DETINV
      PVMAX = MAX (ABS (PPV1), ABS (PPV2), ABS (PPV3), ABS (PPV4))
C
      ARGMAX (1, METH, KURF) = MAX (ARGMAX (1, METH, KURF), PUMAX)
      ARGMAX (2, METH, KURF) = MAX (ARGMAX (2, METH, KURF), PVMAX)
!
5000  GO TO 5200
!C
!C  USE DELGRA (IF NECESSARY) TO CALCULATE MIN-MAX OF SIN-GRAZING-ANGLES
!5000  IF (.NOT. IRFLG2) GO TO 5200
!      CALL DELGRA (METH, PPU1, PPV1, STH, CTH, SPSI, CPSI,
!     1  P1, P2, P3, P4, P5, P6, IRFLG2, -99)
!      CALL DELGRA (METH, PPU2, PPV2, STH, CTH, SPSI, CPSI,
!     1  P1, P2, P3, P4, P5, P6, IRFLG2, -99)
!      CALL DELGRA (METH, PPU3, PPV3, STH, CTH, SPSI, CPSI,
!     1  P1, P2, P3, P4, P5, P6, IRFLG2, -99)
!      CALL DELGRA (METH, PPU4, PPV4, STH, CTH, SPSI, CPSI,
!     1  P1, P2, P3, P4, P5, P6, IRFLG2, -99)
C
C  EVALUATE STR, THE STREHL FACTOR
5200  SU = 2. * ZK * SDEF (2, METH) * CTH
      SV = 2. * ZK * SDEF (4, METH) * CTH
!***      BJU = MMBSJN (0, SU, IER)
!***      BJV = MMBSJN (0, SV, IER)
!*** THE FUNCTION MMBSJN HAS BEEN REPLACED WITH SUBROUTINE BESSJN
!*** 
      CALL BESSJN(SU,0,BJU,1.D-13,IER)
      CALL BESSJN(SV,0,BJV,1.D-13,IER)
      STR = BJU * BJU * BJV * BJV
      RETURN
      END
