!+
!KWIC gcxfm0.f
!
!$Id: gcxfm0.f,v 1.1 2004/03/16 15:49:53 dtn Exp $
!
!Revisions:
!   95-Jan-23[T. Gaetz]
!      . imported from OSAC V7.0
!-
      SUBROUTINE GCXFM0 (D, F, VSQ, G0)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    GCXFRM FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/16/89
C    *
C   /******************************************/
C
C  PURPOSE: EVALUATE THE FOURIER TRANSFORM OF
C           [EXP (- D R**2) COS (F R)] IN TERMS OF THE PARAMETER
C           V**2 = (2 PI F) ** 2
C
C  INPUT PARAMETERS:
C    D: R*8 - MULTIPLIER OF (-R**2) IN EXPONENTIAL ARGUMENT
C    F: R*8 - MULTIPLIER OF R IN COSINE ARGUMENT
C    VSQ: R*8 - (2 PI F) ** 2, WHERE F IS THE FREQUENCY IN CYCLES
C               PER DISTANCE AT WHICH TO EVALUATE THE FOURIER
C               TRANSFORM
C
C  OUTPUT PARAMETERS:
C    G0: R*8 - FOURIER TRANSFORM VALUE AT V=SQRT(VSQ)
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION FCTRL2 (24)
      DATA PI /3.14159 26535 89793 23846D0/
      DATA PI2 /6.28318 53071 79586 47692D0/
C  (FCTRL2(M) IS AN ARRAY OF M!/(2M!))
      DATA FCTRL2 /5.00000000000000000000D-01,
     *             8.33333333333333300000D-02,
     *             8.33333333333333300000D-03,
     *             5.95238095238095200000D-04,
     *             3.30687830687830600000D-05,
     *             1.50312650312650300000D-06,
     *             5.78125578125578000000D-08,
     *             1.92708526041859300000D-09,
     *             5.66789782476056800000D-11,
     *             1.49155205914751800000D-12,
     *             3.55131442654170900000D-14,
     *             7.72024875335154100000D-16,
     *             1.54404975067030800000D-17,
     *             2.85935139013020000000D-19,
     *             4.92991618987965500000D-21,
     *             7.95147772561234700000D-23,
     *             1.20476935236550700000D-24,
     *             1.72109907480786800000D-26,
     *             2.32580956055117300000D-28,
     *             2.98180712891176000000D-30,
     *             3.63635015720946300000D-32,
     *             4.22831413629007300000D-34,
     *             4.69812681810008100000D-36,
     *             4.99800725329795800000D-38/
C
C
C  IF THE COSINE CONTAINS MORE THAN 0.2941 CYCLES PER 1/E RADIUS
C  OF THE GAUSSIAN - REFUSE TO DO THE TRANSFORM, AND RETURN
C  WITH A ZERO VALUE
C
      IF ((F / PI2) .GE. 0.2941D0 * DSQRT (D)) GO TO 500
      A = F * F / D
C
C  IF THE FREQUENCY IS TOO LARGE (GIVING AN EXPONENTIAL MULTIPLIER
C  SMALLER THAN 1.D-20), RETURN WITH A ZERO VALUE
C
      B = VSQ / (4.D0 * D)
      IF (B .GT. 46.05D0) GO TO 500
C
C  CALCULATE THE MULTIPLIER OF THE Q-SERIES
C
      CONST = (PI / D) * DEXP (- B)
C
C  CALCULATE Q0(M) FOR M=0 (CALL IT THE (M-1)TH TERM)
C
      Q0MM1 = 1.D0
      Q0SUM = Q0MM1
C
C  IF F=0 (NO COSINE), THEN THE CURRENT RESULTS ARE ALREADY CORRECT
C
      IF (F .EQ. 0.D0) GO TO 300
C
C  CALCULATE Q0(M) FOR M=1 (CALL IT THE MTH TERM)
C
      M = 1
      Q0M   = -0.5D0 * A * (1.D0 - B)
      Q0SUM = Q0SUM + Q0M
      INITR = 0
C
C  CALCULATE THE (M+1)TH TERM IN TERMS OF THE MTH AND (M-1)TH
C
200   FAC1 = A / (2.D0 * (M + 1) * (M + M + 1))
      FAC2 = (M + M + 1) - B
      FAC3 = (M / (2.D0 * (M + M - 1))) * A
      Q0MP1 = - FAC1 * (FAC2 * Q0M + FAC3 * Q0MM1)
C
C  INCREMENT M, AND UPDATE THE SUMS AND PREVIOUS TERMS
C
      Q0SUM = Q0SUM + Q0MP1
      M = M + 1
      Q0MM1 = Q0M
      Q0M = Q0MP1
C
C  SEE IF ENOUGH TERMS HAVE BEEN COMPUTED EVEN TO FIND A REMAINDER
C
      IF (DFLOAT (M) .LE. 0.3D0 * A) GO TO 200
C
C  YES, CALCULATE A BOUND ON THE REMAINDER
C  (DO IT EXPLICITLY THE FIRST TIME, RECURSIVELY THEREAFTER)
C
      IF (INITR .EQ. 1) GO TO 220
      INITR = 1
      REM = DEXP (B / 2.D0) * FCTRL2 (M) * A ** M /
     *      (1.D0 - 0.3D0 * A / M)
      GO TO 240
220   REM = REM * (1.D0 / (2.D0 * (M + M - 1.D0))) * A *
     *            (1.D0 - 0.3D0 * A / (M - 1.D0)) /
     *            (1.D0 - 0.3D0 * A / M)
C
C  THE REMAINDER IS CALCULATED - SEE IF THE SERIES IS GOOD ENOUGH
C
240   IF (REM .LT. DABS (1.D-6 * Q0SUM)) GO TO 300
      IF (REM .LT. 1.D-16) GO TO 300
      IF (M .EQ. 24) GO TO 300
      GO TO 200
C
C  ENOUGH TERMS ARE DONE - FINISH THE TRANSFORM
C
300   G0 = CONST * Q0SUM
      RETURN
C
C  BAD INPUT CONDITIONS - RETURN WITH A ZERO VALUE
C
500   G0 = 0.D0
      RETURN
      END
